/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ByteBuddyLocalVariableManager {
    private @UnknownKeyFor @NonNull @Initialized int nextLocalVariableIndex;

    public ByteBuddyLocalVariableManager(@UnknownKeyFor @NonNull @Initialized int numFunctionArgs) {
        this.nextLocalVariableIndex = numFunctionArgs;
    }

    public @UnknownKeyFor @NonNull @Initialized int createVariable() {
        return this.nextLocalVariableIndex++;
    }

    public @UnknownKeyFor @NonNull @Initialized StackManipulation readVariable(@UnknownKeyFor @NonNull @Initialized int variableIndex) {
        Preconditions.checkArgument((variableIndex < this.nextLocalVariableIndex ? 1 : 0) != 0);
        return MethodVariableAccess.REFERENCE.loadFrom(variableIndex);
    }

    @UnknownKeyFor @NonNull @Initialized StackManipulation readVariable(@UnknownKeyFor @NonNull @Initialized int variableIndex, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type) {
        return new StackManipulation.Compound(new StackManipulation[]{this.readVariable(variableIndex), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(type))});
    }

    @UnknownKeyFor @NonNull @Initialized StackManipulation writeVariable(@UnknownKeyFor @NonNull @Initialized int variableIndex) {
        Preconditions.checkArgument((variableIndex < this.nextLocalVariableIndex ? 1 : 0) != 0);
        return MethodVariableAccess.REFERENCE.storeAt(variableIndex);
    }

    @UnknownKeyFor @NonNull @Initialized StackManipulation copy(@UnknownKeyFor @NonNull @Initialized int sourceVariableIndex, @UnknownKeyFor @NonNull @Initialized int destVariableIndex) {
        return new StackManipulation.Compound(new StackManipulation[]{this.readVariable(sourceVariableIndex), this.writeVariable(destVariableIndex)});
    }

    @UnknownKeyFor @NonNull @Initialized ByteBuddyLocalVariableManager. @UnknownKeyFor @NonNull @Initialized BackupLocalVariable backupVariable(@UnknownKeyFor @NonNull @Initialized int variableToBackup) {
        return new BackupLocalVariable(variableToBackup);
    }

    @UnknownKeyFor @NonNull @Initialized int getTotalNumVariables() {
        return this.nextLocalVariableIndex;
    }

    public class BackupLocalVariable {
        private final @UnknownKeyFor @NonNull @Initialized int variableToBackup;
        private final @UnknownKeyFor @NonNull @Initialized int tempVariable;

        public BackupLocalVariable(int variableToBackup) {
            this.variableToBackup = variableToBackup;
            this.tempVariable = ByteBuddyLocalVariableManager.this.createVariable();
        }

        public @UnknownKeyFor @NonNull @Initialized StackManipulation backup() {
            return ByteBuddyLocalVariableManager.this.copy(this.variableToBackup, this.tempVariable);
        }

        public @UnknownKeyFor @NonNull @Initialized StackManipulation restore() {
            return ByteBuddyLocalVariableManager.this.copy(this.tempVariable, this.variableToBackup);
        }
    }
}

