/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.Arrays;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Internal;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class UserCodeException
extends RuntimeException {
    public static @UnknownKeyFor @NonNull @Initialized UserCodeException wrap(@UnknownKeyFor @NonNull @Initialized Throwable t) {
        if (t instanceof UserCodeException) {
            return (UserCodeException)t;
        }
        return new UserCodeException(t);
    }

    public static @UnknownKeyFor @NonNull @Initialized RuntimeException wrapIf(@UnknownKeyFor @NonNull @Initialized boolean condition, @UnknownKeyFor @NonNull @Initialized Throwable t) {
        if (condition) {
            return UserCodeException.wrap(t);
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException(t);
    }

    private UserCodeException(@UnknownKeyFor @NonNull @Initialized Throwable t) {
        super(t);
        this.truncateStackTrace(t);
    }

    private void truncateStackTrace(@UnknownKeyFor @NonNull @Initialized Throwable t) {
        StackTraceElement[] currentStack = Thread.currentThread().getStackTrace();
        StackTraceElement[] throwableStack = t.getStackTrace();
        int currentStackSize = currentStack.length;
        int throwableStackSize = throwableStack.length;
        if (throwableStackSize == 0) {
            return;
        }
        int commonFrames = 0;
        while (this.framesEqual(currentStack[currentStackSize - commonFrames - 1], throwableStack[throwableStackSize - commonFrames - 1]) && ++commonFrames < Math.min(currentStackSize, throwableStackSize)) {
        }
        StackTraceElement[] truncatedStack = Arrays.copyOfRange(throwableStack, 0, throwableStackSize - commonFrames);
        t.setStackTrace(truncatedStack);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean framesEqual(@UnknownKeyFor @NonNull @Initialized StackTraceElement frame1, @UnknownKeyFor @NonNull @Initialized StackTraceElement frame2) {
        boolean areEqual = Objects.equals(frame1.getClassName(), frame2.getClassName());
        return areEqual &= Objects.equals(frame1.getMethodName(), frame2.getMethodName());
    }
}

