/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.construction.CoderTranslation;
import org.apache.beam.sdk.util.construction.PCollectionTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.LoadingCache;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class RehydratedComponents {
    private final  @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components;
    private final @Nullable @UnknownKeyFor @Initialized Pipeline pipeline;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> windowingStrategies = CacheBuilder.newBuilder().build(new CacheLoader<String, WindowingStrategy<?, ?>>(){

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> load(@UnknownKeyFor @NonNull @Initialized String id) throws @UnknownKeyFor @NonNull @Initialized Exception {
             @Nullable RunnerApi.WindowingStrategy windowingStrategyProto = RehydratedComponents.this.components.getWindowingStrategiesOrDefault(id, null);
            Preconditions.checkState((windowingStrategyProto != null ? 1 : 0) != 0, (String)"No WindowingStrategy with id '%s' in serialized components", (Object)id);
            return WindowingStrategyTranslation.fromProto(windowingStrategyProto, RehydratedComponents.this);
        }
    });
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> coders = CacheBuilder.newBuilder().build(new CacheLoader<String, Coder<?>>(){

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> load(@UnknownKeyFor @NonNull @Initialized String id) throws @UnknownKeyFor @NonNull @Initialized Exception {
             @Nullable RunnerApi.Coder coder = RehydratedComponents.this.components.getCodersOrDefault(id, null);
            Preconditions.checkState((coder != null ? 1 : 0) != 0, (String)"No coder with id '%s' in serialized components", (Object)id);
            return CoderTranslation.fromProto(coder, RehydratedComponents.this, CoderTranslation.TranslationContext.DEFAULT);
        }
    });
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> pCollections = CacheBuilder.newBuilder().build(new CacheLoader<String, PCollection<?>>(){

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> load(@UnknownKeyFor @NonNull @Initialized String id) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Preconditions.checkState((RehydratedComponents.this.pipeline != null ? 1 : 0) != 0, (String)"%s Cannot rehydrate %s without a %s: provide one via .withPipeline(...)", (Object)RehydratedComponents.class.getSimpleName(), (Object)PCollection.class.getSimpleName(), (Object)Pipeline.class.getSimpleName());
            return PCollectionTranslation.fromProto(RehydratedComponents.this.components.getPcollectionsOrThrow(id), RehydratedComponents.this.pipeline, RehydratedComponents.this).setName(id);
        }
    });

    public static @UnknownKeyFor @NonNull @Initialized RehydratedComponents forComponents( @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) {
        return new RehydratedComponents(components, null);
    }

    public @UnknownKeyFor @NonNull @Initialized RehydratedComponents withPipeline(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        return new RehydratedComponents(this.components, pipeline);
    }

    private RehydratedComponents( @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @Nullable @UnknownKeyFor @Initialized Pipeline pipeline) {
        this.components = components;
        this.pipeline = pipeline;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getPCollection(@UnknownKeyFor @NonNull @Initialized String pCollectionId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            return (PCollection)this.pCollections.get((Object)pCollectionId);
        }
        catch (ExecutionException exc) {
            throw new RuntimeException(exc);
        }
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getWindowingStrategy(@UnknownKeyFor @NonNull @Initialized String windowingStrategyId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            return (WindowingStrategy)this.windowingStrategies.get((Object)windowingStrategyId);
        }
        catch (ExecutionException exc) {
            throw new RuntimeException(exc);
        }
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getCoder(@UnknownKeyFor @NonNull @Initialized String coderId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            return (Coder)this.coders.get((Object)coderId);
        }
        catch (ExecutionException exc) {
            throw new RuntimeException(exc);
        }
    }

    public  @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment getEnvironment(@UnknownKeyFor @NonNull @Initialized String environmentId) {
        return this.components.getEnvironmentsOrThrow(environmentId);
    }

    public  @UnknownKeyFor @NonNull @Initialized RunnerApi.Components getComponents() {
        return this.components;
    }

    public @UnknownKeyFor @NonNull @Initialized SdkComponents getSdkComponents(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> requirements) {
        return SdkComponents.create(this.components, Collections.emptyMap(), this.pCollections.asMap(), this.windowingStrategies.asMap(), this.coders.asMap(), Collections.emptyMap(), requirements);
    }
}

