/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;
import org.apache.hadoop.hdfs.util.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class XmlEditsVisitor
implements OfflineEditsVisitor {
    private final OutputStream out;
    private ContentHandler contentHandler;
    private final SAXTransformerFactory factory;
    private static final String XML_INDENTATION_PROP = "{http://xml.apache.org/xslt}indent-amount";
    private static final String XML_INDENTATION_NUM = "2";

    public XmlEditsVisitor(OutputStream out) throws IOException {
        this.out = out;
        this.factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            TransformerHandler handler = this.factory.newTransformerHandler();
            handler.getTransformer().setOutputProperty("method", "xml");
            handler.getTransformer().setOutputProperty("encoding", "UTF-8");
            handler.getTransformer().setOutputProperty("indent", "yes");
            handler.getTransformer().setOutputProperty(XML_INDENTATION_PROP, XML_INDENTATION_NUM);
            handler.getTransformer().setOutputProperty("standalone", "yes");
            handler.setResult(new StreamResult(out));
            this.contentHandler = handler;
            this.contentHandler.startDocument();
            this.contentHandler.startElement("", "", "EDITS", new AttributesImpl());
        }
        catch (TransformerConfigurationException e) {
            throw new IOException("SAXTransformer error: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException("SAX error: " + e.getMessage());
        }
    }

    @Override
    public void start(int version) throws IOException {
        try {
            this.contentHandler.startElement("", "", "EDITS_VERSION", new AttributesImpl());
            StringBuilder bld = new StringBuilder();
            bld.append(version);
            this.addString(bld.toString());
            this.contentHandler.endElement("", "", "EDITS_VERSION");
        }
        catch (SAXException e) {
            throw new IOException("SAX error: " + e.getMessage());
        }
    }

    public void addString(String str) throws SAXException {
        int slen = str.length();
        char[] arr = new char[slen];
        str.getChars(0, slen, arr, 0);
        this.contentHandler.characters(arr, 0, slen);
    }

    @Override
    public void close(Throwable error) throws IOException {
        try {
            this.contentHandler.endElement("", "", "EDITS");
            if (error != null) {
                String msg = error.getMessage();
                XMLUtils.addSaxString(this.contentHandler, "ERROR", msg == null ? "null" : msg);
            }
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw new IOException("SAX error: " + e.getMessage());
        }
        this.out.close();
    }

    @Override
    public void visitOp(FSEditLogOp op) throws IOException {
        try {
            op.outputToXml(this.contentHandler);
        }
        catch (SAXException e) {
            throw new IOException("SAX error: " + e.getMessage());
        }
    }
}

