/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.JsonSchemaProperty;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.internal.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;

public class ToolSpecification {
    private final String name;
    private final String description;
    private final ToolParameters parameters;

    private ToolSpecification(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.parameters = builder.parameters;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public ToolParameters parameters() {
        return this.parameters;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ToolSpecification && this.equalTo((ToolSpecification)another);
    }

    private boolean equalTo(ToolSpecification another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && Objects.equals(this.parameters, another.parameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.parameters);
        return h;
    }

    public String toString() {
        return "ToolSpecification { name = " + Utils.quoted(this.name) + ", description = " + Utils.quoted(this.description) + ", parameters = " + this.parameters + " }";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String description;
        private ToolParameters parameters;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parameters(ToolParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder addParameter(String name, JsonSchemaProperty ... jsonSchemaProperties) {
            return this.addParameter(name, Arrays.asList(jsonSchemaProperties));
        }

        public Builder addParameter(String name, Iterable<JsonSchemaProperty> jsonSchemaProperties) {
            this.addOptionalParameter(name, jsonSchemaProperties);
            this.parameters.required().add(name);
            return this;
        }

        public Builder addOptionalParameter(String name, JsonSchemaProperty ... jsonSchemaProperties) {
            return this.addOptionalParameter(name, Arrays.asList(jsonSchemaProperties));
        }

        public Builder addOptionalParameter(String name, Iterable<JsonSchemaProperty> jsonSchemaProperties) {
            if (this.parameters == null) {
                this.parameters = ToolParameters.builder().build();
            }
            HashMap<String, Object> jsonSchemaPropertiesMap = new HashMap<String, Object>();
            for (JsonSchemaProperty jsonSchemaProperty : jsonSchemaProperties) {
                jsonSchemaPropertiesMap.put(jsonSchemaProperty.key(), jsonSchemaProperty.value());
            }
            this.parameters.properties().put(name, jsonSchemaPropertiesMap);
            return this;
        }

        public ToolSpecification build() {
            return new ToolSpecification(this);
        }
    }
}

