/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.io;

import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.avro.io.AvroIO;
import org.apache.beam.sdk.io.ReadAllViaFileBasedSource;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_AvroIO_ParseFiles<T>
extends AvroIO.ParseFiles<T> {
    private final SerializableFunction<GenericRecord, T> parseFn;
    private final @Nullable Coder<T> coder;
    private final boolean usesReshuffle;
    private final ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler fileExceptionHandler;
    private final long desiredBundleSizeBytes;

    private AutoValue_AvroIO_ParseFiles(SerializableFunction<GenericRecord, T> parseFn, @Nullable Coder<T> coder, boolean usesReshuffle, ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler fileExceptionHandler, long desiredBundleSizeBytes) {
        this.parseFn = parseFn;
        this.coder = coder;
        this.usesReshuffle = usesReshuffle;
        this.fileExceptionHandler = fileExceptionHandler;
        this.desiredBundleSizeBytes = desiredBundleSizeBytes;
    }

    @Override
    SerializableFunction<GenericRecord, T> getParseFn() {
        return this.parseFn;
    }

    @Override
    @Nullable Coder<T> getCoder() {
        return this.coder;
    }

    @Override
    boolean getUsesReshuffle() {
        return this.usesReshuffle;
    }

    @Override
    ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler getFileExceptionHandler() {
        return this.fileExceptionHandler;
    }

    @Override
    long getDesiredBundleSizeBytes() {
        return this.desiredBundleSizeBytes;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AvroIO.ParseFiles) {
            AvroIO.ParseFiles that = (AvroIO.ParseFiles)((Object)o);
            return this.parseFn.equals(that.getParseFn()) && (this.coder == null ? that.getCoder() == null : this.coder.equals(that.getCoder())) && this.usesReshuffle == that.getUsesReshuffle() && this.fileExceptionHandler.equals(that.getFileExceptionHandler()) && this.desiredBundleSizeBytes == that.getDesiredBundleSizeBytes();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.parseFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.coder == null ? 0 : this.coder.hashCode();
        h$ *= 1000003;
        h$ ^= this.usesReshuffle ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.fileExceptionHandler.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(this.desiredBundleSizeBytes >>> 32 ^ this.desiredBundleSizeBytes);
    }

    @Override
    AvroIO.ParseFiles.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends AvroIO.ParseFiles.Builder<T> {
        private SerializableFunction<GenericRecord, T> parseFn;
        private @Nullable Coder<T> coder;
        private Boolean usesReshuffle;
        private ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler fileExceptionHandler;
        private Long desiredBundleSizeBytes;

        Builder() {
        }

        private Builder(AvroIO.ParseFiles<T> source) {
            this.parseFn = source.getParseFn();
            this.coder = source.getCoder();
            this.usesReshuffle = source.getUsesReshuffle();
            this.fileExceptionHandler = source.getFileExceptionHandler();
            this.desiredBundleSizeBytes = source.getDesiredBundleSizeBytes();
        }

        @Override
        AvroIO.ParseFiles.Builder<T> setParseFn(SerializableFunction<GenericRecord, T> parseFn) {
            if (parseFn == null) {
                throw new NullPointerException("Null parseFn");
            }
            this.parseFn = parseFn;
            return this;
        }

        @Override
        AvroIO.ParseFiles.Builder<T> setCoder(Coder<T> coder) {
            this.coder = coder;
            return this;
        }

        @Override
        AvroIO.ParseFiles.Builder<T> setUsesReshuffle(boolean usesReshuffle) {
            this.usesReshuffle = usesReshuffle;
            return this;
        }

        @Override
        AvroIO.ParseFiles.Builder<T> setFileExceptionHandler(ReadAllViaFileBasedSource.ReadFileRangesFnExceptionHandler fileExceptionHandler) {
            if (fileExceptionHandler == null) {
                throw new NullPointerException("Null fileExceptionHandler");
            }
            this.fileExceptionHandler = fileExceptionHandler;
            return this;
        }

        @Override
        AvroIO.ParseFiles.Builder<T> setDesiredBundleSizeBytes(long desiredBundleSizeBytes) {
            this.desiredBundleSizeBytes = desiredBundleSizeBytes;
            return this;
        }

        @Override
        AvroIO.ParseFiles<T> build() {
            if (this.parseFn == null || this.usesReshuffle == null || this.fileExceptionHandler == null || this.desiredBundleSizeBytes == null) {
                StringBuilder missing = new StringBuilder();
                if (this.parseFn == null) {
                    missing.append(" parseFn");
                }
                if (this.usesReshuffle == null) {
                    missing.append(" usesReshuffle");
                }
                if (this.fileExceptionHandler == null) {
                    missing.append(" fileExceptionHandler");
                }
                if (this.desiredBundleSizeBytes == null) {
                    missing.append(" desiredBundleSizeBytes");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AvroIO_ParseFiles(this.parseFn, this.coder, this.usesReshuffle, this.fileExceptionHandler, this.desiredBundleSizeBytes);
        }
    }
}

