/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.collections4.IteratorUtils;

public class ConcurrentMapProperties
extends Properties {
    private static final long serialVersionUID = -7444528393201025496L;
    protected ConcurrentMap<Object, Object> storageMap = new ConcurrentHashMap<Object, Object>();

    public ConcurrentMapProperties() {
        this((Properties)null);
    }

    public ConcurrentMapProperties(Properties defaults) {
        if (defaults != null) {
            this.defaults = defaults instanceof ConcurrentMapProperties ? defaults : ConcurrentMapProperties.convertProperties(defaults);
        }
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.storageMap.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        return this.storageMap.remove(key);
    }

    @Override
    public synchronized void clear() {
        this.storageMap.clear();
    }

    @Override
    public synchronized Object clone() {
        ConcurrentMapProperties cloned = new ConcurrentMapProperties();
        cloned.putAll((Map<? extends Object, ? extends Object>)this.storageMap);
        return cloned;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.storageMap.containsValue(value);
    }

    @Override
    public synchronized Object get(Object key) {
        return this.storageMap.get(key);
    }

    @Override
    public synchronized Object compute(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return this.storageMap.compute(key, remappingFunction);
    }

    @Override
    public synchronized Object computeIfAbsent(Object key, Function<? super Object, ? extends Object> mappingFunction) {
        return this.storageMap.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public synchronized Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return this.storageMap.computeIfPresent(key, remappingFunction);
    }

    @Override
    public synchronized boolean contains(Object value) {
        return this.storageMap.containsValue(value);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.storageMap.isEmpty();
    }

    @Override
    public synchronized int size() {
        return this.storageMap.size();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.storageMap.containsKey(key);
    }

    @Override
    public synchronized Enumeration<Object> elements() {
        return IteratorUtils.asEnumeration(this.storageMap.values().iterator());
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.storageMap.entrySet();
    }

    @Override
    public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
        this.storageMap.forEach(action);
    }

    @Override
    public synchronized Object getOrDefault(Object key, Object defaultValue) {
        return this.storageMap.getOrDefault(key, defaultValue);
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return IteratorUtils.asEnumeration(this.storageMap.keySet().iterator());
    }

    @Override
    public Set<Object> keySet() {
        return this.storageMap.keySet();
    }

    @Override
    public synchronized Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return this.storageMap.merge(key, value, remappingFunction);
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        this.storageMap.putAll(t);
    }

    @Override
    public synchronized Object putIfAbsent(Object key, Object value) {
        return this.storageMap.putIfAbsent(key, value);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        return this.storageMap.remove(key, value);
    }

    @Override
    public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
        return this.storageMap.replace(key, oldValue, newValue);
    }

    @Override
    public synchronized void replaceAll(BiFunction<? super Object, ? super Object, ? extends Object> function) {
        this.storageMap.replaceAll(function);
    }

    @Override
    public synchronized Object replace(Object key, Object value) {
        return this.storageMap.replace(key, value);
    }

    @Override
    public Collection<Object> values() {
        return this.storageMap.values();
    }

    @Override
    public String getProperty(String key) {
        String string;
        Object oval = this.storageMap.get(key);
        String sval = oval instanceof String ? (string = (String)oval) : null;
        return sval == null && this.defaults != null ? this.defaults.getProperty(key) : sval;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return this.storageMap.put(key, value);
    }

    @Override
    public synchronized boolean equals(Object o) {
        super.putAll((Map<?, ?>)this.storageMap);
        boolean result = super.equals(o);
        super.clear();
        return result;
    }

    @Override
    public synchronized String toString() {
        super.putAll((Map<?, ?>)this.storageMap);
        String result = super.toString();
        super.clear();
        return result;
    }

    @Override
    public synchronized int hashCode() {
        super.putAll((Map<?, ?>)this.storageMap);
        int result = super.hashCode();
        super.clear();
        return result;
    }

    @Override
    public synchronized Enumeration<?> propertyNames() {
        return IteratorUtils.asEnumeration(this.stringPropertyNames().iterator());
    }

    @Override
    public synchronized Set<String> stringPropertyNames() {
        HashSet<String> copiedSet = new HashSet<String>();
        if (this.defaults != null) {
            this.defaults.keySet().forEach((? super T x) -> copiedSet.add((String)x));
        }
        this.storageMap.keySet().forEach((? super T x) -> copiedSet.add((String)x));
        return copiedSet;
    }

    @Override
    public synchronized void list(PrintStream out) {
        super.putAll((Map<?, ?>)this.storageMap);
        super.list(out);
        super.clear();
    }

    @Override
    public synchronized void list(PrintWriter out) {
        super.putAll((Map<?, ?>)this.storageMap);
        super.list(out);
        super.clear();
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        super.putAll((Map<?, ?>)this.storageMap);
        super.load(inStream);
        super.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.storageMap.put(key, value)));
        super.clear();
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        super.putAll((Map<?, ?>)this.storageMap);
        super.load(reader);
        super.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.storageMap.put(key, value)));
        super.clear();
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        super.putAll((Map<?, ?>)this.storageMap);
        super.loadFromXML(in);
        super.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.storageMap.putIfAbsent(key, value)));
        super.clear();
    }

    @Override
    public synchronized void store(OutputStream out, String comments) throws IOException {
        super.putAll((Map<?, ?>)this.storageMap);
        super.store(out, comments);
        super.clear();
    }

    @Override
    public synchronized void store(Writer writer, String comments) throws IOException {
        super.putAll((Map<?, ?>)this.storageMap);
        super.store(writer, comments);
        super.clear();
    }

    @Override
    public synchronized void storeToXML(OutputStream os, String comment) throws IOException {
        super.putAll((Map<?, ?>)this.storageMap);
        super.storeToXML(os, comment);
        super.clear();
    }

    @Override
    public synchronized void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        super.putAll((Map<?, ?>)this.storageMap);
        super.storeToXML(os, comment, encoding);
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConcurrentMapProperties convertProperties(Properties props) {
        if (props != null) {
            if (!(props instanceof ConcurrentMapProperties)) {
                ConcurrentMapProperties result = new ConcurrentMapProperties(null);
                Properties properties = props;
                synchronized (properties) {
                    for (String prop : props.stringPropertyNames()) {
                        result.put(prop, props.getProperty(prop));
                    }
                }
                return result;
            }
            ConcurrentMapProperties concurrentMapProperties = (ConcurrentMapProperties)props;
            return concurrentMapProperties;
        }
        return null;
    }
}

