/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.auth.core.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.hop.core.auth.core.AuthenticationConsumerInvocationHandler;
import org.apache.hop.core.auth.core.AuthenticationConsumptionException;
import org.apache.hop.core.auth.core.IAuthenticationConsumer;
import org.apache.hop.core.auth.core.IAuthenticationConsumerFactory;
import org.apache.hop.core.auth.core.IAuthenticationPerformer;
import org.apache.hop.core.auth.core.IAuthenticationProvider;

public class ClassloaderBridgingAuthenticationPerformer<ReturnType, CreateArgType, ConsumedType>
implements IAuthenticationPerformer<ReturnType, CreateArgType> {
    private final IAuthenticationProvider provider;
    private final IAuthenticationConsumerFactory<ReturnType, CreateArgType, ConsumedType> authenticationConsumerFactory;

    public ClassloaderBridgingAuthenticationPerformer(IAuthenticationProvider provider, IAuthenticationConsumerFactory<ReturnType, CreateArgType, ConsumedType> authenticationConsumerFactory) {
        this.provider = provider;
        this.authenticationConsumerFactory = authenticationConsumerFactory;
    }

    @Override
    public ReturnType perform(CreateArgType consumerCreateArg) throws AuthenticationConsumptionException {
        IAuthenticationConsumer<ReturnType, Object> consumer = this.authenticationConsumerFactory.create(consumerCreateArg);
        Object providerProxy = Proxy.newProxyInstance(consumer.getClass().getClassLoader(), new Class[]{this.authenticationConsumerFactory.getConsumedType()}, (InvocationHandler)new AuthenticationConsumerInvocationHandler(this.provider));
        return consumer.consume(providerProxy);
    }

    @Override
    public String getDisplayName() {
        return this.provider.getDisplayName();
    }

    @Override
    public IAuthenticationProvider getAuthenticationProvider() {
        return this.provider;
    }
}

