/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source.datagen;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.util.Preconditions;

@Experimental
public abstract class SequenceGenerator<T>
implements DataGenerator<T> {
    private final long start;
    private final long end;
    private transient ListState<Long> checkpointedState;
    protected transient Deque<Long> valuesToEmit;

    public SequenceGenerator(long start, long end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public void open(String name, FunctionInitializationContext context, RuntimeContext runtimeContext) throws Exception {
        Preconditions.checkState((this.checkpointedState == null ? 1 : 0) != 0, (Object)("The " + this.getClass().getSimpleName() + " has already been initialized."));
        this.checkpointedState = context.getOperatorStateStore().getListState(new ListStateDescriptor(name + "-sequence-state", (TypeSerializer)LongSerializer.INSTANCE));
        this.valuesToEmit = new ArrayDeque<Long>();
        if (context.isRestored()) {
            for (Long v : (Iterable)this.checkpointedState.get()) {
                this.valuesToEmit.add(v);
            }
        } else {
            int stepSize = runtimeContext.getTaskInfo().getNumberOfParallelSubtasks();
            int taskIdx = runtimeContext.getTaskInfo().getIndexOfThisSubtask();
            long congruence = this.start + (long)taskIdx;
            long totalNoOfElements = Math.abs(this.end - this.start + 1L);
            int baseSize = SequenceGenerator.safeDivide(totalNoOfElements, stepSize);
            int toCollect = totalNoOfElements % (long)stepSize > (long)taskIdx ? baseSize + 1 : baseSize;
            for (long collected = 0L; collected < (long)toCollect; ++collected) {
                this.valuesToEmit.add(collected * (long)stepSize + congruence);
            }
        }
    }

    @Override
    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        Preconditions.checkState((this.checkpointedState != null ? 1 : 0) != 0, (Object)("The " + this.getClass().getSimpleName() + " state has not been properly initialized."));
        this.checkpointedState.update(new ArrayList<Long>(this.valuesToEmit));
    }

    @Override
    public boolean hasNext() {
        return !this.valuesToEmit.isEmpty();
    }

    private static int safeDivide(long left, long right) {
        Preconditions.checkArgument((right > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((left >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((left <= Integer.MAX_VALUE * right ? 1 : 0) != 0);
        return (int)(left / right);
    }

    public static SequenceGenerator<Long> longGenerator(long start, long end) {
        return new SequenceGenerator<Long>(start, end){

            @Override
            public Long next() {
                return (Long)this.valuesToEmit.poll();
            }
        };
    }

    public static SequenceGenerator<Integer> intGenerator(int start, int end) {
        return new SequenceGenerator<Integer>((long)start, (long)end){

            @Override
            public Integer next() {
                return ((Long)this.valuesToEmit.poll()).intValue();
            }
        };
    }

    public static SequenceGenerator<Short> shortGenerator(short start, short end) {
        return new SequenceGenerator<Short>((long)start, (long)end){

            @Override
            public Short next() {
                return ((Long)this.valuesToEmit.poll()).shortValue();
            }
        };
    }

    public static SequenceGenerator<Byte> byteGenerator(byte start, byte end) {
        return new SequenceGenerator<Byte>((long)start, (long)end){

            @Override
            public Byte next() {
                return ((Long)this.valuesToEmit.poll()).byteValue();
            }
        };
    }

    public static SequenceGenerator<Float> floatGenerator(short start, short end) {
        return new SequenceGenerator<Float>((long)start, (long)end){

            @Override
            public Float next() {
                return Float.valueOf(((Long)this.valuesToEmit.poll()).floatValue());
            }
        };
    }

    public static SequenceGenerator<Double> doubleGenerator(int start, int end) {
        return new SequenceGenerator<Double>((long)start, (long)end){

            @Override
            public Double next() {
                return ((Long)this.valuesToEmit.poll()).doubleValue();
            }
        };
    }

    public static SequenceGenerator<BigDecimal> bigDecimalGenerator(int start, int end, final int precision, final int scale) {
        return new SequenceGenerator<BigDecimal>((long)start, (long)end){

            @Override
            public BigDecimal next() {
                BigDecimal decimal = new BigDecimal(((Long)this.valuesToEmit.poll()).doubleValue(), new MathContext(precision));
                return decimal.setScale(scale, RoundingMode.DOWN);
            }
        };
    }

    public static SequenceGenerator<String> stringGenerator(long start, long end) {
        return new SequenceGenerator<String>(start, end){

            @Override
            public String next() {
                return ((Long)this.valuesToEmit.poll()).toString();
            }
        };
    }
}

