/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.OutputStream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkMiniClusterEntryPoint {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkMiniClusterEntryPoint.class);

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized Exception {
        MiniClusterArgs miniClusterArgs = FlinkMiniClusterEntryPoint.parseArgs(args);
        Configuration flinkConfig = new Configuration();
        flinkConfig.setInteger(RestOptions.PORT, miniClusterArgs.restPort);
        if (!miniClusterArgs.restBindAddress.isEmpty()) {
            flinkConfig.setString(RestOptions.BIND_ADDRESS, miniClusterArgs.restBindAddress);
        }
        MiniClusterConfiguration clusterConfig = new MiniClusterConfiguration.Builder().setConfiguration(flinkConfig).setNumTaskManagers(miniClusterArgs.numTaskManagers).setNumSlotsPerTaskManager(miniClusterArgs.numSlotsPerTaskManager).build();
        try (MiniCluster miniCluster = new MiniCluster(clusterConfig);){
            miniCluster.start();
            System.out.println(String.format("Started Flink mini cluster (%s TaskManagers with %s task slots) with Rest API at %s", miniClusterArgs.numTaskManagers, miniClusterArgs.numSlotsPerTaskManager, miniCluster.getRestAddress()));
            Thread.sleep(Long.MAX_VALUE);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized MiniClusterArgs parseArgs(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        MiniClusterArgs configuration = new MiniClusterArgs();
        CmdLineParser parser = new CmdLineParser((Object)configuration);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            LOG.error("Unable to parse command line arguments.", (Throwable)e);
            FlinkMiniClusterEntryPoint.printUsage(parser);
            throw new IllegalArgumentException("Unable to parse command line arguments.", e);
        }
        return configuration;
    }

    private static void printUsage(@UnknownKeyFor @NonNull @Initialized CmdLineParser parser) {
        System.err.println(String.format("Usage: java %s arguments...", FlinkMiniClusterEntryPoint.class.getSimpleName()));
        parser.printUsage((OutputStream)System.err);
        System.err.println();
    }

    static class MiniClusterArgs {
        @Option(name="--rest-port")
        @UnknownKeyFor @NonNull @Initialized int restPort = 0;
        @Option(name="--rest-bind-address")
        @UnknownKeyFor @NonNull @Initialized String restBindAddress = "";
        @Option(name="--num-task-managers")
        @UnknownKeyFor @NonNull @Initialized int numTaskManagers = 1;
        @Option(name="--num-task-slots-per-taskmanager")
        @UnknownKeyFor @NonNull @Initialized int numSlotsPerTaskManager = 1;

        MiniClusterArgs() {
        }
    }
}

