/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_RowMutationInformation;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiCDC;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class RowMutationInformation {
    public abstract @UnknownKeyFor @NonNull @Initialized MutationType getMutationType();

    @Deprecated
    public abstract @Nullable @UnknownKeyFor @Initialized Long getSequenceNumber();

    public abstract @UnknownKeyFor @NonNull @Initialized String getChangeSequenceNumber();

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized RowMutationInformation of(@UnknownKeyFor @NonNull @Initialized MutationType mutationType, @UnknownKeyFor @NonNull @Initialized long sequenceNumber) {
        Preconditions.checkArgument((sequenceNumber >= 0L ? 1 : 0) != 0, (Object)"sequenceNumber must be non-negative");
        return new AutoValue_RowMutationInformation(mutationType, null, Long.toHexString(sequenceNumber));
    }

    public static @UnknownKeyFor @NonNull @Initialized RowMutationInformation of(@UnknownKeyFor @NonNull @Initialized MutationType mutationType, @UnknownKeyFor @NonNull @Initialized String changeSequenceNumber) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)changeSequenceNumber) ? 1 : 0) != 0, (Object)"changeSequenceNumber must not be empty");
        Preconditions.checkArgument((boolean)StorageApiCDC.EXPECTED_SQN_PATTERN.asPredicate().test(changeSequenceNumber), (Object)String.format("changeSequenceNumber: %s does not match expected pattern: %s", changeSequenceNumber, StorageApiCDC.EXPECTED_SQN_PATTERN.pattern()));
        return new AutoValue_RowMutationInformation(mutationType, null, changeSequenceNumber);
    }

    public static enum MutationType {
        UPSERT,
        DELETE;

    }
}

