/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.action;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigtable.common.Status;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.cloud.bigtable.data.v2.models.CloseStream;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ByteStringRangeHelper;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ChangeStreamContinuationTokenHelper;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.action.ChangeStreamAction;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.ChangeStreamDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.MetadataTableDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator.BytesThroughputEstimator;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator.SizeEstimator;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.NewPartition;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.PartitionRecord;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.restriction.StreamProgress;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ReadChangeStreamPartitionAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ReadChangeStreamPartitionAction.class);
    private final @UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao;
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamDao changeStreamDao;
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamAction changeStreamAction;
    private final @UnknownKeyFor @NonNull @Initialized Duration heartbeatDuration;
    private final @UnknownKeyFor @NonNull @Initialized SizeEstimator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ChangeStreamRecord>> sizeEstimator;

    public ReadChangeStreamPartitionAction(@UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao, @UnknownKeyFor @NonNull @Initialized ChangeStreamDao changeStreamDao, @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics, @UnknownKeyFor @NonNull @Initialized ChangeStreamAction changeStreamAction, @UnknownKeyFor @NonNull @Initialized Duration heartbeatDuration, @UnknownKeyFor @NonNull @Initialized SizeEstimator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ChangeStreamRecord>> sizeEstimator) {
        this.metadataTableDao = metadataTableDao;
        this.changeStreamDao = changeStreamDao;
        this.metrics = metrics;
        this.changeStreamAction = changeStreamAction;
        this.heartbeatDuration = heartbeatDuration;
        this.sizeEstimator = sizeEstimator;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation run(@UnknownKeyFor @NonNull @Initialized PartitionRecord partitionRecord, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized StreamProgress, @UnknownKeyFor @NonNull @Initialized StreamProgress> tracker, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ChangeStreamRecord>> receiver, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CloseStream closeStream;
        BytesThroughputEstimator<KV<ByteString, ChangeStreamRecord>> throughputEstimator = new BytesThroughputEstimator<KV<ByteString, ChangeStreamRecord>>(this.sizeEstimator, Instant.now());
        if (((StreamProgress)tracker.currentRestriction()).isEmpty()) {
            boolean lockedPartition = this.metadataTableDao.lockAndRecordPartition(partitionRecord);
            for (NewPartition newPartition : partitionRecord.getParentPartitions()) {
                this.metadataTableDao.deleteNewPartition(newPartition);
            }
            if (!lockedPartition) {
                LOG.info("RCSP  {} : Could not acquire lock with uid: {}, because this is a duplicate and another worker is working  on this partition already.", (Object)ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()), (Object)partitionRecord.getUuid());
                StreamProgress streamProgress = new StreamProgress();
                streamProgress.setFailToLock(true);
                this.metrics.decPartitionStreamCount();
                tracker.tryClaim((Object)streamProgress);
                return DoFn.ProcessContinuation.stop();
            }
        } else if (((StreamProgress)tracker.currentRestriction()).getCloseStream() == null && !this.metadataTableDao.doHoldLock(partitionRecord.getPartition(), partitionRecord.getUuid())) {
            LOG.warn("RCSP  {} : Subsequent run that doesn't hold the lock {}. This is not unexpected and should probably be reviewed.", (Object)ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()), (Object)partitionRecord.getUuid());
            StreamProgress streamProgress = new StreamProgress();
            streamProgress.setFailToLock(true);
            this.metrics.decPartitionStreamCount();
            tracker.tryClaim((Object)streamProgress);
            return DoFn.ProcessContinuation.stop();
        }
        if ((closeStream = ((StreamProgress)tracker.currentRestriction()).getCloseStream()) != null) {
            LOG.debug("RCSP: Processing CloseStream");
            this.metrics.decPartitionStreamCount();
            if (closeStream.getStatus().getCode() == Status.Code.OK) {
                Instant terminatingWatermark = Instant.ofEpochMilli((long)Long.MAX_VALUE);
                Instant endTime = partitionRecord.getEndTime();
                if (endTime != null) {
                    terminatingWatermark = endTime;
                }
                watermarkEstimator.setWatermark(terminatingWatermark);
                this.metadataTableDao.updateWatermark(partitionRecord.getPartition(), watermarkEstimator.currentWatermark(), null);
                LOG.info("RCSP {}: Reached end time, terminating...", (Object)ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()));
                return DoFn.ProcessContinuation.stop();
            }
            if (closeStream.getStatus().getCode() != Status.Code.OUT_OF_RANGE) {
                LOG.error("RCSP {}: Reached unexpected terminal state: {}", (Object)ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()), (Object)closeStream.getStatus());
                return DoFn.ProcessContinuation.stop();
            }
            this.metadataTableDao.releaseStreamPartitionLockForDeletion(partitionRecord.getPartition(), partitionRecord.getUuid());
            ArrayList<Range.ByteStringRange> childPartitions = new ArrayList<Range.ByteStringRange>();
            ArrayList tokenPartitions = new ArrayList();
            boolean useNewPartitionsField = closeStream.getNewPartitions().size() == closeStream.getChangeStreamContinuationTokens().size();
            for (int i = 0; i < closeStream.getChangeStreamContinuationTokens().size(); ++i) {
                Range.ByteStringRange childPartition = useNewPartitionsField ? (Range.ByteStringRange)closeStream.getNewPartitions().get(i) : ((ChangeStreamContinuationToken)closeStream.getChangeStreamContinuationTokens().get(i)).getPartition();
                childPartitions.add(childPartition);
                ChangeStreamContinuationToken token = ChangeStreamContinuationTokenHelper.getTokenWithCorrectPartition(partitionRecord.getPartition(), (ChangeStreamContinuationToken)closeStream.getChangeStreamContinuationTokens().get(i));
                tokenPartitions.add(token.getPartition());
                this.metadataTableDao.writeNewPartition(new NewPartition(childPartition, Collections.singletonList(token), (Instant)watermarkEstimator.getState()));
            }
            LOG.info("RCSP {}: Split/Merge into {}", (Object)ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()), (Object)ByteStringRangeHelper.partitionsToString(childPartitions));
            if (!ByteStringRangeHelper.coverSameKeySpace(tokenPartitions, partitionRecord.getPartition())) {
                LOG.warn("RCSP {}: CloseStream has tokens {} that don't cover the entire keyspace", (Object)ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()), (Object)ByteStringRangeHelper.partitionsToString(tokenPartitions));
            }
            this.metadataTableDao.deleteStreamPartitionRow(partitionRecord.getPartition());
            return DoFn.ProcessContinuation.stop();
        }
        this.metadataTableDao.updateWatermark(partitionRecord.getPartition(), (Instant)watermarkEstimator.getState(), ((StreamProgress)tracker.currentRestriction()).getCurrentToken());
        ServerStream<ChangeStreamRecord> stream = null;
        try {
            stream = this.changeStreamDao.readChangeStreamPartition(partitionRecord, (StreamProgress)tracker.currentRestriction(), partitionRecord.getEndTime(), this.heartbeatDuration);
            for (ChangeStreamRecord record : stream) {
                Optional<DoFn.ProcessContinuation> result = this.changeStreamAction.run(partitionRecord, record, tracker, receiver, watermarkEstimator, throughputEstimator);
                if (!result.isPresent()) continue;
                DoFn.ProcessContinuation processContinuation = result.get();
                return processContinuation;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (stream != null) {
                stream.cancel();
            }
        }
        return DoFn.ProcessContinuation.resume();
    }
}

