/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hcatalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class HCatalogUtils {
    private static final @UnknownKeyFor @NonNull @Initialized int DESIRED_BUNDLE_SIZE_BYTES = 0x8000000;

    static @UnknownKeyFor @NonNull @Initialized IMetaStoreClient createMetaStoreClient(@UnknownKeyFor @NonNull @Initialized Configuration conf) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized MetaException {
        HiveConf hiveConf = HCatUtil.getHiveConf((Configuration)conf);
        return HCatUtil.getHiveMetastoreClient((HiveConf)hiveConf);
    }

    static @UnknownKeyFor @NonNull @Initialized HiveConf createHiveConf( @UnknownKeyFor @NonNull @Initialized HCatalogIO.Read readRequest) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Configuration conf = HCatalogUtils.createConfiguration(readRequest.getConfigProperties());
        return HCatUtil.getHiveConf((Configuration)conf);
    }

    static @UnknownKeyFor @NonNull @Initialized int getSplitCount( @UnknownKeyFor @NonNull @Initialized HCatalogIO.Read readRequest, @UnknownKeyFor @NonNull @Initialized Partition partitionToRead) throws @UnknownKeyFor @NonNull @Initialized Exception {
        int desiredSplitCount = 1;
        long estimatedSizeBytes = HCatalogUtils.getFileSizeForPartition(readRequest, partitionToRead);
        if (estimatedSizeBytes > 0L) {
            desiredSplitCount = (int)Math.ceil((double)estimatedSizeBytes / 1.34217728E8);
        }
        return desiredSplitCount;
    }

    static @UnknownKeyFor @NonNull @Initialized Configuration createConfiguration(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> configProperties) {
        Configuration conf = new Configuration();
        for (Map.Entry<String, String> entry : configProperties.entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static @UnknownKeyFor @NonNull @Initialized long getFileSizeForPartition( @UnknownKeyFor @NonNull @Initialized HCatalogIO.Read readRequest, @UnknownKeyFor @NonNull @Initialized Partition partitionToRead) throws @UnknownKeyFor @NonNull @Initialized Exception {
        try (IMetaStoreClient client = null;){
            HiveConf hiveConf = HCatalogUtils.createHiveConf(readRequest);
            client = HCatalogUtils.createMetaStoreClient((Configuration)hiveConf);
            ArrayList<org.apache.hadoop.hive.ql.metadata.Partition> p = new ArrayList<org.apache.hadoop.hive.ql.metadata.Partition>();
            Table table = HCatUtil.getTable((IMetaStoreClient)client, (String)readRequest.getDatabase(), (String)readRequest.getTable());
            org.apache.hadoop.hive.ql.metadata.Partition partition = new org.apache.hadoop.hive.ql.metadata.Partition(table, partitionToRead);
            p.add(partition);
            List fileSizeForPartitions = StatsUtils.getFileSizeForPartitions((HiveConf)hiveConf, p);
            long l = (Long)fileSizeForPartitions.get(0);
            return l;
        }
    }
}

