/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.snowflake;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;

@Action(id="SnowflakeWarehouseManager", image="snowflake-whm.svg", name="Action.Name", description="Action.Description", categoryDescription="Category.Description", documentationUrl="/workflow/actions/snowflake-whm.html")
public class WarehouseManager
extends ActionBase
implements Cloneable,
IAction {
    public static final String MANAGEMENT_ACTION = "managementAction";
    public static final String REPLACE = "replace";
    public static final String FAIL_IF_EXISTS = "failIfExists";
    public static final String WAREHOUSE_NAME = "warehouseName";
    public static final String WAREHOUSE_SIZE = "warehouseSize";
    public static final String WAREHOUSE_TYPE = "warehouseType";
    public static final String MAX_CLUSTER_COUNT = "maxClusterCount";
    public static final String MIN_CLUSTER_COUNT = "minClusterCount";
    public static final String AUTO_SUSPEND = "autoSuspend";
    public static final String AUTO_RESUME = "autoResume";
    public static final String INITIALLY_SUSPENDED = "initiallySuspended";
    public static final String COMMENT = "comment";
    public static final String RESOURCE_MONITOR = "resourceMonitor";
    public static final String CONNECTION = "connection";
    private static final String[] MANAGEMENT_ACTIONS = new String[]{"create", "drop", "resume", "suspend", "alter"};
    public static final int MANAGEMENT_ACTION_CREATE = 0;
    public static final int MANAGEMENT_ACTION_DROP = 1;
    public static final int MANAGEMENT_ACTION_RESUME = 2;
    public static final int MANAGEMENT_ACTION_SUSPEND = 3;
    public static final int MANAGEMENT_ACTION_ALTER = 4;
    private static final String[] WAREHOUSE_SIZES = new String[]{"XSMALL", "SMALL", "MEDIUM", "LARGE", "XLARGE", "XXLARGE", "XXXLARGE"};
    private static final String[] WAREHOUSE_TYPES = new String[]{"Standard", "Enterprise"};
    public static final String FAIL_IF_NOT_EXISTS = "failIfNotExists";
    private static final Class<?> PKG = WarehouseManager.class;
    public static final String CONST_SPACES = "      ";
    public static final String CONST_IF_EXISTS = "IF EXISTS ";
    public static final String CONST_ALTER_WAREHOUSE = "ALTER WAREHOUSE ";
    public static final String CONST_COMMIT = ";\ncommit;";
    @HopMetadataProperty(key="connection", storeWithName=true)
    private DatabaseMeta databaseMeta;
    @HopMetadataProperty(key="managementAction")
    private String managementAction;
    @HopMetadataProperty(key="warehouseName")
    private String warehouseName;
    @HopMetadataProperty(key="replace")
    private boolean replace;
    @HopMetadataProperty(key="failIfExists")
    private boolean failIfExists;
    @HopMetadataProperty(key="failIfNotExists")
    private boolean failIfNotExists;
    @HopMetadataProperty(key="warehouseSize")
    private String warehouseSize;
    @HopMetadataProperty(key="warehouseType")
    private String warehouseType;
    @HopMetadataProperty(key="maxClusterCount")
    private String maxClusterCount;
    @HopMetadataProperty(key="minClusterCount")
    private String minClusterCount;
    @HopMetadataProperty(key="autoSuspend")
    private String autoSuspend;
    @HopMetadataProperty(key="autoResume")
    private boolean autoResume;
    @HopMetadataProperty(key="initiallySuspended")
    private boolean initiallySuspended;
    @HopMetadataProperty(key="resourceMonitor")
    private String resourceMonitor;
    @HopMetadataProperty(key="comment")
    private String comment;

    public WarehouseManager(String name) {
        super(name, "");
        this.setDefault();
    }

    public WarehouseManager() {
        this("");
        this.setDefault();
    }

    public void setDefault() {
        this.failIfExists = true;
        this.failIfNotExists = true;
    }

    public Object clone() {
        return super.clone();
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public String getManagementAction() {
        return this.managementAction;
    }

    public void setManagementAction(String managementAction) {
        this.managementAction = managementAction;
    }

    public int getManagementActionId() {
        if (this.managementAction != null) {
            for (int i = 0; i < MANAGEMENT_ACTIONS.length; ++i) {
                if (!this.managementAction.equals(MANAGEMENT_ACTIONS[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public void setManagementActionById(int managementActionId) {
        this.managementAction = managementActionId >= 0 && managementActionId <= MANAGEMENT_ACTIONS.length ? MANAGEMENT_ACTIONS[managementActionId] : null;
    }

    public String getWarehouseName() {
        return this.warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public boolean isFailIfExists() {
        return this.failIfExists;
    }

    public void setFailIfExists(boolean failIfExists) {
        this.failIfExists = failIfExists;
    }

    public boolean isFailIfNotExists() {
        return this.failIfNotExists;
    }

    public void setFailIfNotExists(boolean failIfNotExists) {
        this.failIfNotExists = failIfNotExists;
    }

    public String getWarehouseSize() {
        return this.warehouseSize;
    }

    public void setWarehouseSize(String warehouseSize) {
        this.warehouseSize = warehouseSize;
    }

    public int getWarehouseSizeId() {
        if (this.warehouseSize != null) {
            for (int i = 0; i < WAREHOUSE_SIZES.length; ++i) {
                if (!this.warehouseSize.equals(WAREHOUSE_SIZES[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public void setWarehouseSizeById(int warehouseSizeId) {
        this.warehouseSize = warehouseSizeId >= 0 && warehouseSizeId < WAREHOUSE_SIZES.length ? WAREHOUSE_SIZES[warehouseSizeId] : null;
    }

    public String getWarehouseType() {
        return this.warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public int getWarehouseTypeId() {
        if (this.warehouseType != null) {
            for (int i = 0; i < WAREHOUSE_TYPES.length; ++i) {
                if (!this.warehouseType.equals(WAREHOUSE_TYPES[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public void setWarehouseTypeById(int warehouseTypeId) {
        this.warehouseType = warehouseTypeId >= 0 && warehouseTypeId < WAREHOUSE_TYPES.length ? WAREHOUSE_TYPES[warehouseTypeId] : null;
    }

    public String getMaxClusterCount() {
        return this.maxClusterCount;
    }

    public void setMaxClusterCount(String maxClusterCount) {
        this.maxClusterCount = maxClusterCount;
    }

    public String getMinClusterCount() {
        return this.minClusterCount;
    }

    public void setMinClusterCount(String minClusterCount) {
        this.minClusterCount = minClusterCount;
    }

    public String getAutoSuspend() {
        return this.autoSuspend;
    }

    public void setAutoSuspend(String autoSuspend) {
        this.autoSuspend = autoSuspend;
    }

    public boolean isAutoResume() {
        return this.autoResume;
    }

    public void setAutoResume(boolean autoResume) {
        this.autoResume = autoResume;
    }

    public boolean isInitiallySuspended() {
        return this.initiallySuspended;
    }

    public void setInitiallySuspended(boolean initiallySuspended) {
        this.initiallySuspended = initiallySuspended;
    }

    public String getResourceMonitor() {
        return this.resourceMonitor;
    }

    public void setResourceMonitor(String resourceMonitor) {
        this.resourceMonitor = resourceMonitor;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void clear() {
        super.clear();
        this.setManagementAction(null);
        this.setReplace(false);
        this.setFailIfExists(false);
        this.setWarehouseName(null);
        this.setWarehouseSize(null);
        this.setWarehouseType(null);
        this.setMaxClusterCount(null);
        this.setMinClusterCount(null);
        this.setAutoSuspend(null);
        this.setAutoResume(false);
        this.setInitiallySuspended(false);
        this.setResourceMonitor(null);
        this.setComment(null);
        this.setDatabaseMeta(null);
        this.setFailIfNotExists(true);
    }

    public boolean validate() {
        boolean result = true;
        if (this.databaseMeta == null || StringUtil.isEmpty((String)this.databaseMeta.getName())) {
            this.logError(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Validate.DatabaseIsEmpty", (String[])new String[0]));
            result = false;
        } else if (StringUtil.isEmpty((String)this.managementAction)) {
            this.logError(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Validate.ManagementAction", (String[])new String[0]));
            result = false;
        } else if (this.managementAction.equals(MANAGEMENT_ACTIONS[0])) {
            if (!StringUtil.isEmpty((String)this.resolve(this.maxClusterCount)) && Const.toInt((String)this.resolve(this.maxClusterCount), (int)-1) <= 0) {
                this.logError(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Validate.MaxClusterCount", (String[])new String[]{this.resolve(this.maxClusterCount)}));
                return false;
            }
            if (!StringUtil.isEmpty((String)this.resolve(this.minClusterCount)) && Const.toInt((String)this.resolve(this.minClusterCount), (int)-1) < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Validate.MinClusterCount", (String[])new String[]{this.resolve(this.minClusterCount)}));
                return false;
            }
            if (!StringUtil.isEmpty((String)this.resolve(this.autoSuspend)) && Const.toInt((String)this.resolve(this.autoSuspend), (int)-1) < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Validate.AutoSuspend", (String[])new String[]{this.resolve(this.autoSuspend)}));
                return false;
            }
        }
        return result;
    }

    public Result execute(Result previousResult, int nr) throws HopException {
        Result result = previousResult;
        result.setResult(this.validate());
        if (!result.getResult()) {
            return result;
        }
        try (Database db = new Database((ILoggingObject)this, (IVariables)this, this.databaseMeta);){
            String sql = null;
            String successMessage = null;
            if (this.managementAction.equals(MANAGEMENT_ACTIONS[0])) {
                sql = this.getCreateSQL();
                successMessage = BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Log.Create.Success", (String[])new String[0]);
            } else if (this.managementAction.equals(MANAGEMENT_ACTIONS[1])) {
                sql = this.getDropSQL();
                successMessage = BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Log.Drop.Success", (String[])new String[0]);
            } else if (this.managementAction.equals(MANAGEMENT_ACTIONS[2])) {
                sql = this.getResumeSQL();
                successMessage = BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Log.Resume.Success", (String[])new String[0]);
            } else if (this.managementAction.equals(MANAGEMENT_ACTIONS[3])) {
                sql = this.getSuspendSQL();
                successMessage = BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Log.Suspend.Success", (String[])new String[0]);
            } else if (this.managementAction.equals(MANAGEMENT_ACTIONS[4])) {
                sql = this.getAlterSQL();
                successMessage = BaseMessages.getString(PKG, (String)"SnowflakeWarehouseManager.Log.Alter.Success", (String[])new String[0]);
            }
            if (sql == null) {
                throw new HopException("Unable to generate action, could not find action type");
            }
            db.connect();
            this.logDebug("Executing SQL " + sql);
            db.execStatements(sql);
            this.logBasic(successMessage);
        }
        catch (Exception ex) {
            this.logError("Error managing warehouse", ex);
            result.setResult(false);
        }
        return result;
    }

    private String getDropSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("DROP WAREHOUSE ");
        if (!this.failIfNotExists) {
            sql.append(CONST_IF_EXISTS);
        }
        sql.append(this.resolve(this.warehouseName)).append(CONST_COMMIT);
        return sql.toString();
    }

    private String getResumeSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append(CONST_ALTER_WAREHOUSE);
        if (!this.failIfNotExists) {
            sql.append(CONST_IF_EXISTS);
        }
        sql.append(this.resolve(this.warehouseName)).append(" RESUME;\ncommit;");
        return sql.toString();
    }

    private String getSuspendSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append(CONST_ALTER_WAREHOUSE);
        if (!this.failIfNotExists) {
            sql.append(CONST_IF_EXISTS);
        }
        sql.append(this.resolve(this.warehouseName)).append(" SUSPEND;\ncommit;");
        return sql.toString();
    }

    private String getCreateSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE ");
        if (this.replace) {
            sql.append("OR REPLACE ");
        }
        sql.append("WAREHOUSE ");
        if (!this.failIfExists && !this.replace) {
            sql.append("IF NOT EXISTS ");
        }
        sql.append(this.warehouseName).append(" WITH ");
        if (!StringUtil.isEmpty((String)this.resolve(this.warehouseSize))) {
            sql.append("WAREHOUSE_SIZE = '").append(this.resolve(this.warehouseSize)).append("' ");
        }
        if (!StringUtil.isEmpty((String)this.resolve(this.warehouseType))) {
            sql.append("WAREHOUSE_TYPE = ").append(this.resolve(this.warehouseType)).append(" ");
        }
        if (!StringUtil.isEmpty((String)this.resolve(this.maxClusterCount))) {
            sql.append("MAX_CLUSTER_COUNT = ").append(this.resolve(this.maxClusterCount)).append(" ");
        }
        if (!StringUtil.isEmpty((String)this.resolve(this.minClusterCount))) {
            sql.append("MIN_CLUSTER_COUNT = ").append(this.resolve(this.minClusterCount)).append(" ");
        }
        if (!StringUtil.isEmpty((String)this.resolve(this.autoSuspend))) {
            sql.append("AUTO_SUSPEND = ").append(Const.toInt((String)this.resolve(this.autoSuspend), (int)0) * 60).append(" ");
        }
        sql.append("AUTO_RESUME = ").append(this.autoResume).append(" ");
        sql.append("INITIALLY_SUSPENDED = ").append(this.initiallySuspended).append(" ");
        if (!StringUtil.isEmpty((String)this.resolve(this.resourceMonitor))) {
            sql.append("RESOURCE_MONITOR = '").append(this.resolve(this.resourceMonitor)).append("' ");
        }
        if (!StringUtil.isEmpty((String)this.resolve(this.comment))) {
            sql.append("COMMENT = \"").append(this.comment.replaceAll("\"", "\"\"")).append("\" ");
        }
        sql.append(CONST_COMMIT);
        return sql.toString();
    }

    private String getAlterSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append(CONST_ALTER_WAREHOUSE);
        if (!this.failIfNotExists) {
            sql.append(CONST_IF_EXISTS);
        }
        sql.append(this.warehouseName).append(" SET ");
        if (!StringUtil.isEmpty((String)this.resolve(this.warehouseSize))) {
            sql.append("WAREHOUSE_SIZE = '").append(this.resolve(this.warehouseSize)).append("' ");
        }
        if (!StringUtil.isEmpty((String)this.resolve(this.warehouseType))) {
            sql.append("WAREHOUSE_TYPE = ").append(this.resolve(this.warehouseType)).append(" ");
        }
        if (!StringUtil.isEmpty((String)this.resolve(this.maxClusterCount))) {
            sql.append("MAX_CLUSTER_COUNT = ").append(this.resolve(this.maxClusterCount)).append(" ");
        }
        if (!StringUtil.isEmpty((String)this.resolve(this.minClusterCount))) {
            sql.append("MIN_CLUSTER_COUNT = ").append(this.resolve(this.minClusterCount)).append(" ");
        }
        if (!StringUtil.isEmpty((String)this.resolve(this.autoSuspend))) {
            sql.append("AUTO_SUSPEND = ").append(Const.toInt((String)this.resolve(this.autoSuspend), (int)0) * 60).append(" ");
        }
        sql.append("AUTO_RESUME = ").append(this.autoResume).append(" ");
        if (!StringUtil.isEmpty((String)this.resolve(this.resourceMonitor))) {
            sql.append("RESOURCE_MONITOR = '").append(this.resolve(this.resourceMonitor)).append("' ");
        }
        if (!StringUtil.isEmpty((String)this.resolve(this.comment))) {
            sql.append("COMMENT = \"").append(this.comment.replaceAll("\"", "\"\"")).append("\" ");
        }
        sql.append(CONST_COMMIT);
        return sql.toString();
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, CONNECTION, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, WAREHOUSE_NAME, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, MANAGEMENT_ACTION, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

