/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.dataflow.model.Base2Exponent;
import com.google.api.services.dataflow.model.BucketOptions;
import com.google.api.services.dataflow.model.DataflowHistogramValue;
import com.google.api.services.dataflow.model.Linear;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.GaugeData;
import org.apache.beam.runners.core.metrics.StringSetData;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.sdk.util.HistogramData;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class MonitoringInfoEncodings {
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Long> VARINT_CODER = VarLongCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Double> DOUBLE_CODER = DoubleCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized IterableCoder<@UnknownKeyFor @NonNull @Initialized String> STRING_SET_CODER = IterableCoder.of(StringUtf8Coder.of());

    public static @UnknownKeyFor @NonNull @Initialized ByteString encodeInt64Distribution(@UnknownKeyFor @NonNull @Initialized DistributionData data) {
        ByteStringOutputStream output = new ByteStringOutputStream();
        try {
            VARINT_CODER.encode(data.count(), output);
            VARINT_CODER.encode(data.sum(), output);
            VARINT_CODER.encode(data.min(), output);
            VARINT_CODER.encode(data.max(), output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static @UnknownKeyFor @NonNull @Initialized DistributionData decodeInt64Distribution(@UnknownKeyFor @NonNull @Initialized ByteString payload) {
        InputStream input = payload.newInput();
        try {
            long count = VARINT_CODER.decode(input);
            long sum = VARINT_CODER.decode(input);
            long min = VARINT_CODER.decode(input);
            long max = VARINT_CODER.decode(input);
            return DistributionData.create(sum, count, min, max);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteString encodeDoubleDistribution(@UnknownKeyFor @NonNull @Initialized long count, @UnknownKeyFor @NonNull @Initialized double sum, @UnknownKeyFor @NonNull @Initialized double min, @UnknownKeyFor @NonNull @Initialized double max) {
        ByteStringOutputStream output = new ByteStringOutputStream();
        try {
            VARINT_CODER.encode(count, output);
            DOUBLE_CODER.encode(sum, output);
            DOUBLE_CODER.encode(min, output);
            DOUBLE_CODER.encode(max, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteString encodeInt64Gauge(@UnknownKeyFor @NonNull @Initialized GaugeData data) {
        ByteStringOutputStream output = new ByteStringOutputStream();
        try {
            VARINT_CODER.encode(data.timestamp().getMillis(), output);
            VARINT_CODER.encode(data.value(), output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static @UnknownKeyFor @NonNull @Initialized GaugeData decodeInt64Gauge(@UnknownKeyFor @NonNull @Initialized ByteString payload) {
        InputStream input = payload.newInput();
        try {
            Instant timestamp = new Instant((Object)VARINT_CODER.decode(input));
            return GaugeData.create(VARINT_CODER.decode(input), timestamp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteString encodeStringSet(@UnknownKeyFor @NonNull @Initialized StringSetData data) {
        ByteString byteString;
        ByteStringOutputStream output = new ByteStringOutputStream();
        try {
            STRING_SET_CODER.encode(data.stringSet(), (OutputStream)output);
            byteString = output.toByteString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        output.close();
        return byteString;
    }

    public static @UnknownKeyFor @NonNull @Initialized StringSetData decodeStringSet(@UnknownKeyFor @NonNull @Initialized ByteString payload) {
        StringSetData stringSetData;
        block8: {
            InputStream input = payload.newInput();
            try {
                HashSet elements = Sets.newHashSet((Iterable)STRING_SET_CODER.decode(input));
                stringSetData = StringSetData.create(elements);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            input.close();
        }
        return stringSetData;
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteString encodeInt64Counter(@UnknownKeyFor @NonNull @Initialized long value) {
        ByteStringOutputStream output = new ByteStringOutputStream();
        try {
            VARINT_CODER.encode(value, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static @UnknownKeyFor @NonNull @Initialized long decodeInt64Counter(@UnknownKeyFor @NonNull @Initialized ByteString payload) {
        try {
            return VarLongCoder.of().decode(payload.newInput());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteString encodeDoubleCounter(@UnknownKeyFor @NonNull @Initialized double value) {
        ByteStringOutputStream output = new ByteStringOutputStream();
        try {
            DOUBLE_CODER.encode(value, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteString();
    }

    public static @UnknownKeyFor @NonNull @Initialized double decodeDoubleCounter(@UnknownKeyFor @NonNull @Initialized ByteString payload) {
        try {
            return DOUBLE_CODER.decode(payload.newInput());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteString encodeInt64Histogram(@UnknownKeyFor @NonNull @Initialized HistogramData inputHistogram) {
        try {
            HistogramData.BucketType buckets;
            int numberOfBuckets = inputHistogram.getBucketType().getNumBuckets();
            DataflowHistogramValue outputHistogram2 = new DataflowHistogramValue();
            if (inputHistogram.getBucketType() instanceof HistogramData.LinearBuckets) {
                buckets = (HistogramData.LinearBuckets)inputHistogram.getBucketType();
                Linear linear = new Linear();
                linear.setNumberOfBuckets(Integer.valueOf(numberOfBuckets));
                linear.setWidth(Double.valueOf(((HistogramData.LinearBuckets)buckets).getWidth()));
                linear.setStart(Double.valueOf(((HistogramData.LinearBuckets)buckets).getStart()));
                outputHistogram2.setBucketOptions(new BucketOptions().setLinear(linear));
            } else if (inputHistogram.getBucketType() instanceof HistogramData.ExponentialBuckets) {
                buckets = (HistogramData.ExponentialBuckets)inputHistogram.getBucketType();
                Base2Exponent base2Exp = new Base2Exponent();
                base2Exp.setNumberOfBuckets(Integer.valueOf(numberOfBuckets));
                base2Exp.setScale(Integer.valueOf(((HistogramData.ExponentialBuckets)buckets).getScale()));
                outputHistogram2.setBucketOptions(new BucketOptions().setExponential(base2Exp));
            } else {
                throw new HistogramParsingException("Unable to encode Int64 Histogram, bucket is not recognized");
            }
            outputHistogram2.setCount(Long.valueOf(inputHistogram.getTotalCount()));
            ArrayList bucketCounts = new ArrayList();
            Arrays.stream(inputHistogram.getBucketCount()).forEach(val -> bucketCounts.add(val));
            outputHistogram2.setBucketCounts(bucketCounts);
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = objectMapper.writeValueAsString((Object)outputHistogram2);
            return ByteString.copyFromUtf8((String)jsonString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized HistogramData decodeInt64Histogram(@UnknownKeyFor @NonNull @Initialized ByteString payload) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            JsonNode jsonNode = objectMapper.readTree(payload.toStringUtf8());
            DataflowHistogramValue newHist = new DataflowHistogramValue();
            newHist.setCount(Long.valueOf(jsonNode.get("count").asLong()));
            ArrayList<Long> bucketCounts = new ArrayList<Long>();
            Iterator itr = jsonNode.get("bucketCounts").iterator();
            while (itr.hasNext()) {
                Long item = ((JsonNode)itr.next()).asLong();
                bucketCounts.add(item);
            }
            newHist.setBucketCounts(bucketCounts);
            if (jsonNode.get("bucketOptions").has("linear")) {
                Linear linear = new Linear();
                JsonNode linearNode = jsonNode.get("bucketOptions").get("linear");
                linear.setNumberOfBuckets(Integer.valueOf(linearNode.get("numberOfBuckets").asInt()));
                linear.setWidth(Double.valueOf(linearNode.get("width").asDouble()));
                linear.setStart(Double.valueOf(linearNode.get("start").asDouble()));
                newHist.setBucketOptions(new BucketOptions().setLinear(linear));
            } else if (jsonNode.get("bucketOptions").has("exponential")) {
                Base2Exponent base2Exp = new Base2Exponent();
                JsonNode expNode = jsonNode.get("bucketOptions").get("exponential");
                base2Exp.setNumberOfBuckets(Integer.valueOf(expNode.get("numberOfBuckets").asInt()));
                base2Exp.setScale(Integer.valueOf(expNode.get("scale").asInt()));
                newHist.setBucketOptions(new BucketOptions().setExponential(base2Exp));
            } else {
                throw new HistogramParsingException("Unable to parse Int64 Histogram, bucket is not recognized");
            }
            return new HistogramData(newHist);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class HistogramParsingException
    extends RuntimeException {
        public HistogramParsingException(@UnknownKeyFor @NonNull @Initialized String message) {
            super(message);
        }
    }
}

