/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import org.apache.beam.runners.direct.BoundedReadEvaluatorFactory;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.RootInputProvider;
import org.apache.beam.runners.direct.SourceShard;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.UnboundedReadEvaluatorFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.construction.ReadTranslation;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class ReadEvaluatorFactory
implements TransformEvaluatorFactory {
    final @UnknownKeyFor @NonNull @Initialized BoundedReadEvaluatorFactory boundedFactory;
    final @UnknownKeyFor @NonNull @Initialized UnboundedReadEvaluatorFactory unboundedFactory;

    public ReadEvaluatorFactory(@UnknownKeyFor @NonNull @Initialized EvaluationContext context, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.boundedFactory = new BoundedReadEvaluatorFactory(context, options);
        this.unboundedFactory = new UnboundedReadEvaluatorFactory(context, options);
    }

    @Override
    public <InputT> @Nullable @UnknownKeyFor @Initialized TransformEvaluator<InputT> forApplication(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputBundle) throws @UnknownKeyFor @NonNull @Initialized Exception {
        switch (ReadTranslation.sourceIsBounded(application)) {
            case BOUNDED: {
                return this.boundedFactory.forApplication(application, inputBundle);
            }
            case UNBOUNDED: {
                return this.unboundedFactory.forApplication(application, inputBundle);
            }
        }
        throw new IllegalArgumentException("PCollection is neither bounded nor unbounded?!?");
    }

    @Override
    public void cleanup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.boundedFactory.cleanup();
        this.unboundedFactory.cleanup();
    }

    static <T> @UnknownKeyFor @NonNull @Initialized InputProvider<T> inputProvider(@UnknownKeyFor @NonNull @Initialized EvaluationContext context, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new InputProvider(context, options);
    }

    private static class InputProvider<@UnknownKeyFor T>
    implements RootInputProvider<T, SourceShard<T>, PBegin> {
        private final @UnknownKeyFor @NonNull @Initialized UnboundedReadEvaluatorFactory.InputProvider<T> unboundedInputProvider;
        private final @UnknownKeyFor @NonNull @Initialized BoundedReadEvaluatorFactory.InputProvider<T> boundedInputProvider;

        InputProvider(@UnknownKeyFor @NonNull @Initialized EvaluationContext context, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.unboundedInputProvider = new UnboundedReadEvaluatorFactory.InputProvider(context, options);
            this.boundedInputProvider = new BoundedReadEvaluatorFactory.InputProvider(context, options);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @NonNull @Initialized SourceShard<T>>> getInitialInputs(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>>> appliedTransform, @UnknownKeyFor @NonNull @Initialized int targetParallelism) throws @UnknownKeyFor @NonNull @Initialized Exception {
            switch (ReadTranslation.sourceIsBounded(appliedTransform)) {
                case BOUNDED: {
                    return this.boundedInputProvider.getInitialInputs(appliedTransform, targetParallelism);
                }
                case UNBOUNDED: {
                    return this.unboundedInputProvider.getInitialInputs(appliedTransform, targetParallelism);
                }
            }
            throw new IllegalArgumentException("PCollection is neither bounded nor unbounded?!?");
        }
    }
}

