/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MapControlClientPool
implements ControlClientPool {
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized InstructionRequestHandler>> clients = Maps.newConcurrentMap();

    public static @UnknownKeyFor @NonNull @Initialized MapControlClientPool create() {
        return new MapControlClientPool();
    }

    private MapControlClientPool() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ControlClientPool.Source getSource() {
        return this::getClient;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ControlClientPool.Sink getSink() {
        return this::putClient;
    }

    private void putClient(@UnknownKeyFor @NonNull @Initialized String workerId, @UnknownKeyFor @NonNull @Initialized InstructionRequestHandler client) {
        CompletableFuture future = this.clients.computeIfAbsent(workerId, MapControlClientPool::createClientFuture);
        boolean success = future.complete(client);
        if (!success) {
            throw new IllegalStateException(String.format("Control client for worker id %s failed to compete", workerId));
        }
    }

    private @UnknownKeyFor @NonNull @Initialized InstructionRequestHandler getClient(@UnknownKeyFor @NonNull @Initialized String workerId, @UnknownKeyFor @NonNull @Initialized Duration timeout) throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized TimeoutException {
        CompletableFuture future = this.clients.computeIfAbsent(workerId, MapControlClientPool::createClientFuture);
        future.get(timeout.getSeconds(), TimeUnit.SECONDS);
        InstructionRequestHandler client = (InstructionRequestHandler)future.get();
        this.clients.remove(workerId);
        return client;
    }

    private static @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized InstructionRequestHandler> createClientFuture(@UnknownKeyFor @NonNull @Initialized String unused) {
        return new CompletableFuture<InstructionRequestHandler>();
    }
}

