/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.google.api.services.dataflow.model.DataflowHistogramValue;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import java.io.Serializable;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.util.AutoValue_HistogramData_ExponentialBuckets;
import org.apache.beam.sdk.util.AutoValue_HistogramData_LinearBuckets;
import org.apache.beam.sdk.util.AutoValue_HistogramData_UnsupportedBuckets;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.math.DoubleMath;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.math.IntMath;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistogramData
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(HistogramData.class);
    private final @UnknownKeyFor @NonNull @Initialized BucketType bucketType;
    private @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] buckets;
    private @UnknownKeyFor @NonNull @Initialized long numBoundedBucketRecords;
    private @UnknownKeyFor @NonNull @Initialized long numTopRecords;
    private @UnknownKeyFor @NonNull @Initialized double topRecordsSum;
    private @UnknownKeyFor @NonNull @Initialized long numBottomRecords;
    private @UnknownKeyFor @NonNull @Initialized double bottomRecordsSum;
    @GuardedBy(value="this")
    private @UnknownKeyFor @NonNull @Initialized double sumOfSquaredDeviations;
    @GuardedBy(value="this")
    private @UnknownKeyFor @NonNull @Initialized double mean;

    public HistogramData(@UnknownKeyFor @NonNull @Initialized BucketType bucketType) {
        this.bucketType = bucketType;
        this.buckets = new long[bucketType.getNumBuckets()];
        this.numBoundedBucketRecords = 0L;
        this.numTopRecords = 0L;
        this.topRecordsSum = 0.0;
        this.numBottomRecords = 0L;
        this.bottomRecordsSum = 0.0;
        this.mean = 0.0;
        this.sumOfSquaredDeviations = 0.0;
    }

    public HistogramData(@UnknownKeyFor @NonNull @Initialized DataflowHistogramValue histogramProto) {
        if (histogramProto.getBucketOptions().getLinear() != null) {
            double start = histogramProto.getBucketOptions().getLinear().getStart();
            double width = histogramProto.getBucketOptions().getLinear().getWidth();
            int numBuckets = histogramProto.getBucketOptions().getLinear().getNumberOfBuckets();
            this.bucketType = LinearBuckets.of(start, width, numBuckets);
            this.buckets = new long[this.bucketType.getNumBuckets()];
            int idx = 0;
            Iterator iterator = histogramProto.getBucketCounts().iterator();
            while (iterator.hasNext()) {
                long val;
                this.buckets[idx] = val = ((Long)iterator.next()).longValue();
                this.numBoundedBucketRecords += val;
                ++idx;
            }
        } else {
            int scale = histogramProto.getBucketOptions().getExponential().getScale();
            int numBuckets = histogramProto.getBucketOptions().getExponential().getNumberOfBuckets();
            this.bucketType = ExponentialBuckets.of(scale, numBuckets);
            this.buckets = new long[this.bucketType.getNumBuckets()];
            int idx = 0;
            Iterator iterator = histogramProto.getBucketCounts().iterator();
            while (iterator.hasNext()) {
                long val;
                this.buckets[idx] = val = ((Long)iterator.next()).longValue();
                this.numBoundedBucketRecords += val;
                ++idx;
            }
        }
    }

    public @UnknownKeyFor @NonNull @Initialized BucketType getBucketType() {
        return this.bucketType;
    }

    public static @UnknownKeyFor @NonNull @Initialized HistogramData linear(@UnknownKeyFor @NonNull @Initialized double start, @UnknownKeyFor @NonNull @Initialized double width, @UnknownKeyFor @NonNull @Initialized int numBuckets) {
        return new HistogramData(LinearBuckets.of(start, width, numBuckets));
    }

    public static @UnknownKeyFor @NonNull @Initialized HistogramData exponential(@UnknownKeyFor @NonNull @Initialized int scale, @UnknownKeyFor @NonNull @Initialized int numBuckets) {
        return new HistogramData(ExponentialBuckets.of(scale, numBuckets));
    }

    public void record(double ... values) {
        for (double value : values) {
            this.record(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(@UnknownKeyFor @NonNull @Initialized HistogramData other) {
        HistogramData histogramData = other;
        synchronized (histogramData) {
            if (!this.bucketType.equals(other.bucketType) || this.buckets.length != other.buckets.length) {
                LOG.warn("Failed to update HistogramData from another with a different buckets");
                return;
            }
            this.incTopBucketCount(other.numTopRecords);
            this.topRecordsSum = other.topRecordsSum;
            this.incBottomBucketCount(other.numBottomRecords);
            this.bottomRecordsSum = other.bottomRecordsSum;
            for (int i = 0; i < other.buckets.length; ++i) {
                this.incBucketCount(i, other.buckets[i]);
            }
            this.mean = other.mean;
            this.sumOfSquaredDeviations = other.sumOfSquaredDeviations;
        }
    }

    public synchronized void incBucketCount(@UnknownKeyFor @NonNull @Initialized int bucketIndex, @UnknownKeyFor @NonNull @Initialized long count) {
        int n = bucketIndex;
        this.buckets[n] = this.buckets[n] + count;
        this.numBoundedBucketRecords += count;
    }

    public synchronized void incTopBucketCount(@UnknownKeyFor @NonNull @Initialized long count) {
        this.numTopRecords += count;
    }

    public synchronized void incBottomBucketCount(@UnknownKeyFor @NonNull @Initialized long count) {
        this.numBottomRecords += count;
    }

    public synchronized void clear() {
        this.buckets = new long[this.bucketType.getNumBuckets()];
        this.numBoundedBucketRecords = 0L;
        this.numTopRecords = 0L;
        this.topRecordsSum = 0.0;
        this.numBottomRecords = 0L;
        this.bottomRecordsSum = 0.0;
        this.mean = 0.0;
        this.sumOfSquaredDeviations = 0.0;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized HistogramData getAndReset() {
        HistogramData other = new HistogramData(this.getBucketType());
        other.update(this);
        this.clear();
        return other;
    }

    public synchronized void record(@UnknownKeyFor @NonNull @Initialized double value) {
        double rangeTo = this.bucketType.getRangeTo();
        double rangeFrom = this.bucketType.getRangeFrom();
        if (value >= rangeTo) {
            this.recordTopRecordsValue(value);
        } else if (value < rangeFrom) {
            this.recordBottomRecordsValue(value);
        } else {
            int n = this.bucketType.getBucketIndex(value);
            this.buckets[n] = this.buckets[n] + 1L;
            ++this.numBoundedBucketRecords;
        }
        this.updateStatistics(value);
    }

    private synchronized void updateStatistics(@UnknownKeyFor @NonNull @Initialized double value) {
        long count = this.getTotalCount();
        if (count == 1L) {
            this.mean = value;
            return;
        }
        double oldMean = this.mean;
        this.mean = oldMean + (value - oldMean) / (double)count;
        this.sumOfSquaredDeviations += (value - this.mean) * (value - oldMean);
    }

    private synchronized void recordTopRecordsValue(@UnknownKeyFor @NonNull @Initialized double value) {
        ++this.numTopRecords;
        this.topRecordsSum += value;
    }

    private synchronized void recordBottomRecordsValue(@UnknownKeyFor @NonNull @Initialized double value) {
        ++this.numBottomRecords;
        this.bottomRecordsSum += value;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long getTotalCount() {
        return this.numBoundedBucketRecords + this.numTopRecords + this.numBottomRecords;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized String getPercentileString(@UnknownKeyFor @NonNull @Initialized String elemType, @UnknownKeyFor @NonNull @Initialized String unit) {
        return String.format("Total number of %s: %s, P99: %.0f %s, P90: %.0f %s, P50: %.0f %s", elemType, this.getTotalCount(), this.p99(), unit, this.p90(), unit, this.p50(), unit);
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long getCount(@UnknownKeyFor @NonNull @Initialized int bucketIndex) {
        return this.buckets[bucketIndex];
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long getTopBucketCount() {
        return this.numTopRecords;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [] getBucketCount() {
        return this.buckets;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized double getTopBucketMean() {
        return this.numTopRecords == 0L ? 0.0 : this.topRecordsSum / (double)this.numTopRecords;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long getBottomBucketCount() {
        return this.numBottomRecords;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized double getBottomBucketMean() {
        return this.numBottomRecords == 0L ? 0.0 : this.bottomRecordsSum / (double)this.numBottomRecords;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized double getMean() {
        return this.mean;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized double getSumOfSquaredDeviations() {
        return this.sumOfSquaredDeviations;
    }

    public @UnknownKeyFor @NonNull @Initialized double p99() {
        return this.getLinearInterpolation(0.99);
    }

    public @UnknownKeyFor @NonNull @Initialized double p90() {
        return this.getLinearInterpolation(0.9);
    }

    public @UnknownKeyFor @NonNull @Initialized double p50() {
        return this.getLinearInterpolation(0.5);
    }

    private synchronized @UnknownKeyFor @NonNull @Initialized double getLinearInterpolation(@UnknownKeyFor @NonNull @Initialized double percentile) {
        int index;
        long totalNumOfRecords = this.getTotalCount();
        if (totalNumOfRecords == 0L) {
            return Double.NaN;
        }
        double recordSum = this.numBottomRecords;
        if (recordSum / (double)totalNumOfRecords >= percentile) {
            return Double.NEGATIVE_INFINITY;
        }
        for (index = 0; index < this.bucketType.getNumBuckets() && !((recordSum += (double)this.buckets[index]) / (double)totalNumOfRecords >= percentile); ++index) {
        }
        if (index == this.bucketType.getNumBuckets()) {
            return Double.POSITIVE_INFINITY;
        }
        double fracPercentile = percentile - (recordSum - (double)this.buckets[index]) / (double)totalNumOfRecords;
        double bucketPercentile = (double)this.buckets[index] / (double)totalNumOfRecords;
        double fracBucketSize = fracPercentile * this.bucketType.getBucketSize(index) / bucketPercentile;
        return this.bucketType.getRangeFrom() + this.bucketType.getAccumulatedBucketSize(index) + fracBucketSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public synchronized @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (object instanceof HistogramData) {
            HistogramData other;
            HistogramData histogramData = other = (HistogramData)object;
            synchronized (histogramData) {
                return Objects.equals(this.bucketType, other.bucketType) && this.numBoundedBucketRecords == other.numBoundedBucketRecords && this.numTopRecords == other.numTopRecords && this.numBottomRecords == other.numBottomRecords && Arrays.equals(this.buckets, other.buckets);
            }
        }
        return false;
    }

    @Pure
    public synchronized @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.bucketType, this.numBoundedBucketRecords, this.numBottomRecords, this.numTopRecords, Arrays.hashCode(this.buckets));
    }

    @AutoValue
    @Internal
    @VisibleForTesting
    public static abstract class UnsupportedBuckets
    implements BucketType {
        public static @UnknownKeyFor @NonNull @Initialized UnsupportedBuckets of() {
            return new AutoValue_HistogramData_UnsupportedBuckets(0);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int getBucketIndex(@UnknownKeyFor @NonNull @Initialized double value) {
            return 0;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double getBucketSize(@UnknownKeyFor @NonNull @Initialized int index) {
            return 0.0;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double getAccumulatedBucketSize(@UnknownKeyFor @NonNull @Initialized int index) {
            return 0.0;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double getRangeFrom() {
            return 0.0;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double getRangeTo() {
            return 0.0;
        }
    }

    @AutoValue
    public static abstract class LinearBuckets
    implements BucketType {
        public abstract @UnknownKeyFor @NonNull @Initialized double getStart();

        public abstract @UnknownKeyFor @NonNull @Initialized double getWidth();

        @Override
        public abstract @UnknownKeyFor @NonNull @Initialized int getNumBuckets();

        public static @UnknownKeyFor @NonNull @Initialized LinearBuckets of(@UnknownKeyFor @NonNull @Initialized double start, @UnknownKeyFor @NonNull @Initialized double width, @UnknownKeyFor @NonNull @Initialized int numBuckets) {
            if (width <= 0.0) {
                throw new IllegalArgumentException(String.format("width should be greater than zero: %f", width));
            }
            if (numBuckets <= 0) {
                throw new IllegalArgumentException(String.format("numBuckets should be greater than zero: %d", numBuckets));
            }
            return new AutoValue_HistogramData_LinearBuckets(start, width, numBuckets);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int getBucketIndex(@UnknownKeyFor @NonNull @Initialized double value) {
            return DoubleMath.roundToInt((double)((value - this.getStart()) / this.getWidth()), (RoundingMode)RoundingMode.FLOOR);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double getBucketSize(@UnknownKeyFor @NonNull @Initialized int index) {
            return this.getWidth();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double getAccumulatedBucketSize(@UnknownKeyFor @NonNull @Initialized int endIndex) {
            return this.getWidth() * (double)endIndex;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double getRangeFrom() {
            return this.getStart();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double getRangeTo() {
            return this.getStart() + (double)this.getNumBuckets() * this.getWidth();
        }
    }

    @AutoValue
    public static abstract class ExponentialBuckets
    implements BucketType {
        private static final @UnknownKeyFor @NonNull @Initialized int MINIMUM_SCALE = -3;
        private static final @UnknownKeyFor @NonNull @Initialized int MAXIMUM_SCALE = 3;
        private static final @UnknownKeyFor @NonNull @Initialized int ZERO_SCALE_MAX_NUM_BUCKETS = 32;

        @Memoized
        public @UnknownKeyFor @NonNull @Initialized double getBase() {
            return Math.pow(2.0, Math.pow(2.0, -this.getScale()));
        }

        public abstract @UnknownKeyFor @NonNull @Initialized int getScale();

        @Memoized
        public @UnknownKeyFor @NonNull @Initialized double getInvLog2GrowthFactor() {
            return Math.pow(2.0, this.getScale());
        }

        @Override
        public abstract @UnknownKeyFor @NonNull @Initialized int getNumBuckets();

        @Override
        @Memoized
        public @UnknownKeyFor @NonNull @Initialized double getRangeTo() {
            return Math.pow(this.getBase(), this.getNumBuckets());
        }

        public static @UnknownKeyFor @NonNull @Initialized ExponentialBuckets of(@UnknownKeyFor @NonNull @Initialized int scale, @UnknownKeyFor @NonNull @Initialized int numBuckets) {
            if (scale < -3) {
                throw new IllegalArgumentException(String.format("Scale should be greater than %d: %d", -3, scale));
            }
            if (scale > 3) {
                throw new IllegalArgumentException(String.format("Scale should be less than %d: %d", 3, scale));
            }
            if (numBuckets <= 0) {
                throw new IllegalArgumentException(String.format("numBuckets should be positive: %d", numBuckets));
            }
            int clippedNumBuckets = ExponentialBuckets.computeNumberOfBuckets(scale, numBuckets);
            return new AutoValue_HistogramData_ExponentialBuckets(scale, clippedNumBuckets);
        }

        private static @UnknownKeyFor @NonNull @Initialized int computeNumberOfBuckets(@UnknownKeyFor @NonNull @Initialized int scale, @UnknownKeyFor @NonNull @Initialized int inputNumBuckets) {
            if (scale == 0) {
                return Math.min(32, inputNumBuckets);
            }
            if (scale > 0) {
                return Math.min(inputNumBuckets, 32 << scale);
            }
            return Math.min(inputNumBuckets, 32 >> -scale);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int getBucketIndex(@UnknownKeyFor @NonNull @Initialized double value) {
            if (value < this.getBase()) {
                return 0;
            }
            int index = this.getScale() > 0 ? this.getBucketIndexPositiveScale(value) : (this.getScale() < 0 ? this.getBucketIndexNegativeScale(DoubleMath.roundToInt((double)value, (RoundingMode)RoundingMode.FLOOR)) : this.getBucketIndexZeroScale(DoubleMath.roundToInt((double)value, (RoundingMode)RoundingMode.FLOOR)));
            return Math.max(Math.min(index, this.getNumBuckets() - 1), 0);
        }

        private @UnknownKeyFor @NonNull @Initialized int getBucketIndexZeroScale(@UnknownKeyFor @NonNull @Initialized int value) {
            return IntMath.log2((int)value, (RoundingMode)RoundingMode.FLOOR);
        }

        private @UnknownKeyFor @NonNull @Initialized int getBucketIndexNegativeScale(@UnknownKeyFor @NonNull @Initialized int value) {
            return this.getBucketIndexZeroScale(value) >> -this.getScale();
        }

        private @UnknownKeyFor @NonNull @Initialized int getBucketIndexPositiveScale(@UnknownKeyFor @NonNull @Initialized double value) {
            return DoubleMath.roundToInt((double)(this.getInvLog2GrowthFactor() * DoubleMath.log2((double)value)), (RoundingMode)RoundingMode.FLOOR);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double getBucketSize(@UnknownKeyFor @NonNull @Initialized int index) {
            if (index < 0) {
                return 0.0;
            }
            if (index == 0) {
                return this.getBase();
            }
            return Math.pow(this.getBase(), index) * (this.getBase() - 1.0);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double getAccumulatedBucketSize(@UnknownKeyFor @NonNull @Initialized int endIndex) {
            if (endIndex < 0) {
                return 0.0;
            }
            return Math.pow(this.getBase(), endIndex + 1);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized double getRangeFrom() {
            return 0.0;
        }

        @Pure
        @Memoized
        public abstract @UnknownKeyFor @NonNull @Initialized int hashCode();
    }

    public static interface BucketType
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized double getRangeFrom();

        public @UnknownKeyFor @NonNull @Initialized double getRangeTo();

        public @UnknownKeyFor @NonNull @Initialized int getNumBuckets();

        public @UnknownKeyFor @NonNull @Initialized int getBucketIndex(@UnknownKeyFor @NonNull @Initialized double var1);

        public @UnknownKeyFor @NonNull @Initialized double getBucketSize(@UnknownKeyFor @NonNull @Initialized int var1);

        public @UnknownKeyFor @NonNull @Initialized double getAccumulatedBucketSize(@UnknownKeyFor @NonNull @Initialized int var1);
    }
}

