/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.reflect.Invokable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.reflect.Parameter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.reflect.TypeResolver;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.reflect.TypeToken;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class TypeDescriptor<@UnknownKeyFor T>
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized TypeToken<T> token;

    private TypeDescriptor(@UnknownKeyFor @NonNull @Initialized TypeToken<T> token) {
        this.token = token;
    }

    protected TypeDescriptor() {
        this.token = new TypeToken<T>(this.getClass()){};
    }

    protected TypeDescriptor(@UnknownKeyFor @NonNull @Initialized Object instance) {
        TypeToken typedToken;
        TypeToken unresolvedToken = new TypeToken<T>(this.getClass()){};
        unresolvedToken = TypeToken.of(instance.getClass()).resolveType(unresolvedToken.getType());
        if (TypeDescriptor.hasUnresolvedParameters(unresolvedToken.getType())) {
            Field field;
            Object fieldInstance;
            Field[] fieldArray = instance.getClass().getDeclaredFields();
            int n = fieldArray.length;
            for (int i = 0; i < n && ((fieldInstance = TypeDescriptor.getEnclosingInstance(field = fieldArray[i], instance)) == null || TypeDescriptor.hasUnresolvedParameters((unresolvedToken = TypeToken.of(fieldInstance.getClass()).resolveType(unresolvedToken.getType())).getType())); ++i) {
            }
        }
        this.token = typedToken = unresolvedToken;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasUnresolvedParameters(@UnknownKeyFor @NonNull @Initialized Type type) {
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)type;
            for (Type arg : param.getActualTypeArguments()) {
                if (!TypeDescriptor.hasUnresolvedParameters(arg)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static @Nullable @UnknownKeyFor @Initialized Object getEnclosingInstance(@UnknownKeyFor @NonNull @Initialized Field field, @UnknownKeyFor @NonNull @Initialized Object instance) {
        if (!field.isSynthetic()) {
            return null;
        }
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(instance);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected TypeDescriptor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        TypeToken unresolvedToken = new TypeToken<T>(this.getClass()){};
        this.token = TypeToken.of(clazz).resolveType(unresolvedToken.getType());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
        return new SimpleTypeDescriptor(TypeToken.of(type));
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> of(@UnknownKeyFor @NonNull @Initialized Type type) {
        return new SimpleTypeDescriptor(TypeToken.of((Type)type));
    }

    public @UnknownKeyFor @NonNull @Initialized Type getType() {
        return this.token.getType();
    }

    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @Nullable @Initialized ? super T> getRawType() {
        return this.token.getRawType();
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getComponentType() {
        @Nullable TypeToken componentTypeToken = this.token.getComponentType();
        if (componentTypeToken == null) {
            return null;
        }
        return new SimpleTypeDescriptor(componentTypeToken);
    }

    public final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @Nullable @Initialized ? super T> getSupertype(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @Nullable @Initialized ? super T> superclass) {
        return new SimpleTypeDescriptor(this.token.getSupertype(superclass));
    }

    public final @UnknownKeyFor @NonNull @Initialized boolean isArray() {
        return this.token.isArray();
    }

    public final @UnknownKeyFor @NonNull @Initialized TypeVariable<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @Nullable @Initialized ? super T>> getTypeParameter(@UnknownKeyFor @NonNull @Initialized String paramName) {
        Class<T> rawType = this.getRawType();
        for (TypeVariable<Class<T>> param : rawType.getTypeParameters()) {
            if (!param.getName().equals(paramName)) continue;
            TypeVariable<Class<T>> typedParam = param;
            return typedParam;
        }
        throw new IllegalArgumentException("No type parameter named " + paramName + " found on " + this.getRawType());
    }

    public final @UnknownKeyFor @NonNull @Initialized boolean isSupertypeOf(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> source) {
        return this.token.isSupertypeOf(source.token);
    }

    public final @UnknownKeyFor @NonNull @Initialized boolean isSubtypeOf(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> parent) {
        return this.token.isSubtypeOf(parent.token);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getArgumentTypes(@UnknownKeyFor @NonNull @Initialized Method method) {
        Invokable typedMethod = this.token.method(method);
        ArrayList argTypes = Lists.newArrayList();
        for (Parameter parameter : typedMethod.getParameters()) {
            argTypes.add(new SimpleTypeDescriptor(parameter.getType()));
        }
        return argTypes;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> resolveType(@UnknownKeyFor @NonNull @Initialized Type type) {
        return new SimpleTypeDescriptor(this.token.resolveType(type));
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TypeDescriptor> getTypes() {
        ArrayList interfaces = Lists.newArrayList();
        for (TypeToken interfaceToken : this.token.getTypes()) {
            interfaces.add(new SimpleTypeDescriptor(interfaceToken));
        }
        return interfaces;
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TypeDescriptor> getInterfaces() {
        ArrayList interfaces = Lists.newArrayList();
        for (TypeToken interfaceToken : this.token.getTypes().interfaces()) {
            interfaces.add(new SimpleTypeDescriptor(interfaceToken));
        }
        return interfaces;
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TypeDescriptor> getClasses() {
        ArrayList classes = Lists.newArrayList();
        for (TypeToken classToken : this.token.getTypes().classes()) {
            classes.add(new SimpleTypeDescriptor(classToken));
        }
        return classes;
    }

    public <X> @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> where(@UnknownKeyFor @NonNull @Initialized TypeParameter<X> typeParameter, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<X> typeDescriptor) {
        return this.where(typeParameter.typeVariable, typeDescriptor.getType());
    }

    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> where(@UnknownKeyFor @NonNull @Initialized Type formal, @UnknownKeyFor @NonNull @Initialized Type actual) {
        TypeResolver resolver = new TypeResolver().where(formal, actual);
        return TypeDescriptor.of(resolver.resolveType(this.token.getType()));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasUnresolvedParameters() {
        return TypeDescriptor.hasUnresolvedParameters(this.getType());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.token.toString();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (!(other instanceof TypeDescriptor)) {
            return false;
        }
        TypeDescriptor descriptor = (TypeDescriptor)other;
        return this.token.equals(descriptor.token);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.token.hashCode();
    }

    private static final class SimpleTypeDescriptor<@UnknownKeyFor T>
    extends TypeDescriptor<T> {
        SimpleTypeDescriptor(@UnknownKeyFor @NonNull @Initialized TypeToken<T> typeToken) {
            super(typeToken);
        }
    }
}

