/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.DataAreaEvent;
import com.ibm.as400.access.DataAreaImpl;
import com.ibm.as400.access.DataAreaListener;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class DataArea
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int UNKNOWN_LENGTH = 0;
    static final int UNINITIALIZED = 0;
    static final int CHARACTER_DATA_AREA = 1;
    static final int DECIMAL_DATA_AREA = 2;
    static final int LOCAL_DATA_AREA = 3;
    static final int LOGICAL_DATA_AREA = 4;
    private AS400 system_ = null;
    private String dataAreaPathName_ = null;
    private String name_ = null;
    private QSYSObjectPathName ifsPathName_ = null;
    int length_ = 0;
    String textDescription_ = "*BLANK";
    String authority_ = "*LIBCRTAUT";
    int dataAreaType_ = 0;
    private transient Vector daListeners_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    transient DataAreaImpl impl_;

    public DataArea() {
        this.initializeTransient();
    }

    public DataArea(AS400 system, String path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.initializeTransient();
        this.ifsPathName_ = new QSYSObjectPathName(path, "DTAARA");
        this.name_ = this.ifsPathName_.getObjectName();
        this.system_ = system;
        this.dataAreaPathName_ = path;
    }

    public void addDataAreaListener(DataAreaListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.daListeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    void chooseImpl() throws AS400SecurityException, IOException {
        if (this.system_ == null) {
            Trace.log(2, "Attempt to connect before setting system.");
            throw new ExtendedIllegalStateException("System", 4);
        }
        if (this.ifsPathName_ == null) {
            Trace.log(2, "Attempt to connect before setting data area pathname.");
            throw new ExtendedIllegalStateException("Path", 4);
        }
        this.impl_ = (DataAreaImpl)this.system_.loadImpl2("com.ibm.as400.access.DataAreaImplRemote", "com.ibm.as400.access.DataAreaImplProxy");
        this.system_.connectService(2);
        this.impl_.setAttributes(this.system_.getImpl(), this.ifsPathName_, this.dataAreaType_);
    }

    static String dataAreaTypeToString(int dataAreaType) {
        String type = null;
        switch (dataAreaType) {
            case 1: {
                type = "Character";
                break;
            }
            case 2: {
                type = "Decimal";
                break;
            }
            case 3: {
                type = "Local";
                break;
            }
            case 4: {
                type = "Logical";
                break;
            }
            case 0: {
                type = "Uninitialized";
                break;
            }
            default: {
                Trace.log(2, "Unrecognized data area type: " + dataAreaType);
                type = "Unrecognized";
            }
        }
        return type;
    }

    void delete0() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.delete();
        this.fireDeleted();
    }

    void fireCleared() {
        Vector targets = (Vector)this.daListeners_.clone();
        DataAreaEvent event = new DataAreaEvent(this, 0);
        for (int i = 0; i < targets.size(); ++i) {
            DataAreaListener target = (DataAreaListener)targets.elementAt(i);
            target.cleared(event);
        }
    }

    void fireCreated() {
        Vector targets = (Vector)this.daListeners_.clone();
        DataAreaEvent event = new DataAreaEvent(this, 1);
        for (int i = 0; i < targets.size(); ++i) {
            DataAreaListener target = (DataAreaListener)targets.elementAt(i);
            target.created(event);
        }
    }

    void fireDeleted() {
        Vector targets = (Vector)this.daListeners_.clone();
        DataAreaEvent event = new DataAreaEvent(this, 2);
        for (int i = 0; i < targets.size(); ++i) {
            DataAreaListener target = (DataAreaListener)targets.elementAt(i);
            target.deleted(event);
        }
    }

    void fireRead() {
        Vector targets = (Vector)this.daListeners_.clone();
        DataAreaEvent event = new DataAreaEvent(this, 3);
        for (int i = 0; i < targets.size(); ++i) {
            DataAreaListener target = (DataAreaListener)targets.elementAt(i);
            target.read(event);
        }
    }

    void fireWritten() {
        Vector targets = (Vector)this.daListeners_.clone();
        DataAreaEvent event = new DataAreaEvent(this, 4);
        for (int i = 0; i < targets.size(); ++i) {
            DataAreaListener target = (DataAreaListener)targets.elementAt(i);
            target.written(event);
        }
    }

    public int getLength() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.getLength();
    }

    public String getName() {
        return this.name_;
    }

    String getPath() {
        return this.dataAreaPathName_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    void initializeTransient() {
        this.impl_ = null;
        this.daListeners_ = new Vector();
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    int read(byte[] dataBuffer, int dataBufferOffset, int dataAreaOffset, int dataLength) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        block11: {
            if (dataBuffer == null) {
                throw new NullPointerException("dataBuffer");
            }
            if (this.length_ == 0) {
                try {
                    this.length_ = this.getLength();
                }
                catch (IllegalObjectTypeException iote) {
                    if (!Trace.isTraceOn() || !Trace.isTraceWarningOn()) break block11;
                    Trace.log(4, "Unexpected exception when retrieving length for data area.", (Throwable)iote);
                }
            }
        }
        if (dataBuffer.length < 1) {
            throw new ExtendedIllegalArgumentException("dataBuffer", 1);
        }
        if (dataBufferOffset < 0 || dataBufferOffset > dataBuffer.length - 1) {
            throw new ExtendedIllegalArgumentException("dataBufferOffset", 2);
        }
        if (dataAreaOffset < 0 || dataAreaOffset >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (dataLength < 1 || dataLength > dataBuffer.length) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (dataBufferOffset + dataLength > dataBuffer.length) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (dataAreaOffset + dataLength > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        int bytesRead = this.impl_.readBytes(dataBuffer, dataBufferOffset, dataAreaOffset, dataLength);
        this.fireRead();
        return bytesRead;
    }

    public void refreshAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.refreshAttributes();
    }

    public void removeDataAreaListener(DataAreaListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.daListeners_.removeElement(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(listener);
    }

    void setImplType(int dataAreaType) {
        this.dataAreaType_ = dataAreaType;
    }

    void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property after connect.");
            throw new ExtendedIllegalStateException("path", 5);
        }
        String old = this.dataAreaPathName_;
        this.vetos_.fireVetoableChange("path", old, path);
        this.ifsPathName_ = new QSYSObjectPathName(path, "DTAARA");
        this.name_ = this.ifsPathName_.getObjectName();
        this.dataAreaPathName_ = path;
        this.changes_.firePropertyChange("path", old, path);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 old = this.system_;
        this.vetos_.fireVetoableChange("system", old, system);
        this.system_ = system;
        this.changes_.firePropertyChange("system", old, this.system_);
    }

    void write(byte[] dataBuffer, int dataBufferOffset, int dataAreaOffset, int dataLength) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        block11: {
            if (dataBuffer == null) {
                throw new NullPointerException("dataBuffer");
            }
            if (this.length_ == 0) {
                try {
                    this.length_ = this.getLength();
                }
                catch (IllegalObjectTypeException iote) {
                    if (!Trace.isTraceOn() || !Trace.isTraceWarningOn()) break block11;
                    Trace.log(4, "Unexpected exception when retrieving length for data area.", (Throwable)iote);
                }
            }
        }
        if (dataBuffer.length < 1) {
            throw new ExtendedIllegalArgumentException("dataBuffer", 1);
        }
        if (dataBufferOffset < 0 || dataBufferOffset > dataBuffer.length - 1) {
            throw new ExtendedIllegalArgumentException("dataBufferOffset", 2);
        }
        if (dataAreaOffset < 0 || dataAreaOffset >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (dataLength < 1 || dataLength > dataBuffer.length) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (dataBufferOffset + dataLength > dataBuffer.length) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (dataAreaOffset + dataLength > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(dataBuffer, dataBufferOffset, dataAreaOffset, dataLength);
        this.fireWritten();
    }
}

