/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SystemValue;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;

public class DateTimeConverter {
    private AS400 system_;
    private ProgramCall program_;
    private AS400Text text10_;
    private Calendar calendar_;
    private DateTime17Format format17_;
    private TimeZone systemTimeZone_;
    static String[][] iTimeZoneTojavaTimeZoneMapping = new String[][]{{"Q0000UTC", "UTC"}, {"Q0000GMT", "GMT"}, {"Q0000GMT2", "Europe/London"}, {"Q000GMT3", "Europe/London"}, {"QN0100UTCS", "GMT-1"}, {"QN0200UTCS", "GMT-2"}, {"QN0300UTCS", "GMT-3"}, {"QN0300UTC2", "America/Sao_Paulo"}, {"QN0330NST", "America/St_Johns"}, {"QN0330NST2", "America/St_Johns"}, {"QN0330NST3", "America/St_Johns"}, {"QN0330NST4", "America/St_Johns"}, {"QN0400UTCS", "GMT-4"}, {"QN0400AST", "Atlantic/Bermuda"}, {"QN0400AST2", "Atlantic/Bermuda"}, {"QN0400CLT", "America/Santiago"}, {"QN0400UTC2", "America/Caracas"}, {"QN0500UTCS", "GMT-5"}, {"QN0500EST", "America/New_York"}, {"QN0500EST2", "GMT-5"}, {"QN0500EST3", "America/New_York"}, {"QN0600UTCS", "GMT-6"}, {"QN0600CST", "America/Chicago"}, {"QN0600CST2", "America/Chicago"}, {"QN0600CST3", "America/Mexico_City"}, {"QN0600S", "America/Chicago"}, {"QN0700UTCS", "GMT-7"}, {"QN0700MST", "America/Denver"}, {"QN0700MST2", "America/Phoenix"}, {"QN0700MST3", "America/Denver"}, {"QN0700MST4", "America/Mazatlan"}, {"QN0700T", "America/Denver"}, {"QN0800UTCS", "GMT-8"}, {"QN0800PST", "America/Los_Angeles"}, {"QN0800PST2", "America/Los_Angeles"}, {"QN0800PST3", "America/Tijuana"}, {"QN0800U", "America/Los_Angeles"}, {"QN0900UTCS", "GMT-9"}, {"QN0900AST", "America/Anchorage"}, {"QN0900AST2", "America/Anchorage"}, {"QN1000UTCS", "GMT-10"}, {"QN1000HAST", "America/Adak"}, {"QN1000HAS2", "America/Adak"}, {"QN1000HST", "Pacific/Honolulu"}, {"QN1100UTCS", "GMT-11"}, {"QN1200UTCS", "GMT-12"}, {"QP1245UTCS", "Pacific/Chatham"}, {"QP1245UTC2", "Pacific/Chatham"}, {"QP1200UTCS", "GMT+12"}, {"QP1200NZST", "Pacific/Auckland"}, {"QP1200NZS2", "Pacific/Auckland"}, {"QP1200NZS3", "Pacific/Auckland"}, {"QP1100UTCS", "GMT+11"}, {"QP1000UTCS", "GMT+10"}, {"QP1000AEST", "Australia/Sydney"}, {"QP1000AES2", "Australia/Sydney"}, {"QP0930ACST", "Australia/Adelaide"}, {"QP0930ACS2", "Australia/Adelaide"}, {"QP0900UTCS", "GMT+9"}, {"QP0900JST", "Asia/Tokyo"}, {"QP0900KST", "Asia/Seoul"}, {"QP0900WIT", "Asia/Jayapura"}, {"QP0800UTCS", "GMT+8"}, {"QP0800AWST", "Australia/Perth"}, {"QP0800AWS2", "Australia/Perth"}, {"QP0800AWS3", "Australia/Perth"}, {"QP0800BST", "Asia/Shanghai"}, {"QP0800JIST", "Asia/Hong_Kong"}, {"QP0800WITA", "Asia/Ujung_Pandang"}, {"QP0700UTCS", "GMT+7"}, {"QP0700WIB", "Asia/Jakarta"}, {"QP0600UTCS", "GMT+6"}, {"QP0600UTC2", "Asia/Almaty"}, {"QP0600UTC3", "Asia/Almaty"}, {"QP0530IST", "Asia/Calcutta"}, {"QP0500UTCS", "GMT+5"}, {"QP0500UTC2", "Asia/Aqtobe"}, {"QP0500UTC3", "Asia/Aqtobe"}, {"QP0400UTCS", "GMT+4"}, {"QP0400UTC2", "Asia/Aqtau"}, {"QP0400UTC3", "Asia/Aqtau"}, {"QP0300MSK", "Europe/Moscow"}, {"QP0300UTCS", "GMT+3"}, {"QP0200UTCS", "GMT+2"}, {"QP0200EET", "Europe/Tallinn"}, {"QP0200EET2", "GMT+2"}, {"QP0200EET3", "Europe/Tallinn"}, {"QP0200SAST", "Africa/Johannesburg"}, {"QP0100UTCS", "GMT+1"}, {"QP0100CET", "Europe/Zurich"}, {"QP0100CET2", "Europe/Zurich"}, {"QP0100CET3", "Europe/Zurich"}, {"QP0100CET4", "Europe/Zurich"}};
    static Hashtable iTimeZoneToJavaTimeZoneHash = null;

    public DateTimeConverter(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.system_ = system;
        this.program_ = new ProgramCall(this.system_);
        this.text10_ = new AS400Text(10, this.system_.getCcsid(), this.system_);
    }

    public byte[] convert(byte[] data, String inFormat, String outFormat) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.convert(data, inFormat, outFormat, null);
    }

    private byte[] convert(byte[] data, String inFormat, String outFormat, String timezone) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] parmList;
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (inFormat == null) {
            throw new NullPointerException("inFormat");
        }
        if (outFormat == null) {
            throw new NullPointerException("outFormat");
        }
        if (timezone == null) {
            parmList = new ProgramParameter[5];
            this.setRequiredParameters(parmList, data, inFormat, outFormat);
        } else {
            parmList = new ProgramParameter[10];
            this.setRequiredParameters(parmList, data, inFormat, outFormat);
            this.setOptionalParameters(parmList, timezone);
        }
        try {
            this.program_.setProgram("/QSYS.LIB/QWCCVTDT.PGM", parmList);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.program_.suggestThreadsafe();
        if (!this.program_.run()) {
            Trace.log(2, "DateTimeConverter call to QWCCVTDT failed.");
            AS400Message[] messageList = this.program_.getMessageList();
            for (int i = 0; i < messageList.length; ++i) {
                Trace.log(2, messageList[i].toString());
            }
            throw new AS400Exception(messageList);
        }
        byte[] received = parmList[3].getOutputData();
        return received;
    }

    private void setRequiredParameters(ProgramParameter[] parmList, byte[] data, String inFormat, String outFormat) {
        parmList[0] = new ProgramParameter(this.text10_.toBytes(inFormat));
        parmList[1] = new ProgramParameter(data);
        parmList[2] = new ProgramParameter(this.text10_.toBytes(outFormat));
        parmList[3] = new ProgramParameter(17);
        parmList[4] = new ErrorCodeParameter();
    }

    private void setOptionalParameters(ProgramParameter[] parmList, String timezone) {
        byte[] timezoneBytes = this.text10_.toBytes(timezone);
        parmList[5] = new ProgramParameter(timezoneBytes);
        parmList[6] = new ProgramParameter(timezoneBytes);
        parmList[7] = new ProgramParameter(0);
        parmList[8] = new ProgramParameter(BinaryConverter.intToByteArray(0));
        parmList[9] = new ProgramParameter(new byte[]{-16});
    }

    public Date convert(byte[] data, String inFormat) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (inFormat == null) {
            throw new NullPointerException("inFormat");
        }
        byte[] converted = this.convert(data, inFormat, "*YYMD", null);
        Record rec = this.getFormat17().getNewRecord(converted);
        if (Trace.traceOn_) {
            Trace.log(1, "DateTimeConverter record parsed from bytes: " + rec.toString());
        }
        Calendar calendar = this.getCalendar();
        calendar.set(Integer.parseInt(((String)rec.getField("year")).trim()), Integer.parseInt(((String)rec.getField("month")).trim()) - 1, Integer.parseInt(((String)rec.getField("day")).trim()), Integer.parseInt(((String)rec.getField("hour")).trim()), Integer.parseInt(((String)rec.getField("minute")).trim()), Integer.parseInt(((String)rec.getField("second")).trim()));
        calendar.set(14, Integer.parseInt(((String)rec.getField("millisecond")).trim()));
        return calendar.getTime();
    }

    public byte[] convert(Date date, String outFormat) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (date == null) {
            throw new NullPointerException("date");
        }
        if (outFormat == null) {
            throw new NullPointerException("outFormat");
        }
        byte[] data = this.dateToBytes(date);
        return this.convert(data, "*YYMD", outFormat, null);
    }

    private byte[] dateToBytes(Date date) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Calendar calendar = this.getCalendar();
        calendar.setTime(date);
        Record rec = this.getFormat17().getNewRecord();
        rec.setField("year", (Object)Integer.toString(calendar.get(1)));
        int month = calendar.get(2) + 1;
        String monthStr = (month < 10 ? "0" : "") + month;
        rec.setField("month", (Object)monthStr);
        int day = calendar.get(5);
        String dayStr = (day < 10 ? "0" : "") + day;
        rec.setField("day", (Object)dayStr);
        int hour = calendar.get(11);
        String hourStr = (hour < 10 ? "0" : "") + hour;
        rec.setField("hour", (Object)hourStr);
        int minute = calendar.get(12);
        String minuteStr = (minute < 10 ? "0" : "") + minute;
        rec.setField("minute", (Object)minuteStr);
        int second = calendar.get(13);
        String secondStr = (second < 10 ? "0" : "") + second;
        rec.setField("second", (Object)secondStr);
        int ms = calendar.get(14);
        String msStr = (ms < 100 ? "0" : "") + (ms < 10 ? "0" : "") + ms;
        rec.setField("millisecond", (Object)msStr);
        if (Trace.traceOn_) {
            Trace.log(1, "DateTimeConverter record parsed from Date: " + rec.toString());
        }
        return rec.getContents();
    }

    private final Calendar getCalendar() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.calendar_ == null) {
            this.calendar_ = AS400Calendar.getGregorianInstance(this.getSystemTimeZone());
        } else {
            this.calendar_.clear();
        }
        return this.calendar_;
    }

    private synchronized DateTime17Format getFormat17() {
        if (this.format17_ == null) {
            this.format17_ = new DateTime17Format(this.system_);
        }
        return this.format17_;
    }

    final TimeZone getSystemTimeZone() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.systemTimeZone_ == null) {
            this.systemTimeZone_ = DateTimeConverter.timeZoneForSystem(this.system_);
        }
        return this.systemTimeZone_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String iTimeZoneToJavaTimeZone(String iTimeZone) {
        iTimeZone = iTimeZone.toUpperCase();
        String[][] stringArray = iTimeZoneTojavaTimeZoneMapping;
        synchronized (iTimeZoneTojavaTimeZoneMapping) {
            if (iTimeZoneToJavaTimeZoneHash == null) {
                iTimeZoneToJavaTimeZoneHash = new Hashtable();
                for (int i = 0; i < iTimeZoneTojavaTimeZoneMapping.length; ++i) {
                    iTimeZoneToJavaTimeZoneHash.put(iTimeZoneTojavaTimeZoneMapping[i][0], iTimeZoneTojavaTimeZoneMapping[i][1]);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (String)iTimeZoneToJavaTimeZoneHash.get(iTimeZone);
        }
    }

    public static TimeZone timeZoneForSystem(AS400 system) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        try {
            SystemValue sv = new SystemValue(system, "QTIMZON");
            String iTimeZone = ((String)sv.getValue()).trim();
            String javaTimeZoneName = DateTimeConverter.iTimeZoneToJavaTimeZone(iTimeZone);
            if (javaTimeZoneName != null) {
                return TimeZone.getTimeZone(javaTimeZoneName);
            }
        }
        catch (Exception e) {
            Trace.log(2, e);
        }
        String utcOffset = null;
        try {
            SystemValue sv = new SystemValue(system, "QUTCOFFSET");
            utcOffset = (String)sv.getValue();
            if (utcOffset == null || utcOffset.length() == 0) {
                if (Trace.traceOn_) {
                    Trace.log(1, "QUTCOFFSET is not set. Assuming server is in the same time zone as client application.");
                }
                return TimeZone.getDefault();
            }
            return TimeZone.getTimeZone("GMT" + utcOffset);
        }
        catch (RequestNotSupportedException e) {
            Trace.log(2, e);
            throw new InternalErrorException(10, (Throwable)e);
        }
        catch (RuntimeException e) {
            if (Trace.traceOn_) {
                Trace.log(4, "[" + e.toString() + "] Unable to determine time zone of system. QUTCOFFSET value is " + utcOffset + ". Assuming server is in the same time zone as client application.");
            }
            return TimeZone.getDefault();
        }
    }

    static final String formatDateForCommandParameter(byte[] dateBytes, String dateFormat) throws UnsupportedEncodingException {
        int expectedLength = 0;
        String outVal = null;
        String dateString = CharConverter.byteArrayToString(37, dateBytes);
        if (dateFormat.equals("*DTS")) {
            expectedLength = 8;
        } else if (dateFormat.equals("*YYMD") || dateFormat.equals("*MDYY") || dateFormat.equals("*DMYY") || dateFormat.equals("*LONGJUL")) {
            expectedLength = 17;
        } else if (dateFormat.equals("*MDY") || dateFormat.equals("*YMD") || dateFormat.equals("*DMY")) {
            outVal = dateString.substring(1, 7);
        } else if (dateFormat.equals("*JUL")) {
            outVal = dateString.substring(1, 6);
        } else {
            expectedLength = 16;
        }
        if (outVal != null) {
            return outVal;
        }
        if (dateString.length() == expectedLength) {
            return dateString;
        }
        return dateString.substring(0, expectedLength);
    }

    private static class DateTime17Format
    extends RecordFormat {
        private static final long serialVersionUID = 1L;

        DateTime17Format(AS400 system) {
            int ccsid = system.getCcsid();
            AS400Text text2 = new AS400Text(2, ccsid, system);
            this.addFieldDescription(new CharacterFieldDescription(new AS400Text(4, ccsid, system), "year"));
            this.addFieldDescription(new CharacterFieldDescription(text2, "month"));
            this.addFieldDescription(new CharacterFieldDescription(text2, "day"));
            this.addFieldDescription(new CharacterFieldDescription(text2, "hour"));
            this.addFieldDescription(new CharacterFieldDescription(text2, "minute"));
            this.addFieldDescription(new CharacterFieldDescription(text2, "second"));
            this.addFieldDescription(new CharacterFieldDescription(new AS400Text(3, ccsid, system), "millisecond"));
        }
    }
}

