/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

class PoolItemProperties {
    private long creationTime_ = 0L;
    private long lastUseTime_ = 0L;
    private long timeIdleInPool_ = this.creationTime_ = System.currentTimeMillis();
    private int timesUsedCount_ = 0;
    private boolean isFailedPretest_ = false;

    public void clear() {
        this.timeIdleInPool_ = this.creationTime_ = System.currentTimeMillis();
        this.lastUseTime_ = 0L;
        this.timesUsedCount_ = 0;
    }

    private long getElapsedTime(long startTime) {
        if (startTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - startTime;
    }

    public long getInactivityTime() {
        return this.getElapsedTime(this.timeIdleInPool_);
    }

    public long getInUseTime() {
        if (this.isInUse()) {
            return this.getElapsedTime(this.lastUseTime_);
        }
        return 0L;
    }

    public long getLifeSpan() {
        return this.getElapsedTime(this.creationTime_);
    }

    public int getUseCount() {
        return this.timesUsedCount_;
    }

    boolean isFailedPretest() {
        return this.isFailedPretest_;
    }

    public synchronized boolean isInUse() {
        return this.lastUseTime_ != 0L;
    }

    void setFailedPretest() {
        this.isFailedPretest_ = true;
    }

    synchronized void setInUse(boolean inUse) {
        if (inUse) {
            this.timeIdleInPool_ = 0L;
            this.lastUseTime_ = System.currentTimeMillis();
            ++this.timesUsedCount_;
        } else {
            this.timeIdleInPool_ = System.currentTimeMillis();
            this.lastUseTime_ = 0L;
        }
    }
}

