/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dynamicsqlrow;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dynamicsqlrow.DynamicSqlRow;
import org.apache.hop.pipeline.transforms.dynamicsqlrow.DynamicSqlRowData;

@Transform(id="DynamicSqlRow", image="dynamicsqlrow.svg", name="i18n::DynamicSQLRow.Name", description="i18n::DynamicSQLRow.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", keywords={"i18n::DynamicSqlRowMeta.keyword"}, documentationUrl="/pipeline/transforms/dynamicsqlrow.html", actionTransformTypes={ActionTransformType.RDBMS})
public class DynamicSqlRowMeta
extends BaseTransformMeta<DynamicSqlRow, DynamicSqlRowData> {
    private static final Class<?> PKG = DynamicSqlRowMeta.class;
    @HopMetadataProperty(key="connection", injectionKeyDescription="DynamicSQLRow.Injection.Connection", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_CONNECTION)
    private String connection;
    private DatabaseMeta databaseMeta;
    @HopMetadataProperty(key="sql", injectionKeyDescription="DynamicSQLRow.Injection.Sql", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_SQL)
    private String sql;
    @HopMetadataProperty(key="sql_fieldname", injectionKeyDescription="DynamicSQLRow.Injection.SqlFieldName", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_SQL)
    private String sqlFieldName;
    @HopMetadataProperty(key="rowlimit", injectionKeyDescription="DynamicSQLRow.Injection.RowLimit")
    private int rowLimit;
    @HopMetadataProperty(key="outer_join", injectionKeyDescription="DynamicSQLRow.Injection.OuterJoin")
    private boolean outerJoin;
    @HopMetadataProperty(key="replace_vars", injectionKeyDescription="DynamicSQLRow.Injection.ReplaceVariables")
    private boolean replaceVariables;
    @HopMetadataProperty(key="query_only_on_change", injectionKeyDescription="DynamicSQLRow.Injection.QueryOnlyOnChange")
    private boolean queryOnlyOnChange;

    public DynamicSqlRowMeta() {
    }

    public DynamicSqlRowMeta(DynamicSqlRowMeta meta) {
        this.connection = meta.connection;
        this.sql = meta.sql;
        this.sqlFieldName = meta.sqlFieldName;
        this.replaceVariables = meta.replaceVariables;
        this.rowLimit = meta.rowLimit;
        this.connection = meta.connection;
        this.outerJoin = meta.outerJoin;
        this.queryOnlyOnChange = meta.queryOnlyOnChange;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public boolean isOuterJoin() {
        return this.outerJoin;
    }

    public void setOuterJoin(boolean outerJoin) {
        this.outerJoin = outerJoin;
    }

    public boolean isReplaceVariables() {
        return this.replaceVariables;
    }

    public void setReplaceVariables(boolean replaceVariables) {
        this.replaceVariables = replaceVariables;
    }

    public boolean isQueryOnlyOnChange() {
        return this.queryOnlyOnChange;
    }

    public void setQueryOnlyOnChange(boolean queryonlyonchange) {
        this.queryOnlyOnChange = queryonlyonchange;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSqlFieldName() {
        return this.sqlFieldName;
    }

    public void setSqlFieldName(String sqlfieldname) {
        this.sqlFieldName = sqlfieldname;
    }

    public Object clone() {
        return new DynamicSqlRowMeta(this);
    }

    public void setDefault() {
        this.connection = null;
        this.databaseMeta = null;
        this.rowLimit = 0;
        this.sql = "";
        this.outerJoin = false;
        this.replaceVariables = false;
        this.sqlFieldName = null;
        this.queryOnlyOnChange = false;
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.databaseMeta == null) {
            return;
        }
        Database db = new Database(loggingObject, variables, this.databaseMeta);
        this.databases = new Database[]{db};
        IRowMeta add = null;
        String realSql = this.sql;
        if (this.replaceVariables) {
            realSql = variables.resolve(realSql);
        }
        try {
            add = db.getQueryFields(realSql, false);
        }
        catch (HopDatabaseException dbe) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.Exception.UnableToDetermineQueryFields", (String[])new String[0]) + Const.CR + this.sql, (Throwable)dbe);
        }
        if (add != null) {
            for (int i = 0; i < add.size(); ++i) {
                IValueMeta v = add.getValueMeta(i);
                v.setOrigin(name);
            }
            row.addRowMeta(add);
        } else {
            try {
                db.connect();
                add = db.getQueryFields(realSql, false);
                for (int i = 0; i < add.size(); ++i) {
                    IValueMeta v = add.getValueMeta(i);
                    v.setOrigin(name);
                }
                row.addRowMeta(add);
                db.disconnect();
            }
            catch (HopDatabaseException dbe) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.Exception.ErrorObtainingFields", (String[])new String[0]), (Throwable)dbe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object errorMessage = "";
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.ReceivingInfo", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.sqlFieldName)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.SQLFieldNameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            IValueMeta vfield = prev.searchValueMeta(this.sqlFieldName);
            cr = vfield == null ? new CheckResult(4, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.SQLFieldNotFound", (String[])new String[]{this.sqlFieldName}), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.SQLFieldFound", (String[])new String[]{this.sqlFieldName, vfield.getOrigin()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, variables, this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                if (this.sql == null || this.sql.length() == 0) return;
                errorMessage = "";
                IRowMeta r = db.getQueryFields(this.sql, true);
                if (r != null) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.QueryOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    return;
                }
                errorMessage = BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.InvalidDBQuery", (String[])new String[0]);
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                return;
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                return;
            }
            finally {
                db.disconnect();
            }
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        IRowMeta out = prev.clone();
        this.getFields(out, transformMeta.getName(), new IRowMeta[]{info}, null, variables, metadataProvider);
        if (out != null) {
            for (int i = 0; i < out.size(); ++i) {
                IValueMeta outvalue = out.getValueMeta(i);
                DatabaseImpact di = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), "", outvalue.getName(), outvalue.getName(), transformMeta.getName(), this.sql, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.DatabaseImpact.Title", (String[])new String[0]));
                impact.add(di);
            }
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

