/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.tableexists;

import java.util.List;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="TABLE_EXISTS", name="i18n::ActionTableExists.Name", description="i18n::ActionTableExists.Description", image="TableExists.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionTableExists.keyword"}, documentationUrl="/workflow/actions/tableexists.html")
public class ActionTableExists
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionTableExists.class;
    private String tableName = null;
    private String schemaname = null;
    private DatabaseMeta connection = null;

    public ActionTableExists(String n) {
        super(n, "");
    }

    public ActionTableExists() {
        this("");
    }

    public Object clone() {
        ActionTableExists je = (ActionTableExists)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"tablename", (String)this.tableName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XmlHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.tableName = XmlHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.schemaname = XmlHandler.getTagValue((Node)entrynode, (String)"schemaname");
            String dbname = XmlHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)dbname);
        }
        catch (HopException e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"TableExists.Meta.UnableLoadXml", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setTablename(String tableName) {
        this.tableName = tableName;
    }

    public String getTablename() {
        return this.tableName;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        if (this.connection != null) {
            Database db = new Database((ILoggingObject)this, (IVariables)this, this.connection);
            try {
                db.connect();
                String realTablename = this.resolve(this.tableName);
                String realSchemaname = this.resolve(this.schemaname);
                if (db.checkTableExists(realSchemaname, realTablename)) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TableExists.Log.TableExists", (String[])new String[]{realTablename}));
                    }
                    result.setResult(true);
                    return result;
                }
                if (!this.log.isDetailed()) return result;
                this.logDetailed(BaseMessages.getString(PKG, (String)"TableExists.Log.TableNotExists", (String[])new String[]{realTablename}));
                return result;
            }
            catch (HopDatabaseException dbe) {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(PKG, (String)"TableExists.Error.RunningAction", (String[])new String[]{dbe.getMessage()}));
                return result;
            }
            finally {
                if (db != null) {
                    try {
                        db.disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        result.setNrErrors(1L);
        this.logError(BaseMessages.getString(PKG, (String)"TableExists.Error.NoConnectionDefined", (String[])new String[0]));
        return result;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "tablename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

