/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.util;

import com.dropbox.core.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.CharacterCodingException;

public class IOUtil {
    public static final int DEFAULT_COPY_BUFFER_SIZE = 16384;
    public static final InputStream EmptyInputStream = new InputStream(){

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int read(byte[] data) {
            return -1;
        }

        @Override
        public int read(byte[] data, int off, int len) {
            return -1;
        }
    };
    public static final OutputStream BlackHoleOutputStream = new OutputStream(){

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] data) {
        }

        @Override
        public void write(byte[] data, int off, int len) {
        }
    };

    public static Reader utf8Reader(InputStream in) {
        return new InputStreamReader(in, StringUtil.UTF8.newDecoder());
    }

    public static Writer utf8Writer(OutputStream out) {
        return new OutputStreamWriter(out, StringUtil.UTF8.newEncoder());
    }

    public static String toUtf8String(InputStream in) throws ReadException, CharacterCodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtil.copyStreamToStream(in, out);
        }
        catch (WriteException ex) {
            throw new RuntimeException("impossible", ex);
        }
        return StringUtil.utf8ToString(out.toByteArray());
    }

    public static void copyStreamToStream(InputStream in, OutputStream out) throws ReadException, WriteException {
        IOUtil.copyStreamToStream(in, out, 16384);
    }

    public static void copyStreamToStream(InputStream in, OutputStream out, byte[] copyBuffer) throws ReadException, WriteException {
        while (true) {
            int count;
            try {
                count = in.read(copyBuffer);
            }
            catch (IOException ex) {
                throw new ReadException(ex);
            }
            if (count == -1) break;
            try {
                out.write(copyBuffer, 0, count);
            }
            catch (IOException ex) {
                throw new WriteException(ex);
            }
        }
    }

    public static void copyStreamToStream(InputStream in, OutputStream out, int copyBufferSize) throws ReadException, WriteException {
        IOUtil.copyStreamToStream(in, out, new byte[copyBufferSize]);
    }

    public static byte[] slurp(InputStream in, int byteLimit) throws IOException {
        return IOUtil.slurp(in, byteLimit, new byte[16384]);
    }

    public static byte[] slurp(InputStream in, int byteLimit, byte[] slurpBuffer) throws IOException {
        if (byteLimit < 0) {
            throw new RuntimeException("'byteLimit' must be non-negative: " + byteLimit);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.copyStreamToStream(in, (OutputStream)baos, slurpBuffer);
        return baos.toByteArray();
    }

    public void copyFileToStream(File fin, OutputStream out) throws ReadException, WriteException {
        this.copyFileToStream(fin, out, 16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFileToStream(File fin, OutputStream out, int copyBufferSize) throws ReadException, WriteException {
        FileInputStream in;
        try {
            in = new FileInputStream(fin);
        }
        catch (IOException ex) {
            throw new ReadException(ex);
        }
        try {
            IOUtil.copyStreamToStream((InputStream)in, out, copyBufferSize);
        }
        finally {
            IOUtil.closeInput(in);
        }
    }

    public void copyStreamToFile(InputStream in, File fout) throws ReadException, WriteException {
        this.copyStreamToFile(in, fout, 16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStreamToFile(InputStream in, File fout, int copyBufferSize) throws ReadException, WriteException {
        FileOutputStream out;
        try {
            out = new FileOutputStream(fout);
        }
        catch (IOException ex) {
            throw new WriteException(ex);
        }
        try {
            IOUtil.copyStreamToStream(in, (OutputStream)out, copyBufferSize);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                throw new WriteException(ex);
            }
        }
    }

    public static void closeInput(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeInput(Reader in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Closeable obj) {
        if (obj != null) {
            try {
                obj.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static InputStream limit(InputStream in, long limit) {
        return new LimitInputStream(in, limit);
    }

    public static interface ProgressListener {
        public void onProgress(long var1);
    }

    private static final class LimitInputStream
    extends FilterInputStream {
        private long left;

        public LimitInputStream(InputStream in, long limit) {
            super(in);
            if (in == null) {
                throw new NullPointerException("in");
            }
            if (limit < 0L) {
                throw new IllegalArgumentException("limit must be non-negative");
            }
            this.left = limit;
        }

        @Override
        public int available() throws IOException {
            return (int)Math.min((long)this.in.available(), this.left);
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException("mark not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            if (this.left == 0L) {
                return -1;
            }
            int read = this.in.read();
            if (read != -1) {
                --this.left;
            }
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.left == 0L) {
                return -1;
            }
            int read = this.in.read(b, off, len = (int)Math.min((long)len, this.left));
            if (read != -1) {
                this.left -= (long)read;
            }
            return read;
        }

        @Override
        public long skip(long n) throws IOException {
            n = Math.min(n, this.left);
            long skipped = this.in.skip(n);
            this.left -= skipped;
            return skipped;
        }
    }

    public static final class WriteException
    extends WrappedException {
        private static final long serialVersionUID = 0L;

        public WriteException(String message, IOException underlying) {
            super(message, underlying);
        }

        public WriteException(IOException underlying) {
            super(underlying);
        }
    }

    public static final class ReadException
    extends WrappedException {
        private static final long serialVersionUID = 0L;

        public ReadException(String message, IOException underlying) {
            super(message, underlying);
        }

        public ReadException(IOException underlying) {
            super(underlying);
        }
    }

    public static abstract class WrappedException
    extends IOException {
        private static final long serialVersionUID = 0L;

        public WrappedException(String message, IOException underlying) {
            super(message + ": " + underlying.getMessage(), underlying);
        }

        public WrappedException(IOException underlying) {
            super(underlying);
        }

        @Override
        public IOException getCause() {
            return (IOException)super.getCause();
        }

        @Override
        public String getMessage() {
            String m = super.getCause().getMessage();
            if (m == null) {
                return "";
            }
            return m;
        }
    }
}

