/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.fileproperties;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.fileproperties.LogicalOperator;
import com.dropbox.core.v2.fileproperties.PropertiesSearchMode;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class PropertiesSearchQuery {
    protected final String query;
    protected final PropertiesSearchMode mode;
    protected final LogicalOperator logicalOperator;

    public PropertiesSearchQuery(String query, PropertiesSearchMode mode, LogicalOperator logicalOperator) {
        if (query == null) {
            throw new IllegalArgumentException("Required value for 'query' is null");
        }
        this.query = query;
        if (mode == null) {
            throw new IllegalArgumentException("Required value for 'mode' is null");
        }
        this.mode = mode;
        if (logicalOperator == null) {
            throw new IllegalArgumentException("Required value for 'logicalOperator' is null");
        }
        this.logicalOperator = logicalOperator;
    }

    public PropertiesSearchQuery(String query, PropertiesSearchMode mode) {
        this(query, mode, LogicalOperator.OR_OPERATOR);
    }

    public String getQuery() {
        return this.query;
    }

    public PropertiesSearchMode getMode() {
        return this.mode;
    }

    public LogicalOperator getLogicalOperator() {
        return this.logicalOperator;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.query, this.mode, this.logicalOperator});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PropertiesSearchQuery other = (PropertiesSearchQuery)obj;
            return !(this.query != other.query && !this.query.equals(other.query) || this.mode != other.mode && !this.mode.equals(other.mode) || this.logicalOperator != other.logicalOperator && !this.logicalOperator.equals((Object)other.logicalOperator));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PropertiesSearchQuery> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PropertiesSearchQuery value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("query");
            StoneSerializers.string().serialize(value.query, g);
            g.writeFieldName("mode");
            PropertiesSearchMode.Serializer.INSTANCE.serialize(value.mode, g);
            g.writeFieldName("logical_operator");
            LogicalOperator.Serializer.INSTANCE.serialize(value.logicalOperator, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PropertiesSearchQuery deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            LogicalOperator f_logicalOperator;
            PropertiesSearchMode f_mode;
            String f_query;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_query = null;
                f_mode = null;
                f_logicalOperator = LogicalOperator.OR_OPERATOR;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("query".equals(field)) {
                        f_query = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("mode".equals(field)) {
                        f_mode = PropertiesSearchMode.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("logical_operator".equals(field)) {
                        f_logicalOperator = LogicalOperator.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_query == null) {
                    throw new JsonParseException(p, "Required field \"query\" missing.");
                }
                if (f_mode == null) {
                    throw new JsonParseException(p, "Required field \"mode\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PropertiesSearchQuery value = new PropertiesSearchQuery(f_query, f_mode, f_logicalOperator);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

