/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.config;

import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;

@InternalExtensionOnly
public class BulkOptions
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @InternalApi(value="For internal usage only")
    public static final int BIGTABLE_ASYNC_MUTATOR_COUNT_DEFAULT = 2;
    @InternalApi(value="For internal usage only")
    public static final long BIGTABLE_BULK_MAX_REQUEST_SIZE_BYTES_DEFAULT = 0x1400000L;
    @InternalApi(value="For internal usage only")
    public static final int BIGTABLE_BULK_MAX_ROW_KEY_COUNT_DEFAULT = 100;
    @InternalApi(value="For internal usage only")
    public static final boolean BIGTABLE_BULK_ENABLE_THROTTLE_REBALANCE_DEFAULT = false;
    @InternalApi(value="For internal usage only")
    public static final int BIGTABLE_BULK_THROTTLE_TARGET_MS_DEFAULT = 100;
    @InternalApi(value="For internal usage only")
    public static long BIGTABLE_BULK_AUTOFLUSH_MS_DEFAULT = 1000L;
    @InternalApi(value="For internal usage only")
    public static final int BIGTABLE_MAX_INFLIGHT_RPCS_PER_CHANNEL_DEFAULT = 10;
    @InternalApi(value="For internal usage only")
    public static final long BIGTABLE_MAX_MEMORY_DEFAULT = 0x6400000L;
    private int asyncMutatorCount;
    private boolean useBulkApi;
    private int bulkMaxRowKeyCount;
    private long bulkMaxRequestSize;
    private long autoflushMs;
    private int maxInflightRpcs;
    private long maxMemory;
    private boolean enableBulkMutationThrottling;
    private int bulkMutationRpcTargetMs;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    BulkOptions() {
        this.asyncMutatorCount = 1;
        this.useBulkApi = false;
        this.bulkMaxRowKeyCount = -1;
        this.bulkMaxRequestSize = -1L;
        this.autoflushMs = -1L;
        this.maxInflightRpcs = -1;
        this.maxMemory = -1L;
        this.enableBulkMutationThrottling = false;
        this.bulkMutationRpcTargetMs = -1;
    }

    private BulkOptions(int asyncMutatorCount, boolean useBulkApi, int bulkMaxKeyCount, long bulkMaxRequestSize, long autoflushMs, int maxInflightRpcs, long maxMemory, boolean enableBulkMutationThrottling, int bulkMutationRpcTargetMs) {
        this.asyncMutatorCount = asyncMutatorCount;
        this.useBulkApi = useBulkApi;
        this.bulkMaxRowKeyCount = bulkMaxKeyCount;
        this.bulkMaxRequestSize = bulkMaxRequestSize;
        this.autoflushMs = autoflushMs;
        this.maxInflightRpcs = maxInflightRpcs;
        this.maxMemory = maxMemory;
        this.enableBulkMutationThrottling = enableBulkMutationThrottling;
        this.bulkMutationRpcTargetMs = bulkMutationRpcTargetMs;
    }

    public int getAsyncMutatorCount() {
        return this.asyncMutatorCount;
    }

    public boolean useBulkApi() {
        return this.useBulkApi;
    }

    public int getBulkMaxRowKeyCount() {
        return this.bulkMaxRowKeyCount;
    }

    public long getBulkMaxRequestSize() {
        return this.bulkMaxRequestSize;
    }

    public long getAutoflushMs() {
        return this.autoflushMs;
    }

    public int getMaxInflightRpcs() {
        return this.maxInflightRpcs;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public boolean isEnableBulkMutationThrottling() {
        return this.enableBulkMutationThrottling;
    }

    public int getBulkMutationRpcTargetMs() {
        return this.bulkMutationRpcTargetMs;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != BulkOptions.class) {
            return false;
        }
        BulkOptions other = (BulkOptions)obj;
        return this.asyncMutatorCount == other.asyncMutatorCount && this.useBulkApi == other.useBulkApi && this.bulkMaxRowKeyCount == other.bulkMaxRowKeyCount && this.bulkMaxRequestSize == other.bulkMaxRequestSize && this.autoflushMs == other.autoflushMs && this.maxInflightRpcs == other.maxInflightRpcs && this.maxMemory == other.maxMemory && this.enableBulkMutationThrottling == other.enableBulkMutationThrottling && this.bulkMutationRpcTargetMs == other.bulkMutationRpcTargetMs;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("asyncMutatorCount", this.asyncMutatorCount).add("useBulkApi", this.useBulkApi).add("bulkMaxKeyCount", this.bulkMaxRowKeyCount).add("bulkMaxRequestSize", this.bulkMaxRequestSize).add("autoflushMs", this.autoflushMs).add("maxInflightRpcs", this.maxInflightRpcs).add("maxMemory", this.maxMemory).add("enableBulkMutationThrottling", this.enableBulkMutationThrottling).add("bulkMutationRpcTargetMs", this.bulkMutationRpcTargetMs).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BulkOptions clone() {
        try {
            return (BulkOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone BulkOptions");
        }
    }

    public static class Builder {
        private BulkOptions options;

        @Deprecated
        public Builder() {
            this.options = new BulkOptions();
            this.options.asyncMutatorCount = 2;
            this.options.useBulkApi = true;
            this.options.bulkMaxRowKeyCount = 100;
            this.options.bulkMaxRequestSize = 0x1400000L;
            this.options.autoflushMs = BIGTABLE_BULK_AUTOFLUSH_MS_DEFAULT;
            this.options.maxInflightRpcs = -1;
            this.options.maxMemory = 0x6400000L;
            this.options.enableBulkMutationThrottling = false;
            this.options.bulkMutationRpcTargetMs = 100;
        }

        private Builder(BulkOptions options) {
            this.options = options.clone();
        }

        public Builder setAsyncMutatorWorkerCount(int asyncMutatorCount) {
            Preconditions.checkArgument((asyncMutatorCount >= 0 ? 1 : 0) != 0, (Object)"asyncMutatorCount must be greater or equal to 0.");
            this.options.asyncMutatorCount = asyncMutatorCount;
            return this;
        }

        public Builder setUseBulkApi(boolean useBulkApi) {
            this.options.useBulkApi = useBulkApi;
            return this;
        }

        public Builder setBulkMaxRowKeyCount(int bulkMaxRowKeyCount) {
            Preconditions.checkArgument((bulkMaxRowKeyCount >= 0 ? 1 : 0) != 0, (Object)"bulkMaxRowKeyCount must be greater or equal to 0.");
            this.options.bulkMaxRowKeyCount = bulkMaxRowKeyCount;
            return this;
        }

        public Builder setBulkMaxRequestSize(long bulkMaxRequestSize) {
            Preconditions.checkArgument((bulkMaxRequestSize >= 0L ? 1 : 0) != 0, (Object)"bulkMaxRequestSize must be greater or equal to 0.");
            this.options.bulkMaxRequestSize = bulkMaxRequestSize;
            return this;
        }

        public Builder setAutoflushMs(long autoflushMs) {
            Preconditions.checkArgument((autoflushMs >= 0L ? 1 : 0) != 0, (Object)"autoflushMs must be greater or equal to 0.");
            this.options.autoflushMs = autoflushMs;
            return this;
        }

        public Builder setMaxInflightRpcs(int maxInflightRpcs) {
            Preconditions.checkArgument((maxInflightRpcs > 0 ? 1 : 0) != 0, (Object)"maxInflightRpcs must be greater than 0.");
            this.options.maxInflightRpcs = maxInflightRpcs;
            return this;
        }

        public Builder setMaxMemory(long maxMemory) {
            Preconditions.checkArgument((maxMemory > 0L ? 1 : 0) != 0, (Object)"maxMemory must be greater than 0.");
            this.options.maxMemory = maxMemory;
            return this;
        }

        @Deprecated
        public Builder enableBulkMutationThrottling() {
            this.options.enableBulkMutationThrottling = true;
            return this;
        }

        @Deprecated
        public Builder setBulkMutationRpcTargetMs(int bulkMutationRpcTargetMs) {
            this.options.bulkMutationRpcTargetMs = bulkMutationRpcTargetMs;
            return this;
        }

        public BulkOptions build() {
            return this.options;
        }
    }
}

