/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.Backup;
import com.google.bigtable.admin.v2.CreateTableFromSnapshotRequest;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.DeleteBackupRequest;
import com.google.bigtable.admin.v2.DeleteSnapshotRequest;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.GetBackupRequest;
import com.google.bigtable.admin.v2.GetSnapshotRequest;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.ListBackupsRequest;
import com.google.bigtable.admin.v2.ListBackupsResponse;
import com.google.bigtable.admin.v2.ListSnapshotsRequest;
import com.google.bigtable.admin.v2.ListSnapshotsResponse;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.ListTablesResponse;
import com.google.bigtable.admin.v2.RestoreTableMetadata;
import com.google.bigtable.admin.v2.Snapshot;
import com.google.bigtable.admin.v2.SnapshotTableRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.CreateBackupRequest;
import com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.cloud.bigtable.admin.v2.models.RestoreTableRequest;
import com.google.cloud.bigtable.admin.v2.models.RestoredTableResult;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.cloud.bigtable.admin.v2.models.UpdateBackupRequest;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.core.IBigtableTableAdminClient;
import com.google.cloud.bigtable.grpc.BigtableClusterName;
import com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.cloud.bigtable.grpc.BigtableSessionSharedThreadPools;
import com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import com.google.cloud.bigtable.util.ApiFutureUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.longrunning.Operation;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;

@InternalApi(value="For internal usage only - please use BigtableTableAdminClient")
public class BigtableTableAdminClientWrapper
implements IBigtableTableAdminClient {
    private final BigtableTableAdminClient delegate;
    private final BigtableInstanceName instanceName;
    private final ExecutorService batchThreadPool;

    public BigtableTableAdminClientWrapper(@Nonnull BigtableTableAdminClient adminClient, @Nonnull BigtableOptions options) {
        Preconditions.checkNotNull((Object)adminClient);
        Preconditions.checkNotNull((Object)options);
        this.delegate = adminClient;
        this.instanceName = options.getInstanceName();
        this.batchThreadPool = BigtableSessionSharedThreadPools.getInstance().getBatchThreadPool();
    }

    @Override
    public Table createTable(com.google.cloud.bigtable.admin.v2.models.CreateTableRequest request) {
        CreateTableRequest requestProto = request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId());
        com.google.bigtable.admin.v2.Table proto = this.delegate.createTable(requestProto);
        return Table.fromProto((com.google.bigtable.admin.v2.Table)proto);
    }

    @Override
    public ApiFuture<Table> createTableAsync(com.google.cloud.bigtable.admin.v2.models.CreateTableRequest request) {
        CreateTableRequest requestProto = request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId());
        return ApiFutureUtil.transformAndAdapt(this.delegate.createTableAsync(requestProto), new Function<com.google.bigtable.admin.v2.Table, Table>(){

            public Table apply(com.google.bigtable.admin.v2.Table tableProto) {
                return Table.fromProto((com.google.bigtable.admin.v2.Table)tableProto);
            }
        });
    }

    @Override
    public Table getTable(String tableId) {
        GetTableRequest requestProto = GetTableRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).build();
        return Table.fromProto((com.google.bigtable.admin.v2.Table)this.delegate.getTable(requestProto));
    }

    @Override
    public ApiFuture<Table> getTableAsync(String tableId) {
        GetTableRequest requestProto = GetTableRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.getTableAsync(requestProto), new Function<com.google.bigtable.admin.v2.Table, Table>(){

            public Table apply(com.google.bigtable.admin.v2.Table tableProto) {
                return Table.fromProto((com.google.bigtable.admin.v2.Table)tableProto);
            }
        });
    }

    @Override
    public List<String> listTables() {
        ListTablesRequest requestProto = ListTablesRequest.newBuilder().setParent(this.instanceName.toString()).build();
        ListTablesResponse response = this.delegate.listTables(requestProto);
        ImmutableList.Builder tableIdsBuilder = ImmutableList.builder();
        for (com.google.bigtable.admin.v2.Table tableProto : response.getTablesList()) {
            tableIdsBuilder.add((Object)this.instanceName.toTableId(tableProto.getName()));
        }
        return tableIdsBuilder.build();
    }

    @Override
    public ApiFuture<List<String>> listTablesAsync() {
        ListTablesRequest request = ListTablesRequest.newBuilder().setParent(this.instanceName.toString()).build();
        ListenableFuture<ListTablesResponse> response = this.delegate.listTablesAsync(request);
        return ApiFutureUtil.transformAndAdapt(response, new Function<ListTablesResponse, List<String>>(){

            public List<String> apply(ListTablesResponse input) {
                ImmutableList.Builder tableIdsBuilder = ImmutableList.builder();
                for (com.google.bigtable.admin.v2.Table tableProto : input.getTablesList()) {
                    tableIdsBuilder.add((Object)BigtableTableAdminClientWrapper.this.instanceName.toTableId(tableProto.getName()));
                }
                return tableIdsBuilder.build();
            }
        });
    }

    @Override
    public void deleteTable(String tableId) {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).build();
        this.delegate.deleteTable(request);
    }

    @Override
    public ApiFuture<Void> deleteTableAsync(String tableId) {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.deleteTableAsync(request), new Function<Empty, Void>(){

            public Void apply(Empty empty) {
                return null;
            }
        });
    }

    @Override
    public Table modifyFamilies(ModifyColumnFamiliesRequest request) {
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest modifyColumnRequestProto = request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId());
        return Table.fromProto((com.google.bigtable.admin.v2.Table)this.delegate.modifyColumnFamily(modifyColumnRequestProto));
    }

    @Override
    public ApiFuture<Table> modifyFamiliesAsync(ModifyColumnFamiliesRequest request) {
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest modifyColumnRequestProto = request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId());
        return ApiFutureUtil.transformAndAdapt(this.delegate.modifyColumnFamilyAsync(modifyColumnRequestProto), new Function<com.google.bigtable.admin.v2.Table, Table>(){

            public Table apply(com.google.bigtable.admin.v2.Table tableProto) {
                return Table.fromProto((com.google.bigtable.admin.v2.Table)tableProto);
            }
        });
    }

    @Override
    public void dropRowRange(String tableId, String rowKeyPrefix) {
        this.dropRowRange(tableId, ByteString.copyFromUtf8((String)rowKeyPrefix));
    }

    @Override
    public void dropRowRange(String tableId, ByteString rowKeyPrefix) {
        Preconditions.checkNotNull((Object)rowKeyPrefix);
        DropRowRangeRequest protoRequest = DropRowRangeRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).setDeleteAllDataFromTable(false).setRowKeyPrefix(rowKeyPrefix).build();
        this.delegate.dropRowRange(protoRequest);
    }

    @Override
    public ApiFuture<Void> dropRowRangeAsync(String tableId, String rowKeyPrefix) {
        return this.dropRowRangeAsync(tableId, ByteString.copyFromUtf8((String)rowKeyPrefix));
    }

    @Override
    public ApiFuture<Void> dropRowRangeAsync(String tableId, ByteString rowKeyPrefix) {
        Preconditions.checkNotNull((Object)rowKeyPrefix);
        DropRowRangeRequest protoRequest = DropRowRangeRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).setDeleteAllDataFromTable(false).setRowKeyPrefix(rowKeyPrefix).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.dropRowRangeAsync(protoRequest), new Function<Empty, Void>(){

            public Void apply(Empty empty) {
                return null;
            }
        });
    }

    @Override
    public void dropAllRows(String tableId) {
        DropRowRangeRequest protoRequest = DropRowRangeRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).setDeleteAllDataFromTable(true).build();
        this.delegate.dropRowRange(protoRequest);
    }

    @Override
    public ApiFuture<Void> dropAllRowsAsync(String tableId) {
        DropRowRangeRequest protoRequest = DropRowRangeRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).setDeleteAllDataFromTable(true).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.dropRowRangeAsync(protoRequest), new Function<Empty, Void>(){

            public Void apply(Empty empty) {
                return null;
            }
        });
    }

    @Override
    public ApiFuture<Operation> snapshotTableAsync(SnapshotTableRequest request) {
        return ApiFutureUtil.adapt(this.delegate.snapshotTableAsync(request));
    }

    @Override
    public ApiFuture<Snapshot> getSnapshotAsync(GetSnapshotRequest request) {
        return ApiFutureUtil.adapt(this.delegate.getSnapshotAsync(request));
    }

    @Override
    public ApiFuture<ListSnapshotsResponse> listSnapshotsAsync(ListSnapshotsRequest request) {
        return ApiFutureUtil.adapt(this.delegate.listSnapshotsAsync(request));
    }

    @Override
    public ApiFuture<Void> deleteSnapshotAsync(DeleteSnapshotRequest request) {
        return ApiFutureUtil.transformAndAdapt(this.delegate.deleteSnapshotAsync(request), new Function<Empty, Void>(){

            public Void apply(Empty input) {
                return null;
            }
        });
    }

    @Override
    public ApiFuture<Operation> createTableFromSnapshotAsync(CreateTableFromSnapshotRequest request) {
        return ApiFutureUtil.adapt(this.delegate.createTableFromSnapshotAsync(request));
    }

    @Override
    public ApiFuture<com.google.cloud.bigtable.admin.v2.models.Backup> createBackupAsync(CreateBackupRequest request) {
        ListenableFuture<Operation> backupAsync = this.delegate.createBackupAsync(request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId()));
        Function<Operation, com.google.cloud.bigtable.admin.v2.models.Backup> function = new Function<Operation, com.google.cloud.bigtable.admin.v2.models.Backup>(){

            public com.google.cloud.bigtable.admin.v2.models.Backup apply(final Operation operation) {
                try {
                    Future<Operation> operationFuture = BigtableTableAdminClientWrapper.this.batchThreadPool.submit(new Callable<Operation>(){

                        @Override
                        public Operation call() throws Exception {
                            return BigtableTableAdminClientWrapper.this.delegate.waitForOperation(operation);
                        }
                    });
                    return com.google.cloud.bigtable.admin.v2.models.Backup.fromProto((Backup)((Backup)operationFuture.get().getResponse().unpack(Backup.class)));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted while waiting for operation to finish");
                }
                catch (InvalidProtocolBufferException | ExecutionException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        return ApiFutureUtil.transformAndAdapt(backupAsync, function);
    }

    @Override
    public ApiFuture<com.google.cloud.bigtable.admin.v2.models.Backup> getBackupAsync(String clusterId, String backupId) {
        BigtableClusterName clusterName = this.instanceName.toClusterName(clusterId);
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(clusterName.toBackupName(backupId)).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.getBackupAsync(request), new Function<Backup, com.google.cloud.bigtable.admin.v2.models.Backup>(){

            public com.google.cloud.bigtable.admin.v2.models.Backup apply(Backup backup) {
                return com.google.cloud.bigtable.admin.v2.models.Backup.fromProto((Backup)backup);
            }
        });
    }

    @Override
    public ApiFuture<com.google.cloud.bigtable.admin.v2.models.Backup> updateBackupAsync(UpdateBackupRequest request) {
        return ApiFutureUtil.transformAndAdapt(this.delegate.updateBackupAsync(request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId())), new Function<Backup, com.google.cloud.bigtable.admin.v2.models.Backup>(){

            public com.google.cloud.bigtable.admin.v2.models.Backup apply(Backup backup) {
                return com.google.cloud.bigtable.admin.v2.models.Backup.fromProto((Backup)backup);
            }
        });
    }

    @Override
    public ApiFuture<List<String>> listBackupsAsync(String clusterId) {
        BigtableClusterName clusterName = this.instanceName.toClusterName(clusterId);
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(clusterName.getClusterName()).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.listBackupsAsync(request), new Function<ListBackupsResponse, List<String>>(){

            public List<String> apply(ListBackupsResponse response) {
                ArrayList<String> backups = new ArrayList<String>();
                for (Backup backup : response.getBackupsList()) {
                    backups.add(NameUtil.extractBackupIdFromBackupName((String)backup.getName()));
                }
                return backups;
            }
        });
    }

    @Override
    public ApiFuture<Void> deleteBackupAsync(String clusterId, String backupId) {
        BigtableClusterName clusterName = this.instanceName.toClusterName(clusterId);
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(clusterName.toBackupName(backupId)).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.deleteBackupAsync(request), new Function<Empty, Void>(){

            public Void apply(Empty empty) {
                return null;
            }
        });
    }

    @Override
    public ApiFuture<RestoredTableResult> restoreTableAsync(RestoreTableRequest request) {
        return ApiFutureUtil.transformAndAdapt(this.delegate.restoreTableAsync(request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId())), new Function<Operation, RestoredTableResult>(){

            public RestoredTableResult apply(final Operation operation) {
                try {
                    Future<Operation> operationFuture = BigtableTableAdminClientWrapper.this.batchThreadPool.submit(new Callable<Operation>(){

                        @Override
                        public Operation call() throws Exception {
                            return BigtableTableAdminClientWrapper.this.delegate.waitForOperation(operation);
                        }
                    });
                    return new RestoredTableResult(Table.fromProto((com.google.bigtable.admin.v2.Table)((com.google.bigtable.admin.v2.Table)operationFuture.get().getResponse().unpack(com.google.bigtable.admin.v2.Table.class))), ((RestoreTableMetadata)operation.getMetadata().unpack(RestoreTableMetadata.class)).getOptimizeTableOperationName());
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

