/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class ConnectionProperty {
    static final Function<com.google.api.services.bigquery.model.ConnectionProperty, ConnectionProperty> FROM_PB_FUNCTION = new Function<com.google.api.services.bigquery.model.ConnectionProperty, ConnectionProperty>(){

        public ConnectionProperty apply(com.google.api.services.bigquery.model.ConnectionProperty connectionProperty) {
            return ConnectionProperty.fromPb(connectionProperty);
        }
    };
    static final Function<ConnectionProperty, com.google.api.services.bigquery.model.ConnectionProperty> TO_PB_FUNCTION = new Function<ConnectionProperty, com.google.api.services.bigquery.model.ConnectionProperty>(){

        public com.google.api.services.bigquery.model.ConnectionProperty apply(ConnectionProperty connectionProperty) {
            return connectionProperty.toPb();
        }
    };
    private final String key;
    private final String value;

    private ConnectionProperty(Builder builder) {
        this.key = (String)Preconditions.checkNotNull((Object)builder.key, (Object)"Required key is null or empty");
        this.value = (String)Preconditions.checkNotNull((Object)builder.value, (Object)"Required value is null or empty");
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static ConnectionProperty of(String key, String value) {
        return ConnectionProperty.newBuilder().setKey(key).setValue(value).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("value", (Object)this.value).toString();
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.key, this.value});
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(ConnectionProperty.class) && Objects.equals(this.toPb(), ((ConnectionProperty)obj).toPb());
    }

    com.google.api.services.bigquery.model.ConnectionProperty toPb() {
        com.google.api.services.bigquery.model.ConnectionProperty properties = new com.google.api.services.bigquery.model.ConnectionProperty();
        properties.setKey(this.key);
        properties.setValue(this.value);
        return properties;
    }

    static ConnectionProperty fromPb(com.google.api.services.bigquery.model.ConnectionProperty properties) {
        Builder builder = ConnectionProperty.newBuilder();
        builder.setKey(properties.getKey());
        builder.setValue(properties.getValue());
        return builder.build();
    }

    public static final class Builder {
        private String key;
        private String value;

        private Builder() {
        }

        private Builder(ConnectionProperty properties) {
            this.key = properties.key;
            this.value = properties.value;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public ConnectionProperty build() {
            return new ConnectionProperty(this);
        }
    }
}

