/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.SinkMetrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaWriter<K, V>
extends DoFn<ProducerRecord<K, V>, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaWriter.class);
    private final KafkaIO.WriteRecords<K, V> spec;
    private final Map<String, Object> producerConfig;
    private transient @Nullable Producer<K, V> producer = null;
    private transient @Nullable Exception sendException = null;
    private transient long numSendFailures = 0L;
    private final Counter elementsWritten = SinkMetrics.elementsWritten();

    @DoFn.Setup
    public void setup() {
        this.producer = this.spec.getProducerFactoryFn() != null ? (Producer)this.spec.getProducerFactoryFn().apply(this.producerConfig) : new KafkaProducer(this.producerConfig);
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext ctx) throws Exception {
        String topicName;
        Producer producer = (Producer)Preconditions.checkStateNotNull(this.producer);
        this.checkForFailures();
        ProducerRecord record = (ProducerRecord)ctx.element();
        @Nullable Long timestampMillis = record.timestamp();
        if (timestampMillis == null && this.spec.getPublishTimestampFunction() != null) {
            timestampMillis = this.spec.getPublishTimestampFunction().getTimestamp(record, ctx.timestamp()).getMillis();
        }
        if ((topicName = record.topic()) == null) {
            topicName = this.spec.getTopic();
        }
        Future ignored = producer.send(new ProducerRecord(topicName, record.partition(), timestampMillis, record.key(), record.value(), (Iterable)record.headers()), (Callback)new SendCallback());
        this.elementsWritten.inc();
    }

    @DoFn.FinishBundle
    public void finishBundle() throws IOException {
        Producer producer = (Producer)Preconditions.checkStateNotNull(this.producer);
        producer.flush();
        this.checkForFailures();
    }

    @DoFn.Teardown
    public void teardown() {
        Producer producer = (Producer)Preconditions.checkStateNotNull(this.producer);
        producer.close();
    }

    KafkaWriter(KafkaIO.WriteRecords<K, V> spec) {
        this.spec = spec;
        this.producerConfig = new HashMap<String, Object>(spec.getProducerConfig());
        if (spec.getKeySerializer() != null) {
            this.producerConfig.put("key.serializer", spec.getKeySerializer());
        }
        if (spec.getValueSerializer() != null) {
            this.producerConfig.put("value.serializer", spec.getValueSerializer());
        }
    }

    private synchronized void checkForFailures() throws IOException {
        if (this.numSendFailures == 0L) {
            return;
        }
        String msg = String.format("KafkaWriter : failed to send %d records (since last report)", this.numSendFailures);
        Exception e = this.sendException;
        this.sendException = null;
        this.numSendFailures = 0L;
        LOG.warn(msg);
        throw new IOException(msg, e);
    }

    private class SendCallback
    implements Callback {
        private SendCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception == null) {
                return;
            }
            KafkaWriter kafkaWriter = KafkaWriter.this;
            synchronized (kafkaWriter) {
                if (KafkaWriter.this.sendException == null) {
                    KafkaWriter.this.sendException = exception;
                }
                KafkaWriter.this.numSendFailures++;
            }
            LOG.warn("send failed : '{}'", (Object)exception.getMessage());
        }
    }
}

