/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.control;

import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.repackaged.direct_java.sdk.fn.stream.SynchronizedStreamObserver;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.StatusRuntimeException;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FnApiControlClient
implements Closeable,
InstructionRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FnApiControlClient.class);
    private final StreamObserver<BeamFnApi.InstructionRequest> requestReceiver;
    private final ResponseStreamObserver responseObserver = new ResponseStreamObserver();
    private final ConcurrentMap<String, CompletableFuture<BeamFnApi.InstructionResponse>> outstandingRequests;
    private final Set<Consumer<FnApiControlClient>> onCloseListeners = ConcurrentHashMap.newKeySet();
    private final String workerId;
    private AtomicBoolean isClosed = new AtomicBoolean(false);
    private final ConcurrentMap<String, BeamFnApi.ProcessBundleDescriptor> processBundleDescriptors;

    private FnApiControlClient(String workerId, StreamObserver<BeamFnApi.InstructionRequest> requestReceiver, ConcurrentMap<String, BeamFnApi.ProcessBundleDescriptor> processBundleDescriptors) {
        this.workerId = workerId;
        this.requestReceiver = SynchronizedStreamObserver.wrapping(requestReceiver);
        this.processBundleDescriptors = processBundleDescriptors;
        this.outstandingRequests = new ConcurrentHashMap<String, CompletableFuture<BeamFnApi.InstructionResponse>>();
    }

    public static FnApiControlClient forRequestObserver(String workerId, StreamObserver<BeamFnApi.InstructionRequest> requestObserver, ConcurrentMap<String, BeamFnApi.ProcessBundleDescriptor> processBundleDescriptors) {
        return new FnApiControlClient(workerId, requestObserver, processBundleDescriptors);
    }

    @Override
    public CompletionStage<BeamFnApi.InstructionResponse> handle(BeamFnApi.InstructionRequest request) {
        LOG.debug("Sending InstructionRequest {}", (Object)request);
        CompletableFuture<BeamFnApi.InstructionResponse> resultFuture = new CompletableFuture<BeamFnApi.InstructionResponse>();
        this.outstandingRequests.put(request.getInstructionId(), resultFuture);
        this.requestReceiver.onNext((Object)request);
        return resultFuture;
    }

    public StreamObserver<BeamFnApi.InstructionResponse> asResponseObserver() {
        return this.responseObserver;
    }

    public BeamFnApi.ProcessBundleDescriptor getProcessBundleDescriptor(String id) {
        return (BeamFnApi.ProcessBundleDescriptor)this.processBundleDescriptors.get(id);
    }

    @Override
    public void registerProcessBundleDescriptor(BeamFnApi.ProcessBundleDescriptor processBundleDescriptor) {
        this.processBundleDescriptors.put(processBundleDescriptor.getId(), processBundleDescriptor);
    }

    @Override
    public void close() {
        this.closeAndTerminateOutstandingRequests(new IllegalStateException("Runner closed connection"));
    }

    public String getWorkerId() {
        return this.workerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndTerminateOutstandingRequests(Throwable cause) {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        try {
            ConcurrentHashMap<String, CompletableFuture<BeamFnApi.InstructionResponse>> outstandingRequestsCopy = new ConcurrentHashMap<String, CompletableFuture<BeamFnApi.InstructionResponse>>(this.outstandingRequests);
            this.outstandingRequests.clear();
            if (outstandingRequestsCopy.isEmpty()) {
                this.requestReceiver.onCompleted();
                return;
            }
            this.requestReceiver.onError((Throwable)new StatusRuntimeException(Status.CANCELLED.withDescription(cause.getMessage())));
            LOG.error("{} closed, clearing outstanding requests {}", (Object)FnApiControlClient.class.getSimpleName(), outstandingRequestsCopy);
            for (CompletableFuture outstandingRequest : outstandingRequestsCopy.values()) {
                outstandingRequest.completeExceptionally(cause);
            }
        }
        finally {
            for (Consumer<FnApiControlClient> onCloseListener : this.onCloseListeners) {
                onCloseListener.accept(this);
            }
        }
    }

    public void onClose(Consumer<FnApiControlClient> onCloseListener) {
        this.onCloseListeners.add(onCloseListener);
    }

    private class ResponseStreamObserver
    implements StreamObserver<BeamFnApi.InstructionResponse> {
        private ResponseStreamObserver() {
        }

        public void onNext(BeamFnApi.InstructionResponse response) {
            LOG.debug("Received InstructionResponse {}", (Object)response);
            CompletableFuture responseFuture = (CompletableFuture)FnApiControlClient.this.outstandingRequests.remove(response.getInstructionId());
            if (responseFuture == null) {
                LOG.warn("Dropped unknown InstructionResponse {}", (Object)response);
                return;
            }
            if (response.getError().isEmpty()) {
                responseFuture.complete(response);
            } else {
                responseFuture.completeExceptionally(new RuntimeException(String.format("Error received from SDK harness for instruction %s: %s", response.getInstructionId(), response.getError())));
            }
        }

        public void onCompleted() {
            FnApiControlClient.this.closeAndTerminateOutstandingRequests(new IllegalStateException("SDK harness closed connection"));
        }

        public void onError(Throwable cause) {
            LOG.error("{} received an error.", (Object)FnApiControlClient.class.getSimpleName(), (Object)cause);
            FnApiControlClient.this.closeAndTerminateOutstandingRequests(cause);
        }
    }
}

