/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pipelineexecutor;

import org.apache.hop.core.Const;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class PipelineExecutorParameters
implements Cloneable {
    public static final String XML_TAG = "parameters";
    private static final String XML_VARIABLES_TAG = "variable_mapping";
    private String[] variable;
    private String[] field;
    private String[] input;
    private boolean inheritingAllVariables;

    public PipelineExecutorParameters() {
        this.variable = new String[0];
        this.field = new String[0];
        this.input = new String[0];
        this.inheritingAllVariables = true;
    }

    public void allocate(int nrVariables) {
        this.variable = new String[nrVariables];
        this.field = new String[nrVariables];
        this.input = new String[nrVariables];
    }

    public Object clone() {
        try {
            PipelineExecutorParameters retval = (PipelineExecutorParameters)super.clone();
            int nrVariables = this.variable.length;
            retval.allocate(nrVariables);
            System.arraycopy(this.variable, 0, retval.variable, 0, nrVariables);
            System.arraycopy(this.field, 0, retval.field, 0, nrVariables);
            System.arraycopy(this.input, 0, retval.input, 0, nrVariables);
            return retval;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public PipelineExecutorParameters(Node paramNode) {
        int nrVariables = XmlHandler.countNodes((Node)paramNode, (String)XML_VARIABLES_TAG);
        this.allocate(nrVariables);
        for (int i = 0; i < this.variable.length; ++i) {
            Node variableMappingNode = XmlHandler.getSubNodeByNr((Node)paramNode, (String)XML_VARIABLES_TAG, (int)i);
            this.variable[i] = XmlHandler.getTagValue((Node)variableMappingNode, (String)"variable");
            this.field[i] = XmlHandler.getTagValue((Node)variableMappingNode, (String)"field");
            this.input[i] = XmlHandler.getTagValue((Node)variableMappingNode, (String)"input");
        }
        this.inheritingAllVariables = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)paramNode, (String)"inherit_all_vars"));
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(200);
        xml.append("    ").append(XmlHandler.openTag((String)XML_TAG));
        for (int i = 0; i < this.variable.length; ++i) {
            xml.append("       ").append(XmlHandler.openTag((String)XML_VARIABLES_TAG));
            xml.append(XmlHandler.addTagValue((String)"variable", (String)this.variable[i], (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.addTagValue((String)"field", (String)this.field[i], (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.addTagValue((String)"input", (String)this.input[i], (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.closeTag((String)XML_VARIABLES_TAG)).append(Const.CR);
        }
        xml.append("    ").append(XmlHandler.addTagValue((String)"inherit_all_vars", (boolean)this.inheritingAllVariables));
        xml.append("    ").append(XmlHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public String[] getField() {
        return this.field;
    }

    public void setField(String[] field) {
        this.field = field;
    }

    public String[] getVariable() {
        return this.variable;
    }

    public void setVariable(String[] variable) {
        this.variable = variable;
    }

    public boolean isInheritingAllVariables() {
        return this.inheritingAllVariables;
    }

    public void setInheritingAllVariables(boolean inheritingAllVariables) {
        this.inheritingAllVariables = inheritingAllVariables;
    }

    public String[] getInput() {
        return this.input;
    }

    public void setInput(String[] input) {
        this.input = input;
    }
}

