/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.async;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.rest.handler.async.OperationKey;
import org.apache.flink.runtime.rest.handler.async.OperationResult;
import org.apache.flink.shaded.guava30.com.google.common.base.Ticker;
import org.apache.flink.shaded.guava30.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava30.com.google.common.cache.CacheBuilder;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CompletedOperationCache<K extends OperationKey, R>
implements AutoCloseableAsync {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletedOperationCache.class);
    private final Map<K, ResultAccessTracker<R>> registeredOperationTriggers = new ConcurrentHashMap<K, ResultAccessTracker<R>>();
    private final Cache<K, ResultAccessTracker<R>> completedOperations;
    private final Object lock = new Object();
    @Nullable
    private CompletableFuture<Void> terminationFuture;
    private Duration cacheDuration;

    public CompletedOperationCache(Duration cacheDuration) {
        this(cacheDuration, Ticker.systemTicker());
    }

    @VisibleForTesting
    CompletedOperationCache(Ticker ticker) {
        this((Duration)RestOptions.ASYNC_OPERATION_STORE_DURATION.defaultValue(), ticker);
    }

    @VisibleForTesting
    CompletedOperationCache(Duration cacheDuration, Ticker ticker) {
        this.cacheDuration = (Duration)Preconditions.checkNotNull((Object)cacheDuration);
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (cacheDuration.getSeconds() != 0L) {
            cacheBuilder = cacheBuilder.expireAfterWrite(cacheDuration);
        }
        this.completedOperations = cacheBuilder.removalListener(removalNotification -> {
            if (removalNotification.wasEvicted()) {
                Preconditions.checkState((removalNotification.getKey() != null ? 1 : 0) != 0);
                Preconditions.checkState((removalNotification.getValue() != null ? 1 : 0) != 0);
                ((ResultAccessTracker)removalNotification.getValue()).markAccessed();
                LOGGER.info("Evicted result with trigger id {} because its TTL of {}s has expired.", (Object)((OperationKey)removalNotification.getKey()).getTriggerId(), (Object)cacheDuration.getSeconds());
            }
        }).ticker(ticker).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOngoingOperation(K operationKey, CompletableFuture<R> operationResultFuture) {
        ResultAccessTracker inProgress = ResultAccessTracker.inProgress();
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.isRunning(), (Object)"The CompletedOperationCache has already been closed.");
            this.registeredOperationTriggers.put(operationKey, inProgress);
        }
        operationResultFuture.whenComplete((result, error) -> {
            if (error == null) {
                this.completedOperations.put((Object)operationKey, inProgress.finishOperation(OperationResult.success(result)));
            } else {
                this.completedOperations.put((Object)operationKey, inProgress.finishOperation(OperationResult.failure(error)));
            }
            this.registeredOperationTriggers.remove(operationKey);
        });
    }

    @GuardedBy(value="lock")
    private boolean isRunning() {
        return this.terminationFuture == null;
    }

    public boolean containsOperation(K operationKey) {
        return this.registeredOperationTriggers.containsKey(operationKey) || this.completedOperations.getIfPresent(operationKey) != null;
    }

    public Optional<OperationResult<R>> get(K operationKey) {
        ResultAccessTracker resultAccessTracker = this.registeredOperationTriggers.get(operationKey);
        if (resultAccessTracker == null && (resultAccessTracker = (ResultAccessTracker)this.completedOperations.getIfPresent(operationKey)) == null) {
            return Optional.empty();
        }
        return Optional.of(resultAccessTracker.accessOperationResultOrError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> closeAsync() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning()) {
                this.terminationFuture = FutureUtils.orTimeout(this.asyncWaitForResultsToBeAccessed(), (long)this.cacheDuration.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
            }
            return this.terminationFuture;
        }
    }

    private CompletableFuture<Void> asyncWaitForResultsToBeAccessed() {
        return FutureUtils.waitForAll((Collection)Stream.concat(this.registeredOperationTriggers.values().stream(), this.completedOperations.asMap().values().stream()).map(ResultAccessTracker::getAccessedFuture).collect(Collectors.toList()));
    }

    @VisibleForTesting
    void cleanUp() {
        this.completedOperations.cleanUp();
    }

    private static class ResultAccessTracker<R> {
        private final OperationResult<R> operationResult;
        private final CompletableFuture<Void> accessed;

        private static <R> ResultAccessTracker<R> inProgress() {
            return new ResultAccessTracker<R>();
        }

        private ResultAccessTracker() {
            this.operationResult = OperationResult.inProgress();
            this.accessed = new CompletableFuture();
        }

        private ResultAccessTracker(OperationResult<R> operationResult, CompletableFuture<Void> accessed) {
            this.operationResult = (OperationResult)Preconditions.checkNotNull(operationResult);
            this.accessed = (CompletableFuture)Preconditions.checkNotNull(accessed);
        }

        public ResultAccessTracker<R> finishOperation(OperationResult<R> operationResult) {
            Preconditions.checkState((!this.operationResult.isFinished() ? 1 : 0) != 0);
            return new ResultAccessTracker<R>((OperationResult)Preconditions.checkNotNull(operationResult), this.accessed);
        }

        public OperationResult<R> accessOperationResultOrError() {
            if (this.operationResult.isFinished()) {
                this.markAccessed();
            }
            return this.operationResult;
        }

        public CompletableFuture<Void> getAccessedFuture() {
            return this.accessed;
        }

        private void markAccessed() {
            this.accessed.complete(null);
        }
    }
}

