/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.RedshiftResultSetMetaData;
import com.amazon.redshift.core.BaseConnection;
import com.amazon.redshift.core.Field;
import com.amazon.redshift.core.v3.ConnectionFactoryImpl;
import com.amazon.redshift.jdbc.FieldMetadata;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.Gettable;
import com.amazon.redshift.util.GettableHashMap;
import com.amazon.redshift.util.JdbcBlackHole;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class RedshiftResultSetMetaDataImpl
implements ResultSetMetaData,
RedshiftResultSetMetaData {
    protected final BaseConnection connection;
    protected final Field[] fields;
    private boolean fieldInfoFetched;

    public RedshiftResultSetMetaDataImpl(BaseConnection connection, Field[] fields) {
        this.connection = connection;
        this.fields = fields;
        this.fieldInfoFetched = connection.getQueryExecutor().getServerProtocolVersion() >= ConnectionFactoryImpl.EXTENDED_RESULT_METADATA_SERVER_PROTOCOL_VERSION;
    }

    @Override
    public int getColumnCount() throws SQLException {
        int rc = this.fields.length;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        FieldMetadata metadata = field.getMetadata();
        return metadata != null && metadata.autoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        Field field = this.getField(column);
        if (this.connection.getQueryExecutor().getServerProtocolVersion() >= ConnectionFactoryImpl.EXTENDED2_RESULT_METADATA_SERVER_PROTOCOL_VERSION) {
            FieldMetadata metadata = field.getMetadata();
            return metadata == null ? false : metadata.caseSensitive;
        }
        return this.connection.getTypeInfo().isCaseSensitive(field.getOID());
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        Field field = this.getField(column);
        FieldMetadata metadata = field.getMetadata();
        return metadata == null ? true : metadata.searchable;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        String typeName = this.getRSType(column);
        return typeName.equals("cash") || typeName.equals("money");
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        FieldMetadata metadata = field.getMetadata();
        return metadata == null ? 1 : metadata.nullable;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().isSigned(field.getOID());
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().getDisplaySize(field.getOID(), field.getMod());
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        Field field = this.getField(column);
        return field.getColumnLabel();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    @Override
    public String getBaseColumnName(int column) throws SQLException {
        Field field = this.getField(column);
        if (field.getTableOid() == 0) {
            return "";
        }
        this.fetchFieldMetaData();
        FieldMetadata metadata = field.getMetadata();
        return metadata == null ? "" : metadata.columnName;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        Field field = this.getField(column);
        FieldMetadata metadata = field.getMetadata();
        return metadata == null ? "" : metadata.schemaName;
    }

    private boolean populateFieldsWithMetadata(Gettable<FieldMetadata.Key, FieldMetadata> metadata) {
        boolean allOk = true;
        for (Field field : this.fields) {
            if (field.getMetadata() != null) continue;
            FieldMetadata fieldMetadata = metadata.get(new FieldMetadata.Key(field.getTableOid(), field.getPositionInTable()));
            if (fieldMetadata == null) {
                allOk = false;
                continue;
            }
            field.setMetadata(fieldMetadata);
        }
        this.fieldInfoFetched |= allOk;
        return allOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFieldMetaData() throws SQLException {
        if (this.fieldInfoFetched) {
            return;
        }
        if (this.populateFieldsWithMetadata(this.connection.getFieldMetadataCache())) {
            return;
        }
        StringBuilder sql = new StringBuilder("SELECT c.oid, a.attnum, a.attname, c.relname, n.nspname, a.attnotnull OR (t.typtype = 'd' AND t.typnotnull), ");
        sql.append("pg_catalog.pg_get_expr(d.adbin, d.adrelid) LIKE '%nextval(%' ");
        sql.append("FROM pg_catalog.pg_class c JOIN pg_catalog.pg_namespace n ON (c.relnamespace = n.oid) JOIN pg_catalog.pg_attribute a ON (c.oid = a.attrelid) JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid) LEFT JOIN pg_catalog.pg_attrdef d ON (d.adrelid = a.attrelid AND d.adnum = a.attnum) JOIN (");
        boolean hasSourceInfo = false;
        for (Field field : this.fields) {
            if (field.getMetadata() != null) continue;
            if (hasSourceInfo) {
                sql.append(" UNION ALL ");
            }
            sql.append("SELECT ");
            sql.append(field.getTableOid());
            if (!hasSourceInfo) {
                sql.append(" AS oid ");
            }
            sql.append(", ");
            sql.append(field.getPositionInTable());
            if (!hasSourceInfo) {
                sql.append(" AS attnum");
            }
            if (hasSourceInfo) continue;
            hasSourceInfo = true;
        }
        sql.append(") vals ON (c.oid = vals.oid AND a.attnum = vals.attnum) ");
        if (!hasSourceInfo) {
            this.fieldInfoFetched = true;
            return;
        }
        Statement stmt = this.connection.createStatement();
        ResultSet rs = null;
        GettableHashMap<FieldMetadata.Key, FieldMetadata> md = new GettableHashMap<FieldMetadata.Key, FieldMetadata>();
        try {
            rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                int table = (int)rs.getLong(1);
                int column = (int)rs.getLong(2);
                String columnName = rs.getString(3);
                String tableName = rs.getString(4);
                String schemaName = rs.getString(5);
                int nullable = rs.getBoolean(6) ? 0 : 1;
                boolean autoIncrement = rs.getBoolean(7);
                FieldMetadata fieldMetadata = new FieldMetadata(columnName, tableName, schemaName, nullable, autoIncrement);
                FieldMetadata.Key key = new FieldMetadata.Key(table, column);
                md.put(key, fieldMetadata);
            }
        }
        catch (Throwable throwable) {
            JdbcBlackHole.close(rs);
            JdbcBlackHole.close(stmt);
            throw throwable;
        }
        JdbcBlackHole.close(rs);
        JdbcBlackHole.close(stmt);
        this.populateFieldsWithMetadata(md);
        this.connection.getFieldMetadataCache().putAll(md);
    }

    @Override
    public String getBaseSchemaName(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        FieldMetadata metadata = field.getMetadata();
        return metadata == null ? "" : metadata.schemaName;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().getPrecision(field.getOID(), field.getMod());
    }

    @Override
    public int getScale(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().getScale(field.getOID(), field.getMod());
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getBaseTableName(column);
    }

    @Override
    public String getBaseTableName(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        FieldMetadata metadata = field.getMetadata();
        return metadata == null ? "" : metadata.tableName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        Field field = this.getField(column);
        FieldMetadata metadata = field.getMetadata();
        return metadata == null ? "" : metadata.catalogName;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, column);
        }
        int rc = this.getSQLType(column);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public int getFormat(int column) throws SQLException {
        return this.getField(column).getFormat();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, column);
        }
        String type = this.getRSType(column);
        if (this.isAutoIncrement(column)) {
            if ("int4".equals(type)) {
                return "serial";
            }
            if ("int8".equals(type)) {
                return "bigserial";
            }
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, type);
        }
        return type;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        Field field = this.getField(column);
        FieldMetadata metadata = field.getMetadata();
        return metadata == null ? false : metadata.readOnly;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    protected Field getField(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new RedshiftException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", columnIndex, this.fields.length), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        return this.fields[columnIndex - 1];
    }

    protected String getRSType(int columnIndex) throws SQLException {
        return this.connection.getTypeInfo().getRSType(this.getField(columnIndex).getOID());
    }

    protected int getSQLType(int columnIndex) throws SQLException {
        return this.connection.getTypeInfo().getSQLType(this.getField(columnIndex).getOID());
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        Field field = this.getField(column);
        String result = this.connection.getTypeInfo().getJavaClass(field.getOID());
        if (result != null) {
            return result;
        }
        int sqlType = this.getSQLType(column);
        switch (sqlType) {
            case 2003: {
                return "java.sql.Array";
            }
        }
        String type = this.getRSType(column);
        if ("unknown".equals(type)) {
            return "java.lang.String";
        }
        return "java.lang.Object";
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }
}

