/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

public class SortedMapCoder<K extends Comparable<? super K>, V>
extends StructuredCoder<SortedMap<K, V>> {
    private Coder<K> keyCoder;
    private Coder<V> valueCoder;

    public static <K extends Comparable<? super K>, V> SortedMapCoder<K, V> of(Coder<K> keyCoder, Coder<V> valueCoder) {
        return new SortedMapCoder<K, V>(keyCoder, valueCoder);
    }

    public Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    public Coder<V> getValueCoder() {
        return this.valueCoder;
    }

    private SortedMapCoder(Coder<K> keyCoder, Coder<V> valueCoder) {
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
    }

    @Override
    public void encode(SortedMap<K, V> map, OutputStream outStream) throws IOException, CoderException {
        this.encode(map, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(SortedMap<K, V> map, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (map == null) {
            throw new CoderException("cannot encode a null SortedMap");
        }
        DataOutputStream dataOutStream = new DataOutputStream(outStream);
        int size = map.size();
        dataOutStream.writeInt(size);
        if (size == 0) {
            return;
        }
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        Map.Entry<K, V> entry = iterator.next();
        while (iterator.hasNext()) {
            this.keyCoder.encode((Comparable)entry.getKey(), outStream);
            this.valueCoder.encode(entry.getValue(), outStream);
            entry = iterator.next();
        }
        this.keyCoder.encode((Comparable)entry.getKey(), outStream);
        this.valueCoder.encode(entry.getValue(), outStream, context);
    }

    @Override
    public SortedMap<K, V> decode(InputStream inStream) throws IOException, CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public SortedMap<K, V> decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        DataInputStream dataInStream = new DataInputStream(inStream);
        int size = dataInStream.readInt();
        if (size == 0) {
            return Collections.emptySortedMap();
        }
        TreeMap retval = Maps.newTreeMap();
        for (int i = 0; i < size - 1; ++i) {
            Comparable key = (Comparable)this.keyCoder.decode(inStream);
            V value = this.valueCoder.decode(inStream);
            retval.put(key, value);
        }
        Comparable key = (Comparable)this.keyCoder.decode(inStream);
        V value = this.valueCoder.decode(inStream, context);
        retval.put(key, value);
        return retval;
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return Arrays.asList(this.keyCoder, this.valueCoder);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Ordering of entries in a Map may be non-deterministic.");
    }

    @Override
    public boolean consistentWithEquals() {
        return this.keyCoder.consistentWithEquals() && this.valueCoder.consistentWithEquals();
    }

    @Override
    public Object structuralValue(SortedMap<K, V> value) {
        if (this.consistentWithEquals()) {
            return value;
        }
        HashMap ret = Maps.newHashMapWithExpectedSize((int)value.size());
        for (Map.Entry<K, V> entry : value.entrySet()) {
            ret.put(this.keyCoder.structuralValue((Comparable)entry.getKey()), this.valueCoder.structuralValue(entry.getValue()));
        }
        return ret;
    }

    @Override
    public void registerByteSizeObserver(SortedMap<K, V> map, ElementByteSizeObserver observer) throws Exception {
        observer.update(4L);
        if (map.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<K, V>> entries = map.entrySet().iterator();
        Map.Entry<K, V> entry = entries.next();
        while (entries.hasNext()) {
            this.keyCoder.registerByteSizeObserver((Comparable)entry.getKey(), observer);
            this.valueCoder.registerByteSizeObserver(entry.getValue(), observer);
            entry = entries.next();
        }
        this.keyCoder.registerByteSizeObserver((Comparable)entry.getKey(), observer);
        this.valueCoder.registerByteSizeObserver(entry.getValue(), observer);
    }

    @Override
    public TypeDescriptor<SortedMap<K, V>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<SortedMap<K, V>>(){}.where(new TypeParameter<K>(){}, this.keyCoder.getEncodedTypeDescriptor()).where(new TypeParameter<V>(){}, this.valueCoder.getEncodedTypeDescriptor());
    }
}

