/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@VisibleForTesting
class TextSource
extends FileBasedSource<String> {
    byte[] delimiter;

    TextSource(ValueProvider<String> fileSpec, EmptyMatchTreatment emptyMatchTreatment, byte[] delimiter) {
        super(fileSpec, emptyMatchTreatment, 1L);
        this.delimiter = delimiter;
    }

    private TextSource(MatchResult.Metadata metadata, long start, long end, byte[] delimiter) {
        super(metadata, 1L, start, end);
        this.delimiter = delimiter;
    }

    @Override
    protected FileBasedSource<String> createForSubrangeOfFile(MatchResult.Metadata metadata, long start, long end) {
        return new TextSource(metadata, start, end, this.delimiter);
    }

    @Override
    protected FileBasedSource.FileBasedReader<String> createSingleFileReader(PipelineOptions options) {
        return new TextBasedReader(this, this.delimiter);
    }

    @Override
    public Coder<String> getOutputCoder() {
        return StringUtf8Coder.of();
    }

    @VisibleForTesting
    static class TextBasedReader
    extends FileBasedSource.FileBasedReader<String> {
        private static final int READ_BUFFER_SIZE = 8192;
        private static final ByteString UTF8_BOM = ByteString.copyFrom((byte[])new byte[]{-17, -69, -65});
        private static final byte CR = 13;
        private static final byte LF = 10;
        private final byte @Nullable [] delimiter;
        private final ByteArrayOutputStream str;
        private final byte[] buffer = new byte[8192];
        private final ByteBuffer byteBuffer;
        private ReadableByteChannel inChannel;
        private long startOfRecord;
        private volatile long startOfNextRecord;
        private volatile boolean eof;
        private volatile @Nullable String currentValue;
        private int bufferLength = 0;
        private int bufferPosn = 0;
        private boolean skipLineFeedAtStart;

        private TextBasedReader(TextSource source, byte[] delimiter) {
            super(source);
            this.str = new ByteArrayOutputStream();
            this.byteBuffer = ByteBuffer.wrap(this.buffer);
            this.delimiter = delimiter;
        }

        @Override
        protected long getCurrentOffset() throws NoSuchElementException {
            if (this.currentValue == null) {
                throw new NoSuchElementException();
            }
            return this.startOfRecord;
        }

        @Override
        public long getSplitPointsRemaining() {
            if (this.isStarted() && this.startOfNextRecord >= this.getCurrentSource().getEndOffset()) {
                return this.isDone() ? 0L : 1L;
            }
            return super.getSplitPointsRemaining();
        }

        @Override
        public String getCurrent() throws NoSuchElementException {
            if (this.currentValue == null) {
                throw new NoSuchElementException();
            }
            return this.currentValue;
        }

        @Override
        protected void startReading(ReadableByteChannel channel) throws IOException {
            this.inChannel = channel;
            long startOffset = this.getCurrentSource().getStartOffset();
            if (startOffset > 0L) {
                Preconditions.checkState((boolean)(channel instanceof SeekableByteChannel), (String)"%s only supports reading from a SeekableByteChannel when given a start offset greater than 0.", (Object)TextSource.class.getSimpleName());
                long requiredPosition = startOffset - 1L;
                if (this.delimiter != null && startOffset >= (long)this.delimiter.length) {
                    requiredPosition = startOffset - (long)this.delimiter.length;
                }
                if (requiredPosition < (long)UTF8_BOM.size()) {
                    ((SeekableByteChannel)channel).position(0L);
                    if (this.fileStartsWithBom()) {
                        this.bufferPosn = UTF8_BOM.size();
                        this.startOfNextRecord = this.bufferPosn;
                    } else {
                        this.bufferPosn = (int)requiredPosition;
                        this.startOfNextRecord = this.bufferPosn;
                    }
                } else {
                    ((SeekableByteChannel)channel).position(requiredPosition);
                    this.startOfNextRecord = requiredPosition;
                }
                this.readNextRecord();
                this.currentValue = null;
            } else if (this.fileStartsWithBom()) {
                this.bufferPosn = UTF8_BOM.size();
                this.startOfNextRecord = this.bufferPosn;
            }
        }

        private boolean fileStartsWithBom() throws IOException {
            int i;
            do {
                int bytesRead;
                if ((bytesRead = this.inChannel.read(this.byteBuffer)) == -1) {
                    return false;
                }
                this.bufferLength += bytesRead;
            } while (this.bufferLength < UTF8_BOM.size());
            for (i = 0; i < UTF8_BOM.size() && this.buffer[i] == UTF8_BOM.byteAt(i); ++i) {
            }
            return i == UTF8_BOM.size();
        }

        @Override
        protected boolean readNextRecord() throws IOException {
            this.startOfRecord = this.startOfNextRecord;
            if (this.eof) {
                this.currentValue = null;
                return false;
            }
            if (this.delimiter == null) {
                return this.readDefaultLine();
            }
            return this.readCustomLine();
        }

        private boolean readDefaultLine() throws IOException {
            long bytesConsumed;
            block12: {
                int appendLength;
                int startPosn;
                assert (!this.eof);
                int newlineLength = 0;
                boolean prevCharCR = false;
                bytesConsumed = 0L;
                while (true) {
                    startPosn = this.bufferPosn;
                    while (this.bufferPosn == this.bufferLength) {
                        this.bufferPosn = 0;
                        startPosn = 0;
                        this.byteBuffer.clear();
                        this.bufferLength = this.inChannel.read(this.byteBuffer);
                        if (this.bufferLength >= 0) continue;
                        this.eof = true;
                        if (this.str.size() == 0) {
                            return false;
                        }
                        this.currentValue = this.str.toString(StandardCharsets.UTF_8.name());
                        break block12;
                    }
                    if (this.skipLineFeedAtStart && this.buffer[this.bufferPosn] == 10) {
                        ++bytesConsumed;
                        ++startPosn;
                        ++this.bufferPosn;
                        this.skipLineFeedAtStart = false;
                    }
                    while (this.bufferPosn < this.bufferLength) {
                        if (this.buffer[this.bufferPosn] == 10) {
                            newlineLength = prevCharCR ? 2 : 1;
                            ++this.bufferPosn;
                            break;
                        }
                        if (prevCharCR) {
                            newlineLength = 1;
                            break;
                        }
                        prevCharCR = this.buffer[this.bufferPosn] == 13;
                        ++this.bufferPosn;
                    }
                    if (newlineLength == 0 && prevCharCR) {
                        this.skipLineFeedAtStart = true;
                        newlineLength = 1;
                    } else {
                        this.skipLineFeedAtStart = false;
                    }
                    int readLength = this.bufferPosn - startPosn;
                    bytesConsumed += (long)readLength;
                    appendLength = readLength - newlineLength;
                    if (newlineLength != 0) break;
                    this.str.write(this.buffer, startPosn, appendLength);
                }
                if (this.str.size() == 0) {
                    this.currentValue = new String(this.buffer, startPosn, appendLength, StandardCharsets.UTF_8);
                } else {
                    this.str.write(this.buffer, startPosn, appendLength);
                    this.currentValue = this.str.toString(StandardCharsets.UTF_8.name());
                }
            }
            this.startOfNextRecord = this.startOfRecord + bytesConsumed;
            this.str.reset();
            return true;
        }

        private boolean readCustomLine() throws IOException {
            long bytesConsumed;
            block16: {
                int appendLength;
                int startPosn;
                assert (!this.eof);
                bytesConsumed = 0L;
                int delPosn = 0;
                while (true) {
                    int prevDelPosn;
                    block17: {
                        startPosn = this.bufferPosn;
                        while (this.bufferPosn >= this.bufferLength) {
                            this.bufferPosn = 0;
                            startPosn = 0;
                            this.byteBuffer.clear();
                            this.bufferLength = this.inChannel.read(this.byteBuffer);
                            if (this.bufferLength >= 0) continue;
                            this.eof = true;
                            if (delPosn != 0) {
                                this.str.write(this.delimiter, 0, delPosn);
                            }
                            if (this.str.size() == 0) {
                                return false;
                            }
                            this.currentValue = this.str.toString(StandardCharsets.UTF_8.name());
                            break block16;
                        }
                        prevDelPosn = delPosn;
                        if (delPosn > 0) {
                            while (this.bufferPosn < this.bufferLength) {
                                if (this.buffer[this.bufferPosn] == this.delimiter[delPosn]) {
                                    if (++delPosn == this.delimiter.length) {
                                        ++this.bufferPosn;
                                        break block17;
                                    }
                                } else {
                                    this.str.write(this.delimiter, 0, prevDelPosn);
                                    delPosn = 0;
                                    break;
                                }
                                ++this.bufferPosn;
                            }
                        }
                        while (this.bufferPosn < this.bufferLength) {
                            if (this.buffer[this.bufferPosn] == this.delimiter[delPosn]) {
                                if (++delPosn == this.delimiter.length) {
                                    ++this.bufferPosn;
                                    break;
                                }
                            } else {
                                delPosn = 0;
                            }
                            ++this.bufferPosn;
                        }
                    }
                    int readLength = this.bufferPosn - startPosn;
                    bytesConsumed += (long)readLength;
                    appendLength = readLength - (delPosn - prevDelPosn);
                    if (delPosn >= this.delimiter.length) break;
                    this.str.write(this.buffer, startPosn, appendLength);
                }
                if (this.str.size() == 0) {
                    this.currentValue = new String(this.buffer, startPosn, appendLength, StandardCharsets.UTF_8);
                } else {
                    this.str.write(this.buffer, startPosn, appendLength);
                    this.currentValue = this.str.toString(StandardCharsets.UTF_8.name());
                }
            }
            this.startOfNextRecord = this.startOfRecord + bytesConsumed;
            this.str.reset();
            return true;
        }
    }
}

