/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.io.payloads;

import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.Providers;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializerProvider;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
public final class PayloadSerializers {
    private static final Map<String, PayloadSerializerProvider> PROVIDERS = Providers.loadProviders(PayloadSerializerProvider.class);

    private PayloadSerializers() {
    }

    public static PayloadSerializer getSerializer(String id, Schema schema, Map<String, Object> tableParams) {
        PayloadSerializerProvider provider = PROVIDERS.get(id);
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"Invalid config, no serializer provider exists with identifier `%s`.", (Object)id);
        return provider.getSerializer(schema, tableParams);
    }
}

