/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.testing.Annotations;
import org.apache.beam.sdk.testing.CrashingRunner;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestPipeline
extends Pipeline
implements TestRule {
    private final PipelineOptions options;
    public static final String PROPERTY_BEAM_TEST_PIPELINE_OPTIONS = "beamTestPipelineOptions";
    static final String PROPERTY_USE_DEFAULT_DUMMY_RUNNER = "beamUseDummyRunner";
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    private Optional<? extends PipelineRunEnforcement> enforcement = Optional.absent();
    private final Map<String, Object> providerRuntimeValues = Maps.newHashMap();

    public static TestPipeline create() {
        return TestPipeline.fromOptions(TestPipeline.testingPipelineOptions());
    }

    public static TestPipeline fromOptions(PipelineOptions options) {
        return new TestPipeline(options);
    }

    private TestPipeline(PipelineOptions options) {
        super(options);
        this.options = options;
    }

    @Override
    public PipelineOptions getOptions() {
        return this.options;
    }

    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            private void setDeducedEnforcementLevel() {
                if (!TestPipeline.this.enforcement.isPresent()) {
                    boolean annotatedWithNeedsRunner = FluentIterable.from((Iterable)description.getAnnotations()).filter(Annotations.Predicates.isAnnotationOfType(Category.class)).anyMatch(Annotations.Predicates.isCategoryOf(NeedsRunner.class, true));
                    boolean crashingRunner = CrashingRunner.class.isAssignableFrom(TestPipeline.this.options.getRunner());
                    Preconditions.checkState((!annotatedWithNeedsRunner || !crashingRunner ? 1 : 0) != 0, (String)"The test was annotated with a [@%s] / [@%s] while the runner was set to [%s]. Please re-check your configuration.", (Object)NeedsRunner.class.getSimpleName(), (Object)ValidatesRunner.class.getSimpleName(), (Object)CrashingRunner.class.getSimpleName());
                    TestPipeline.this.enableAbandonedNodeEnforcement(annotatedWithNeedsRunner || !crashingRunner);
                }
            }

            public void evaluate() throws Throwable {
                TestPipeline.this.options.as(ApplicationNameOptions.class).setAppName(TestPipeline.this.getAppName(description));
                this.setDeducedEnforcementLevel();
                statement.evaluate();
                ((PipelineRunEnforcement)TestPipeline.this.enforcement.get()).afterUserCodeFinished();
            }
        };
    }

    @Override
    public PipelineResult run() {
        return this.run(this.getOptions());
    }

    public PipelineResult runWithAdditionalOptionArgs(List<String> additionalArgs) {
        try {
            String useDefaultDummy;
            PipelineOptions options;
            @Nullable String beamTestPipelineOptions = System.getProperty(PROPERTY_BEAM_TEST_PIPELINE_OPTIONS);
            if (Strings.isNullOrEmpty((String)beamTestPipelineOptions)) {
                options = PipelineOptionsFactory.create();
            } else {
                List args = (List)MAPPER.readValue(beamTestPipelineOptions, List.class);
                args.addAll(additionalArgs);
                String[] newArgs = new String[args.size()];
                newArgs = args.toArray(newArgs);
                options = PipelineOptionsFactory.fromArgs(newArgs).as(TestPipelineOptions.class);
            }
            if (Strings.isNullOrEmpty((String)beamTestPipelineOptions) && !Strings.isNullOrEmpty((String)(useDefaultDummy = System.getProperty(PROPERTY_USE_DEFAULT_DUMMY_RUNNER))) && Boolean.valueOf(useDefaultDummy).booleanValue()) {
                options.setRunner(CrashingRunner.class);
            }
            options.setStableUniqueNames(PipelineOptions.CheckEnabled.ERROR);
            FileSystems.setDefaultPipelineOptions(options);
            return this.run(options);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to instantiate test options from system property beamTestPipelineOptions:" + System.getProperty(PROPERTY_BEAM_TEST_PIPELINE_OPTIONS), e);
        }
    }

    @Override
    public PipelineResult run(PipelineOptions options) {
        PipelineResult pipelineResult;
        Preconditions.checkState((boolean)this.enforcement.isPresent(), (Object)"Is your TestPipeline declaration missing a @Rule annotation? Usage: @Rule public final transient TestPipeline pipeline = TestPipeline.create();");
        try {
            ((PipelineRunEnforcement)this.enforcement.get()).beforePipelineExecution();
            PipelineOptions updatedOptions = (PipelineOptions)MAPPER.convertValue((Object)MAPPER.valueToTree((Object)options), PipelineOptions.class);
            updatedOptions.as(TestValueProviderOptions.class).setProviderRuntimeValues(ValueProvider.StaticValueProvider.of(this.providerRuntimeValues));
            pipelineResult = super.run(updatedOptions);
            TestPipeline.verifyPAssertsSucceeded(this, pipelineResult);
        }
        catch (RuntimeException exc) {
            Throwable cause = exc.getCause();
            if (cause instanceof AssertionError) {
                throw (AssertionError)((Object)cause);
            }
            throw exc;
        }
        ((PipelineRunEnforcement)this.enforcement.get()).afterPipelineExecution();
        return pipelineResult;
    }

    public <T> ValueProvider<T> newProvider(T runtimeValue) {
        String uuid = UUID.randomUUID().toString();
        this.providerRuntimeValues.put(uuid, runtimeValue);
        return ValueProvider.NestedValueProvider.of(this.options.as(TestValueProviderOptions.class).getProviderRuntimeValues(), new GetFromRuntimeValues(uuid));
    }

    public TestPipeline enableAbandonedNodeEnforcement(boolean enable) {
        this.enforcement = enable ? Optional.of((Object)new PipelineAbandonedNodeEnforcement(this)) : Optional.of((Object)new PipelineRunEnforcement(this));
        return this;
    }

    public TestPipeline enableAutoRunIfMissing(boolean enable) {
        ((PipelineRunEnforcement)this.enforcement.get()).enableAutoRunIfMissing(enable);
        return this;
    }

    @Override
    public String toString() {
        return "TestPipeline#" + this.options.as(ApplicationNameOptions.class).getAppName();
    }

    public static PipelineOptions testingPipelineOptions() {
        try {
            String useDefaultDummy;
            PipelineOptions options;
            @Nullable String beamTestPipelineOptions = System.getProperty(PROPERTY_BEAM_TEST_PIPELINE_OPTIONS);
            PipelineOptions pipelineOptions = options = Strings.isNullOrEmpty((String)beamTestPipelineOptions) ? PipelineOptionsFactory.create() : PipelineOptionsFactory.fromArgs((String[])MAPPER.readValue(beamTestPipelineOptions, String[].class)).as(TestPipelineOptions.class);
            if (Strings.isNullOrEmpty((String)beamTestPipelineOptions) && !Strings.isNullOrEmpty((String)(useDefaultDummy = System.getProperty(PROPERTY_USE_DEFAULT_DUMMY_RUNNER))) && Boolean.valueOf(useDefaultDummy).booleanValue()) {
                options.setRunner(CrashingRunner.class);
            }
            options.setStableUniqueNames(PipelineOptions.CheckEnabled.ERROR);
            FileSystems.setDefaultPipelineOptions(options);
            return options;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to instantiate test options from system property beamTestPipelineOptions:" + System.getProperty(PROPERTY_BEAM_TEST_PIPELINE_OPTIONS), e);
        }
    }

    private String getAppName(Description description) {
        String methodName = description.getMethodName();
        Class testClass = description.getTestClass();
        if (testClass.isMemberClass()) {
            return String.format("%s$%s-%s", testClass.getEnclosingClass().getSimpleName(), testClass.getSimpleName(), methodName);
        }
        return String.format("%s-%s", testClass.getSimpleName(), methodName);
    }

    public static void verifyPAssertsSucceeded(Pipeline pipeline, PipelineResult pipelineResult) {
        if (MetricsEnvironment.isMetricsSupported()) {
            long expectedNumberOfAssertions = PAssert.countAsserts(pipeline);
            long successfulAssertions = 0L;
            Iterable<MetricResult<Long>> successCounterResults = pipelineResult.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.named(PAssert.class, "PAssertSuccess")).build()).getCounters();
            for (MetricResult<Long> counter : successCounterResults) {
                if (counter.getAttempted() <= 0L) continue;
                ++successfulAssertions;
            }
            MatcherAssert.assertThat((String)String.format("Expected %d successful assertions, but found %d.", expectedNumberOfAssertions, successfulAssertions), (Object)successfulAssertions, (Matcher)Matchers.is((Object)expectedNumberOfAssertions));
        }
    }

    private static class IsEmptyVisitor
    extends Pipeline.PipelineVisitor.Defaults {
        private boolean empty = true;

        private IsEmptyVisitor() {
        }

        public boolean isEmpty() {
            return this.empty;
        }

        @Override
        public void visitPrimitiveTransform(TransformHierarchy.Node node) {
            this.empty = false;
        }
    }

    private static class GetFromRuntimeValues<T>
    implements SerializableFunction<Map<String, Object>, T> {
        private final String key;

        private GetFromRuntimeValues(String key) {
            this.key = key;
        }

        @Override
        public T apply(Map<String, Object> input) {
            return (T)input.get(this.key);
        }
    }

    @Internal
    public static interface TestValueProviderOptions
    extends PipelineOptions {
        public ValueProvider<Map<String, Object>> getProviderRuntimeValues();

        public void setProviderRuntimeValues(ValueProvider<Map<String, Object>> var1);
    }

    public static class PipelineRunMissingException
    extends RuntimeException {
        PipelineRunMissingException(String msg) {
            super(msg);
        }
    }

    public static class AbandonedNodeException
    extends RuntimeException {
        AbandonedNodeException(String msg) {
            super(msg);
        }
    }

    private static class PipelineAbandonedNodeEnforcement
    extends PipelineRunEnforcement {
        private @Nullable List<TransformHierarchy.Node> runVisitedNodes = null;
        private final Predicate<TransformHierarchy.Node> isPAssertNode = node -> node.getTransform() instanceof PAssert.GroupThenAssert || node.getTransform() instanceof PAssert.GroupThenAssertForSingleton || node.getTransform() instanceof PAssert.OneSideInputAssert;

        private PipelineAbandonedNodeEnforcement(TestPipeline pipeline) {
            super(pipeline);
        }

        private List<TransformHierarchy.Node> recordPipelineNodes(Pipeline pipeline) {
            NodeRecorder nodeRecorder = new NodeRecorder();
            pipeline.traverseTopologically(nodeRecorder);
            return nodeRecorder.visited;
        }

        private boolean isEmptyPipeline(Pipeline pipeline) {
            IsEmptyVisitor isEmptyVisitor = new IsEmptyVisitor();
            pipeline.traverseTopologically(isEmptyVisitor);
            return isEmptyVisitor.isEmpty();
        }

        private void verifyPipelineExecution() {
            if (!this.isEmptyPipeline(this.pipeline)) {
                if (!this.runAttempted && !this.enableAutoRunIfMissing) {
                    throw new PipelineRunMissingException("The pipeline has not been run.");
                }
                List<TransformHierarchy.Node> pipelineNodes = this.recordPipelineNodes(this.pipeline);
                if (this.pipelineRunSucceeded() && !this.visitedAll(pipelineNodes)) {
                    boolean hasDanglingPAssert = FluentIterable.from(pipelineNodes).filter(Predicates.not((Predicate)Predicates.in(this.runVisitedNodes))).anyMatch(this.isPAssertNode);
                    if (hasDanglingPAssert) {
                        throw new AbandonedNodeException("The pipeline contains abandoned PAssert(s).");
                    }
                    throw new AbandonedNodeException("The pipeline contains abandoned PTransform(s).");
                }
            }
        }

        private boolean visitedAll(List<TransformHierarchy.Node> pipelineNodes) {
            return this.runVisitedNodes.equals(pipelineNodes);
        }

        private boolean pipelineRunSucceeded() {
            return this.runVisitedNodes != null;
        }

        @Override
        protected void afterPipelineExecution() {
            this.runVisitedNodes = this.recordPipelineNodes(this.pipeline);
            super.afterPipelineExecution();
        }

        @Override
        protected void afterUserCodeFinished() {
            super.afterUserCodeFinished();
            this.verifyPipelineExecution();
        }

        private static class NodeRecorder
        extends Pipeline.PipelineVisitor.Defaults {
            private final List<TransformHierarchy.Node> visited = new ArrayList<TransformHierarchy.Node>();

            private NodeRecorder() {
            }

            @Override
            public void leaveCompositeTransform(TransformHierarchy.Node node) {
                this.visited.add(node);
            }

            @Override
            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                this.visited.add(node);
            }
        }
    }

    private static class PipelineRunEnforcement {
        protected boolean enableAutoRunIfMissing;
        protected final Pipeline pipeline;
        protected boolean runAttempted;

        private PipelineRunEnforcement(Pipeline pipeline) {
            this.pipeline = pipeline;
        }

        protected void enableAutoRunIfMissing(boolean enable) {
            this.enableAutoRunIfMissing = enable;
        }

        protected void beforePipelineExecution() {
            this.runAttempted = true;
        }

        protected void afterPipelineExecution() {
        }

        protected void afterUserCodeFinished() {
            if (!this.runAttempted && this.enableAutoRunIfMissing) {
                this.pipeline.run().waitUntilFinish();
            }
        }
    }
}

