/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class Distinct<T>
extends PTransform<PCollection<T>, PCollection<T>> {
    public static <T> Distinct<T> create() {
        return new Distinct<T>();
    }

    public static <T, IdT> WithRepresentativeValues<T, IdT> withRepresentativeValueFn(SerializableFunction<T, IdT> fn) {
        return new WithRepresentativeValues(fn, null);
    }

    private static <T, W extends BoundedWindow> void validateWindowStrategy(WindowingStrategy<T, W> strategy) {
        if (strategy.needsMerge() && (!strategy.getTrigger().getClass().equals(DefaultTrigger.class) || strategy.getAllowedLateness().isLongerThan((ReadableDuration)Duration.ZERO))) {
            throw new UnsupportedOperationException(String.format("%s does not support merging windowing strategies, except when using the default trigger and zero allowed lateness.", Distinct.class.getSimpleName()));
        }
    }

    @Override
    public PCollection<T> expand(PCollection<T> in) {
        Distinct.validateWindowStrategy(in.getWindowingStrategy());
        PCollection combined = (PCollection)((PCollection)in.apply("KeyByElement", MapElements.via(new SimpleFunction<T, KV<T, Void>>(){

            @Override
            public KV<T, Void> apply(T element) {
                return KV.of(element, null);
            }
        }))).apply("DropValues", Combine.perKey(new SerializableFunction<Iterable<Void>, Void>(){

            @Override
            public @Nullable Void apply(Iterable<Void> iter) {
                return null;
            }
        }));
        return (PCollection)combined.apply("ExtractFirstKey", ParDo.of(new DoFn<KV<T, Void>, T>(){

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element KV<T, Void> element, PaneInfo pane, DoFn.OutputReceiver<T> receiver) {
                if (pane.isFirst()) {
                    receiver.output(element.getKey());
                }
            }
        }));
    }

    public static class WithRepresentativeValues<T, IdT>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final SerializableFunction<T, IdT> fn;
        private final TypeDescriptor<IdT> representativeType;

        private WithRepresentativeValues(SerializableFunction<T, IdT> fn, TypeDescriptor<IdT> representativeType) {
            this.fn = fn;
            this.representativeType = representativeType;
        }

        @Override
        public PCollection<T> expand(PCollection<T> in) {
            Distinct.validateWindowStrategy(in.getWindowingStrategy());
            WithKeys withKeys = WithKeys.of(this.fn);
            if (this.representativeType != null) {
                withKeys = withKeys.withKeyType(this.representativeType);
            }
            PCollection keyed = (PCollection)in.apply("KeyByRepresentativeValue", withKeys);
            KvCoder keyedCoder = (KvCoder)keyed.getCoder();
            PCollection combined = ((PCollection)keyed.apply("OneValuePerKey", Combine.perKey(new Combine.BinaryCombineFn<T>(){

                @Override
                public T apply(T left, T right) {
                    return left;
                }
            }))).setCoder(KvCoder.of(keyedCoder.getKeyCoder(), NullableCoder.of(keyedCoder.getValueCoder())));
            return (PCollection)combined.apply("KeepFirstPane", ParDo.of(new DoFn<KV<IdT, T>, T>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element KV<IdT, T> element, PaneInfo pane, DoFn.OutputReceiver<T> receiver) {
                    if (pane.isFirst()) {
                        receiver.output(element.getValue());
                    }
                }
            }));
        }

        public WithRepresentativeValues<T, IdT> withRepresentativeType(TypeDescriptor<IdT> type) {
            return new WithRepresentativeValues<T, IdT>(this.fn, type);
        }
    }
}

