/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;

@Internal
public class DoFnInfo<InputT, OutputT>
implements Serializable {
    private final DoFn<InputT, OutputT> doFn;
    private final WindowingStrategy<?, ?> windowingStrategy;
    private final Iterable<PCollectionView<?>> sideInputViews;
    private final Coder<InputT> inputCoder;
    Map<TupleTag<?>, Coder<?>> outputCoders;
    private final TupleTag<OutputT> mainOutput;
    private final DoFnSchemaInformation doFnSchemaInformation;
    private final Map<String, PCollectionView<?>> sideInputMapping;

    public static <InputT, OutputT> DoFnInfo<InputT, OutputT> forFn(DoFn<InputT, OutputT> doFn, WindowingStrategy<?, ?> windowingStrategy, Iterable<PCollectionView<?>> sideInputViews, Coder<InputT> inputCoder, TupleTag<OutputT> mainOutput, DoFnSchemaInformation doFnSchemaInformation, Map<String, PCollectionView<?>> sideInputMapping) {
        return new DoFnInfo<InputT, OutputT>(doFn, windowingStrategy, sideInputViews, inputCoder, Collections.emptyMap(), mainOutput, doFnSchemaInformation, sideInputMapping);
    }

    public static <InputT, OutputT> DoFnInfo<InputT, OutputT> forFn(DoFn<InputT, OutputT> doFn, WindowingStrategy<?, ?> windowingStrategy, Iterable<PCollectionView<?>> sideInputViews, Coder<InputT> inputCoder, Map<TupleTag<?>, Coder<?>> outputCoders, TupleTag<OutputT> mainOutput, DoFnSchemaInformation doFnSchemaInformation, Map<String, PCollectionView<?>> sideInputMapping) {
        return new DoFnInfo<InputT, OutputT>(doFn, windowingStrategy, sideInputViews, inputCoder, outputCoders, mainOutput, doFnSchemaInformation, sideInputMapping);
    }

    public DoFnInfo<InputT, OutputT> withFn(DoFn<InputT, OutputT> newFn) {
        return DoFnInfo.forFn(newFn, this.windowingStrategy, this.sideInputViews, this.inputCoder, this.outputCoders, this.mainOutput, this.doFnSchemaInformation, this.sideInputMapping);
    }

    private DoFnInfo(DoFn<InputT, OutputT> doFn, WindowingStrategy<?, ?> windowingStrategy, Iterable<PCollectionView<?>> sideInputViews, Coder<InputT> inputCoder, Map<TupleTag<?>, Coder<?>> outputCoders, TupleTag<OutputT> mainOutput, DoFnSchemaInformation doFnSchemaInformation, Map<String, PCollectionView<?>> sideInputMapping) {
        this.doFn = doFn;
        this.windowingStrategy = windowingStrategy;
        this.sideInputViews = sideInputViews;
        this.inputCoder = inputCoder;
        this.outputCoders = outputCoders;
        this.mainOutput = mainOutput;
        this.doFnSchemaInformation = doFnSchemaInformation;
        this.sideInputMapping = sideInputMapping;
    }

    public DoFn<InputT, OutputT> getDoFn() {
        return this.doFn;
    }

    public WindowingStrategy<?, ?> getWindowingStrategy() {
        return this.windowingStrategy;
    }

    public Iterable<PCollectionView<?>> getSideInputViews() {
        return this.sideInputViews;
    }

    public Coder<InputT> getInputCoder() {
        return this.inputCoder;
    }

    public Map<TupleTag<?>, Coder<?>> getOutputCoders() {
        return this.outputCoders;
    }

    public TupleTag<OutputT> getMainOutput() {
        return this.mainOutput;
    }

    public DoFnSchemaInformation getDoFnSchemaInformation() {
        return this.doFnSchemaInformation;
    }

    public Map<String, PCollectionView<?>> getSideInputMapping() {
        return this.sideInputMapping;
    }
}

