/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.beam.sdk.annotations.Internal;

@Internal
public class ExposedByteArrayInputStream
extends ByteArrayInputStream {
    public ExposedByteArrayInputStream(byte[] buf) {
        super(buf);
    }

    public byte[] readAll() throws IOException {
        if (this.pos == 0 && this.count == this.buf.length) {
            this.pos = this.count;
            return this.buf;
        }
        byte[] ret = new byte[this.count - this.pos];
        super.read(ret);
        return ret;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException exn) {
            throw new RuntimeException("Unexpected IOException closing ByteArrayInputStream", exn);
        }
    }
}

