/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.sdk.util.NanoClock;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.math.LongMath;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Longs;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class UnboundedScheduledExecutorService
implements ScheduledExecutorService {
    private final AtomicLong sequencer = new AtomicLong();
    private final NanoClock clock;
    private final ThreadPoolExecutor threadPoolExecutor;
    @VisibleForTesting
    final PriorityQueue<ScheduledFutureTask<?>> tasks;
    private final AbstractExecutorService invokeMethodsAdapter;
    private final Future<?> launchTasks;

    public UnboundedScheduledExecutorService() {
        this(NanoClock.SYSTEM);
    }

    @VisibleForTesting
    UnboundedScheduledExecutorService(NanoClock clock) {
        this.clock = clock;
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        threadFactoryBuilder.setThreadFactory(MoreExecutors.platformThreadFactory());
        threadFactoryBuilder.setDaemon(true);
        this.threadPoolExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new SynchronousQueue<Runnable>(), threadFactoryBuilder.build());
        this.invokeMethodsAdapter = new AbstractExecutorService(){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
                return new ScheduledFutureTask<T>(runnable, value, 0L);
            }

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
                return new ScheduledFutureTask<T>(callable, 0L);
            }

            @Override
            public void shutdown() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<Runnable> shutdownNow() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isShutdown() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isTerminated() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void execute(Runnable command) {
                UnboundedScheduledExecutorService.this.threadPoolExecutor.execute(command);
            }
        };
        this.tasks = new PriorityQueue();
        this.launchTasks = this.threadPoolExecutor.submit(new TaskLauncher(this.tasks, this.threadPoolExecutor, clock));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.threadPoolExecutor.shutdown();
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.tasks;
        synchronized (priorityQueue) {
            this.tasks.notify();
        }
        try {
            this.launchTasks.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.tasks;
        synchronized (priorityQueue) {
            ArrayList<Runnable> rval = new ArrayList<Runnable>(this.tasks);
            this.tasks.clear();
            rval.addAll(this.threadPoolExecutor.shutdownNow());
            return rval;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.threadPoolExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.threadPoolExecutor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.threadPoolExecutor.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        ScheduledFutureTask<Object> task = new ScheduledFutureTask<Object>(command, null, this.triggerTime(0L));
        this.threadPoolExecutor.execute(task);
    }

    @Override
    public Future<@Nullable ?> submit(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        ScheduledFutureTask<Object> task = new ScheduledFutureTask<Object>(command, null, this.triggerTime(0L));
        this.threadPoolExecutor.execute(task);
        return task;
    }

    @Override
    public <T> Future<T> submit(Runnable command, T result) {
        if (command == null) {
            throw new NullPointerException();
        }
        ScheduledFutureTask<T> task = new ScheduledFutureTask<T>(command, result, this.triggerTime(0L));
        this.runNowOrScheduleInTheFuture(task);
        return task;
    }

    @Override
    public <T> Future<T> submit(Callable<T> command) {
        if (command == null) {
            throw new NullPointerException();
        }
        ScheduledFutureTask<T> task = new ScheduledFutureTask<T>(command, this.triggerTime(0L));
        this.threadPoolExecutor.execute(task);
        return task;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.invokeMethodsAdapter.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (tasks == null || unit == null) {
            throw new NullPointerException();
        }
        return this.invokeMethodsAdapter.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.invokeMethodsAdapter.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.invokeMethodsAdapter.invokeAny(tasks, timeout, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        ScheduledFutureTask<Object> task = new ScheduledFutureTask<Object>(command, null, this.triggerTime(delay, unit));
        this.runNowOrScheduleInTheFuture(task);
        return task;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (callable == null || unit == null) {
            throw new NullPointerException();
        }
        ScheduledFutureTask<V> task = new ScheduledFutureTask<V>(callable, this.triggerTime(delay, unit));
        this.runNowOrScheduleInTheFuture(task);
        return task;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> task = new ScheduledFutureTask<Object>(command, null, this.triggerTime(initialDelay, unit), unit.toNanos(period));
        this.runNowOrScheduleInTheFuture(task);
        return task;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> task = new ScheduledFutureTask<Object>(command, null, this.triggerTime(initialDelay, unit), -unit.toNanos(delay));
        this.runNowOrScheduleInTheFuture(task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void runNowOrScheduleInTheFuture(ScheduledFutureTask<T> task) {
        long nanosToWait = LongMath.saturatedSubtract((long)((ScheduledFutureTask)task).time, (long)this.clock.nanoTime());
        if (nanosToWait <= 0L) {
            this.threadPoolExecutor.execute(task);
            return;
        }
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.tasks;
        synchronized (priorityQueue) {
            if (this.isShutdown()) {
                this.threadPoolExecutor.getRejectedExecutionHandler().rejectedExecution(task, this.threadPoolExecutor);
            }
            this.tasks.add(task);
            this.tasks.notify();
        }
    }

    private long triggerTime(long delay, TimeUnit unit) {
        return this.triggerTime(unit.toNanos(delay < 0L ? 0L : delay));
    }

    private long triggerTime(long delay) {
        return LongMath.saturatedAdd((long)this.clock.nanoTime(), (long)delay);
    }

    private static class TaskLauncher
    implements Callable<Void> {
        private final PriorityQueue<ScheduledFutureTask<?>> tasks;
        private final ThreadPoolExecutor threadPoolExecutor;
        private final NanoClock clock;

        private TaskLauncher(PriorityQueue<ScheduledFutureTask<?>> tasks, ThreadPoolExecutor threadPoolExecutor, NanoClock clock) {
            this.tasks = tasks;
            this.threadPoolExecutor = threadPoolExecutor;
            this.clock = clock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            while (true) {
                PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.tasks;
                synchronized (priorityQueue) {
                    if (this.threadPoolExecutor.isShutdown()) {
                        return null;
                    }
                    ScheduledFutureTask task = this.tasks.peek();
                    if (task == null) {
                        this.tasks.wait();
                        continue;
                    }
                    long nanosToWait = LongMath.saturatedSubtract((long)task.time, (long)this.clock.nanoTime());
                    if (nanosToWait > 0L) {
                        long millisToWait = nanosToWait / 1000000L;
                        int nanosRemainder = (int)(nanosToWait % 1000000L);
                        this.tasks.wait(millisToWait, nanosRemainder);
                        continue;
                    }
                    task = (ScheduledFutureTask)this.tasks.remove();
                    this.threadPoolExecutor.execute(task);
                }
            }
        }
    }

    @VisibleForTesting
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="Default equals/hashCode is what we want since two scheduled tasks are only equivalent if they point to the same instance.")
    final class ScheduledFutureTask<@Nullable V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;

        ScheduledFutureTask(@Nullable Runnable r, V result, long triggerTime) {
            this(r, result, triggerTime, 0L);
        }

        ScheduledFutureTask(@Nullable Runnable r, V result, long triggerTime, long period) {
            super(r, result);
            this.time = triggerTime;
            this.period = period;
            this.sequenceNumber = UnboundedScheduledExecutorService.this.sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable<V> callable, long triggerTime) {
            super(callable);
            this.time = triggerTime;
            this.period = 0L;
            this.sequenceNumber = UnboundedScheduledExecutorService.this.sequencer.getAndIncrement();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(LongMath.saturatedSubtract((long)this.time, (long)UnboundedScheduledExecutorService.this.clock.nanoTime()), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ScheduledFutureTask) {
                ScheduledFutureTask x = (ScheduledFutureTask)other;
                int diff = Longs.compare((long)this.time, (long)x.time);
                if (diff != 0) {
                    return diff;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long diff = LongMath.saturatedSubtract((long)this.getDelay(TimeUnit.NANOSECONDS), (long)other.getDelay(TimeUnit.NANOSECONDS));
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            PriorityQueue<ScheduledFutureTask<?>> priorityQueue = UnboundedScheduledExecutorService.this.tasks;
            synchronized (priorityQueue) {
                UnboundedScheduledExecutorService.this.tasks.remove(this);
            }
            return cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean periodic = this.isPeriodic();
            if (!periodic) {
                super.run();
            } else if (super.runAndReset()) {
                this.time = this.period > 0L ? LongMath.saturatedAdd((long)this.time, (long)this.period) : UnboundedScheduledExecutorService.this.triggerTime(-this.period);
                PriorityQueue<ScheduledFutureTask<?>> priorityQueue = UnboundedScheduledExecutorService.this.tasks;
                synchronized (priorityQueue) {
                    UnboundedScheduledExecutorService.this.tasks.add(this);
                    UnboundedScheduledExecutorService.this.tasks.notify();
                }
            }
        }
    }
}

