/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.getxmldata;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.HttpClientManager;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.Dom4JUtil;
import org.apache.hop.pipeline.transforms.xml.getxmldata.GetXmlDataData;
import org.apache.hop.pipeline.transforms.xml.getxmldata.GetXmlDataField;
import org.apache.hop.pipeline.transforms.xml.getxmldata.GetXmlDataMeta;
import org.apache.hop.pipeline.transforms.xml.getxmldata.IgnoreDtdEntityResolver;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.AbstractNode;
import org.xml.sax.EntityResolver;

public class GetXmlData
extends BaseTransform<GetXmlDataMeta, GetXmlDataData> {
    private static final Class<?> PKG = GetXmlDataMeta.class;
    private Object[] prevRow = null;

    public GetXmlData(TransformMeta transformMeta, GetXmlDataMeta meta, GetXmlDataData data, int copyNr, PipelineMeta pipelineMeta, Pipeline trans) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setDocument(String stringXML, FileObject file, boolean isInXMLField, boolean readurl) throws HopException {
        this.prevRow = this.buildEmptyRow();
        try {
            SAXReader reader = Dom4JUtil.getSAXReader();
            ((GetXmlDataData)this.data).stopPruning = false;
            if (((GetXmlDataMeta)this.meta).isValidating()) {
                reader.setValidation(true);
                reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            } else {
                reader.setEntityResolver((EntityResolver)new IgnoreDtdEntityResolver());
            }
            if (((GetXmlDataMeta)this.meta).isIgnoreComments()) {
                reader.setIgnoreComments(true);
            }
            if (((GetXmlDataData)this.data).prunePath != null) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.StreamingMode.Activated", (String[])new String[0]));
                }
                if (((GetXmlDataData)this.data).PathValue.equals(((GetXmlDataData)this.data).prunePath)) {
                    ((GetXmlDataData)this.data).an = new ArrayList<Node>(1);
                    ((GetXmlDataData)this.data).an.add(null);
                }
                reader.addHandler(((GetXmlDataData)this.data).prunePath, new ElementHandler(){

                    public void onStart(ElementPath path) {
                    }

                    public void onEnd(ElementPath path) {
                        long rowLimit = ((GetXmlDataMeta)GetXmlData.this.meta).getRowLimit();
                        if (GetXmlData.this.isStopped() || rowLimit > 0L && ((GetXmlDataData)((GetXmlData)GetXmlData.this).data).rownr > rowLimit) {
                            if (GetXmlData.this.log.isBasic()) {
                                GetXmlData.this.logBasic(BaseMessages.getString(PKG, (String)"GetXMLData.Log.StreamingMode.Stopped", (String[])new String[0]));
                            }
                            ((GetXmlDataData)((GetXmlData)GetXmlData.this).data).stopPruning = true;
                            path.getCurrent().getDocument().detach();
                            return;
                        }
                        if (GetXmlData.this.log.isDebug()) {
                            GetXmlData.this.logDebug(BaseMessages.getString(PKG, (String)"GetXMLData.Log.StreamingMode.StartProcessing", (String[])new String[0]));
                        }
                        Element row = path.getCurrent();
                        try {
                            GetXmlData.this.processStreaming(row);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        row.detach();
                        if (GetXmlData.this.log.isDebug()) {
                            GetXmlData.this.logDebug(BaseMessages.getString(PKG, (String)"GetXMLData.Log.StreamingMode.EndProcessing", (String[])new String[0]));
                        }
                    }
                });
            }
            if (isInXMLField) {
                ((GetXmlDataData)this.data).document = reader.read((Reader)new StringReader(stringXML));
            } else if (readurl && HopVfs.startsWithScheme((String)stringXML)) {
                ((GetXmlDataData)this.data).document = reader.read(HopVfs.getInputStream((String)stringXML));
            } else if (readurl) {
                CloseableHttpClient client = HttpClientManager.getInstance().createDefaultClient();
                HttpGet method = new HttpGet(stringXML);
                method.addHeader("Accept-Encoding", "gzip");
                HttpResponse response = client.execute((HttpUriRequest)method);
                Header contentEncoding = response.getFirstHeader("Content-Encoding");
                HttpEntity responseEntity = response.getEntity();
                if (responseEntity != null) {
                    if (contentEncoding != null) {
                        String acceptEncodingValue = contentEncoding.getValue();
                        if (acceptEncodingValue.contains("gzip")) {
                            GZIPInputStream in = new GZIPInputStream(responseEntity.getContent());
                            ((GetXmlDataData)this.data).document = reader.read((InputStream)in);
                        }
                    } else {
                        ((GetXmlDataData)this.data).document = reader.read(responseEntity.getContent());
                    }
                }
            } else {
                String encoding = "UTF-8";
                if (!Utils.isEmpty((CharSequence)((GetXmlDataMeta)this.meta).getEncoding())) {
                    encoding = ((GetXmlDataMeta)this.meta).getEncoding();
                }
                InputStream is = HopVfs.getInputStream((FileObject)file);
                try {
                    ((GetXmlDataData)this.data).document = reader.read(is, encoding);
                }
                finally {
                    BaseTransform.closeQuietly((Closeable)is);
                }
            }
            if (((GetXmlDataMeta)this.meta).isNamespaceAware()) {
                this.prepareNSMap(((GetXmlDataData)this.data).document.getRootElement());
            }
        }
        catch (Exception e) {
            if (((GetXmlDataData)this.data).stopPruning) {
                return false;
            }
            throw new HopException((Throwable)e);
        }
        return true;
    }

    private void processStreaming(Element row) throws HopException {
        ((GetXmlDataData)this.data).document = row.getDocument();
        if (((GetXmlDataMeta)this.meta).isNamespaceAware()) {
            this.prepareNSMap(((GetXmlDataData)this.data).document.getRootElement());
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetXMLData.Log.StreamingMode.ApplyXPath", (String[])new String[0]));
        }
        if (((GetXmlDataData)this.data).PathValue.equals(((GetXmlDataData)this.data).prunePath)) {
            ((GetXmlDataData)this.data).an.set(0, (Node)((AbstractNode)row));
            ((GetXmlDataData)this.data).nodesize = 1;
            ((GetXmlDataData)this.data).nodenr = 0;
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"GetXMLData.Log.StreamingMode.ProcessingRows", (String[])new String[0]));
            }
            Object[] r = this.getXmlRowPutRowWithErrorhandling();
            if (!((GetXmlDataData)this.data).errorInRowButContinue) {
                this.putRowOut(r);
            }
            ((GetXmlDataData)this.data).nodesize = 0;
            ((GetXmlDataData)this.data).nodenr = 0;
            return;
        }
        if (!this.applyXPath()) {
            throw new HopException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableApplyXPath", (String[])new String[0]));
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetXMLData.Log.StreamingMode.ProcessingRows", (String[])new String[0]));
        }
        boolean cont = true;
        while (((GetXmlDataData)this.data).nodenr < ((GetXmlDataData)this.data).nodesize && cont && !this.isStopped()) {
            Object[] r = this.getXmlRowPutRowWithErrorhandling();
            if (((GetXmlDataData)this.data).errorInRowButContinue) continue;
            cont = this.putRowOut(r);
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetXMLData.Log.StreamingMode.FreeMemory", (String[])new String[0]));
        }
        ((GetXmlDataData)this.data).an.clear();
        ((GetXmlDataData)this.data).nodesize = ((GetXmlDataData)this.data).an.size();
        ((GetXmlDataData)this.data).nodenr = 0;
    }

    public void prepareNSMap(Element l) {
        List namespacesList = l.declaredNamespaces();
        for (Namespace ns : namespacesList) {
            if (ns.getPrefix().trim().length() == 0) {
                ((GetXmlDataData)this.data).NAMESPACE.put("pre" + ((GetXmlDataData)this.data).NSPath.size(), ns.getURI());
                Object path = "";
                for (Element element = l; element != null; element = element.getParent()) {
                    path = element.getNamespacePrefix() != null && element.getNamespacePrefix().length() > 0 ? "/" + element.getNamespacePrefix() + ":" + element.getName() + (String)path : "/" + element.getName() + (String)path;
                }
                ((GetXmlDataData)this.data).NSPath.add((String)path);
                continue;
            }
            ((GetXmlDataData)this.data).NAMESPACE.put(ns.getPrefix(), ns.getURI());
        }
        List elementsList = l.elements();
        for (Element e : elementsList) {
            this.prepareNSMap(e);
        }
    }

    private Object[] buildEmptyRow() {
        return RowDataUtil.allocateRowData((int)((GetXmlDataData)this.data).outputRowMeta.size());
    }

    private void handleMissingFiles() throws HopException {
        List nonExistantFiles = ((GetXmlDataData)this.data).files.getNonExistentFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetXMLData.Log.RequiredFiles", (String[])new String[]{message})});
            throw new HopException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.RequiredFilesMissing", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = ((GetXmlDataData)this.data).files.getNonAccessibleFiles();
        if (nonAccessibleFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetXMLData.Log.RequiredNotAccessibleFiles", (String[])new String[]{message})});
            throw new HopException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.RequiredNotAccessibleFilesMissing", (String[])new String[]{message}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ReadNextString() {
        try {
            ((GetXmlDataData)this.data).readrow = this.getRow();
            if (((GetXmlDataData)this.data).readrow == null) {
                if (!this.log.isDetailed()) return false;
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.FinishedProcessing", (String[])new String[0]));
                return false;
            }
            if (this.first) {
                this.first = false;
                ((GetXmlDataData)this.data).nrReadRow = this.getInputRowMeta().size();
                ((GetXmlDataData)this.data).inputRowMeta = this.getInputRowMeta();
                ((GetXmlDataData)this.data).outputRowMeta = ((GetXmlDataData)this.data).inputRowMeta.clone();
                ((GetXmlDataMeta)this.meta).getFields(((GetXmlDataData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((GetXmlDataData)this.data).totalpreviousfields = ((GetXmlDataData)this.data).inputRowMeta.size();
                ((GetXmlDataData)this.data).convertRowMeta = new RowMeta();
                for (IValueMeta valueMeta : ((GetXmlDataData)this.data).convertRowMeta.getValueMetaList()) {
                    ((GetXmlDataData)this.data).convertRowMeta.addValueMeta(ValueMetaFactory.cloneValueMeta((IValueMeta)valueMeta, (int)2));
                }
                ((GetXmlDataData)this.data).convertRowMeta = ((GetXmlDataData)this.data).outputRowMeta.cloneToType(2);
                if (Utils.isEmpty((CharSequence)((GetXmlDataMeta)this.meta).getXMLField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.NoField", (String[])new String[0]));
                    throw new HopException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.NoField", (String[])new String[0]));
                }
                if (((GetXmlDataData)this.data).indexOfXmlField < 0) {
                    ((GetXmlDataData)this.data).indexOfXmlField = this.getInputRowMeta().indexOfValue(((GetXmlDataMeta)this.meta).getXMLField());
                    if (((GetXmlDataData)this.data).indexOfXmlField < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.ErrorFindingField", (String[])new String[]{((GetXmlDataMeta)this.meta).getXMLField()}));
                        throw new HopException(BaseMessages.getString(PKG, (String)"GetXMLData.Exception.CouldnotFindField", (String[])new String[]{((GetXmlDataMeta)this.meta).getXMLField()}));
                    }
                }
            }
            if (!((GetXmlDataMeta)this.meta).isInFields()) return true;
            String fieldvalue = this.getInputRowMeta().getString(((GetXmlDataData)this.data).readrow, ((GetXmlDataData)this.data).indexOfXmlField);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.XMLStream", (String[])new String[]{((GetXmlDataMeta)this.meta).getXMLField(), fieldvalue}));
            }
            if (((GetXmlDataMeta)this.meta).getIsAFile()) {
                FileObject file = null;
                try {
                    file = HopVfs.getFileObject((String)this.resolve(fieldvalue));
                    if (((GetXmlDataMeta)this.meta).isIgnoreEmptyFile() && file.getContent().getSize() == 0L) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"GetXMLData.Error.FileSizeZero", (String[])new String[]{String.valueOf(file.getName())}));
                        boolean bl = this.ReadNextString();
                        return bl;
                    }
                    if (!this.setDocument(null, file, false, false)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableCreateDocument", (String[])new String[0]));
                    }
                    if (!this.applyXPath()) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableApplyXPath", (String[])new String[0]));
                    }
                    this.addFileToResultFilesname(file);
                    if (!this.log.isDetailed()) return true;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.LoopFileOccurences", (String[])new String[]{"" + ((GetXmlDataData)this.data).nodesize, file.getName().getBaseName()}));
                    return true;
                }
                catch (Exception e) {
                    throw new HopException((Throwable)e);
                }
                finally {
                    try {
                        if (file != null) {
                            file.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            boolean url = false;
            boolean xmltring = true;
            if (((GetXmlDataMeta)this.meta).isReadUrl()) {
                url = true;
                xmltring = false;
            }
            if (!this.setDocument(fieldvalue, null, xmltring, url)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableCreateDocument", (String[])new String[0]));
            }
            if (!this.applyXPath()) {
                throw new HopException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableApplyXPath", (String[])new String[0]));
            }
            if (!this.log.isDetailed()) return true;
            this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.LoopFileOccurences", (String[])new String[]{"" + ((GetXmlDataData)this.data).nodesize}));
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnexpectedError", (String[])new String[]{e.toString()}));
            this.stopAll();
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            return false;
        }
    }

    private void addFileToResultFilesname(FileObject file) throws Exception {
        if (((GetXmlDataMeta)this.meta).addResultFile()) {
            ResultFile resultFile = new ResultFile(0, file, this.getPipelineMeta().getName(), this.getTransformName());
            resultFile.setComment(BaseMessages.getString(PKG, (String)"GetXMLData.Log.FileAddedResult", (String[])new String[0]));
            this.addResultFile(resultFile);
        }
    }

    public String addNSPrefix(String path, String loopPath) {
        if (((GetXmlDataData)this.data).NSPath.size() > 0) {
            Object fullPath = loopPath;
            if (!path.equals(fullPath)) {
                for (String tmp : path.split("/")) {
                    fullPath = tmp.equals("src/main") ? ((String)fullPath).substring(0, ((String)fullPath).lastIndexOf("/")) : (String)fullPath + "/" + tmp;
                }
            }
            int[] indexs = new int[((String)fullPath).split("/").length - 1];
            Arrays.fill(indexs, -1);
            int length = 0;
            for (int i = 0; i < ((GetXmlDataData)this.data).NSPath.size(); ++i) {
                if (((GetXmlDataData)this.data).NSPath.get(i).length() <= length || !((String)fullPath).startsWith(((GetXmlDataData)this.data).NSPath.get(i))) continue;
                Arrays.fill(indexs, ((GetXmlDataData)this.data).NSPath.get(i).split("/").length - 2, indexs.length, i);
                length = ((GetXmlDataData)this.data).NSPath.get(i).length();
            }
            StringBuilder newPath = new StringBuilder();
            String[] pathStrs = path.split("/");
            for (int i = 0; i < pathStrs.length; ++i) {
                String tmp = pathStrs[i];
                if (newPath.length() > 0) {
                    newPath.append("/");
                }
                if (!(tmp.length() <= 0 || tmp.contains(":") || tmp.contains(".") || tmp.contains("@"))) {
                    int index = indexs[i + indexs.length - pathStrs.length];
                    if (index >= 0) {
                        newPath.append("pre").append(index).append(":").append(tmp);
                        continue;
                    }
                    newPath.append(tmp);
                    continue;
                }
                newPath.append(tmp);
            }
            return newPath.toString();
        }
        return path;
    }

    private boolean applyXPath() {
        try {
            XPath xpath = ((GetXmlDataData)this.data).document.createXPath(((GetXmlDataData)this.data).PathValue);
            if (((GetXmlDataMeta)this.meta).isNamespaceAware()) {
                xpath = ((GetXmlDataData)this.data).document.createXPath(this.addNSPrefix(((GetXmlDataData)this.data).PathValue, ((GetXmlDataData)this.data).PathValue));
                xpath.setNamespaceURIs(((GetXmlDataData)this.data).NAMESPACE);
            }
            ((GetXmlDataData)this.data).an = xpath.selectNodes((Object)((GetXmlDataData)this.data).document);
            ((GetXmlDataData)this.data).nodesize = ((GetXmlDataData)this.data).an.size();
            ((GetXmlDataData)this.data).nodenr = 0;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.ErrorApplyXPath", (String[])new String[]{e.getMessage()}));
            return false;
        }
        return true;
    }

    private boolean openNextFile() {
        try {
            long fileSize;
            if (((GetXmlDataData)this.data).filenr >= ((GetXmlDataData)this.data).files.nrOfFiles()) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.FinishedProcessing", (String[])new String[0]));
                }
                return false;
            }
            ((GetXmlDataData)this.data).file = ((GetXmlDataData)this.data).files.getFile(((GetXmlDataData)this.data).filenr);
            ((GetXmlDataData)this.data).filename = HopVfs.getFilename((FileObject)((GetXmlDataData)this.data).file);
            if (((GetXmlDataMeta)this.meta).getShortFileNameField() != null && ((GetXmlDataMeta)this.meta).getShortFileNameField().length() > 0) {
                ((GetXmlDataData)this.data).shortFilename = ((GetXmlDataData)this.data).file.getName().getBaseName();
            }
            if (((GetXmlDataMeta)this.meta).getPathField() != null && ((GetXmlDataMeta)this.meta).getPathField().length() > 0) {
                ((GetXmlDataData)this.data).path = HopVfs.getFilename((FileObject)((GetXmlDataData)this.data).file.getParent());
            }
            if (((GetXmlDataMeta)this.meta).isHiddenField() != null && ((GetXmlDataMeta)this.meta).isHiddenField().length() > 0) {
                ((GetXmlDataData)this.data).hidden = ((GetXmlDataData)this.data).file.isHidden();
            }
            if (((GetXmlDataMeta)this.meta).getExtensionField() != null && ((GetXmlDataMeta)this.meta).getExtensionField().length() > 0) {
                ((GetXmlDataData)this.data).extension = ((GetXmlDataData)this.data).file.getName().getExtension();
            }
            if (((GetXmlDataMeta)this.meta).getLastModificationDateField() != null && ((GetXmlDataMeta)this.meta).getLastModificationDateField().length() > 0) {
                ((GetXmlDataData)this.data).lastModificationDateTime = new Date(((GetXmlDataData)this.data).file.getContent().getLastModifiedTime());
            }
            if (((GetXmlDataMeta)this.meta).getUriField() != null && ((GetXmlDataMeta)this.meta).getUriField().length() > 0) {
                ((GetXmlDataData)this.data).uriName = ((GetXmlDataData)this.data).file.getName().getURI();
            }
            if (((GetXmlDataMeta)this.meta).getRootUriField() != null && ((GetXmlDataMeta)this.meta).getRootUriField().length() > 0) {
                ((GetXmlDataData)this.data).rootUriName = ((GetXmlDataData)this.data).file.getName().getRootURI();
            }
            try {
                fileSize = ((GetXmlDataData)this.data).file.getContent().getSize();
            }
            catch (FileSystemException e) {
                fileSize = -1L;
            }
            if (((GetXmlDataMeta)this.meta).getSizeField() != null && ((GetXmlDataMeta)this.meta).getSizeField().length() > 0) {
                ((GetXmlDataData)this.data).size = fileSize;
            }
            ++((GetXmlDataData)this.data).filenr;
            if (((GetXmlDataMeta)this.meta).isIgnoreEmptyFile() && fileSize == 0L) {
                this.logBasic(BaseMessages.getString(PKG, (String)"GetXMLData.Error.FileSizeZero", (String[])new String[]{String.valueOf(((GetXmlDataData)this.data).file.getName())}));
                this.openNextFile();
            } else {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.OpeningFile", (String[])new String[]{((GetXmlDataData)this.data).file.toString()}));
                }
                if (!this.setDocument(null, ((GetXmlDataData)this.data).file, false, false)) {
                    if (((GetXmlDataData)this.data).stopPruning) {
                        return false;
                    }
                    throw new HopException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableCreateDocument", (String[])new String[0]));
                }
                if (((GetXmlDataData)this.data).prunePath == null && !this.applyXPath()) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableApplyXPath", (String[])new String[0]));
                }
                this.addFileToResultFilesname(((GetXmlDataData)this.data).file);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.FileOpened", (String[])new String[]{((GetXmlDataData)this.data).file.toString()}));
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.LoopFileOccurences", (String[])new String[]{"" + ((GetXmlDataData)this.data).nodesize, ((GetXmlDataData)this.data).file.getName().getBaseName()}));
                }
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableToOpenFile", (String[])new String[]{"" + ((GetXmlDataData)this.data).filenr, ((GetXmlDataData)this.data).file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    public boolean processRow() throws HopException {
        if (this.first && !((GetXmlDataMeta)this.meta).isInFields()) {
            this.first = false;
            ((GetXmlDataData)this.data).files = ((GetXmlDataMeta)this.meta).getFiles((IVariables)this);
            if (!((GetXmlDataMeta)this.meta).isdoNotFailIfNoFile() && ((GetXmlDataData)this.data).files.nrOfFiles() == 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.NoFiles", (String[])new String[0]));
            }
            this.handleMissingFiles();
            ((GetXmlDataData)this.data).outputRowMeta = new RowMeta();
            ((GetXmlDataMeta)this.meta).getFields(((GetXmlDataData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((GetXmlDataData)this.data).convertRowMeta = ((GetXmlDataData)this.data).outputRowMeta.cloneToType(2);
        }
        Object[] r = this.getXmlRow();
        if (((GetXmlDataData)this.data).errorInRowButContinue) {
            return true;
        }
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        return this.putRowOut(r);
    }

    private boolean putRowOut(Object[] r) throws HopException {
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"GetXMLData.Log.ReadRow", (String[])new String[]{((GetXmlDataData)this.data).outputRowMeta.getString(r)}));
        }
        this.incrementLinesInput();
        ++((GetXmlDataData)this.data).rownr;
        this.putRow(((GetXmlDataData)this.data).outputRowMeta, r);
        if (((GetXmlDataMeta)this.meta).getRowLimit() > 0L && ((GetXmlDataData)this.data).rownr > ((GetXmlDataMeta)this.meta).getRowLimit()) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private Object[] getXmlRow() throws HopException {
        if (!((GetXmlDataMeta)this.meta).isInFields()) {
            while (((GetXmlDataData)this.data).nodenr >= ((GetXmlDataData)this.data).nodesize || ((GetXmlDataData)this.data).file == null) {
                if (this.openNextFile()) continue;
                ((GetXmlDataData)this.data).errorInRowButContinue = false;
                return null;
            }
        }
        return this.getXmlRowPutRowWithErrorhandling();
    }

    private Object[] getXmlRowPutRowWithErrorhandling() throws HopException {
        Object[] r;
        ((GetXmlDataData)this.data).errorInRowButContinue = false;
        try {
            if (((GetXmlDataMeta)this.meta).isInFields()) {
                while (((GetXmlDataData)this.data).nodenr >= ((GetXmlDataData)this.data).nodesize || ((GetXmlDataData)this.data).readrow == null) {
                    if (!this.ReadNextString()) {
                        return null;
                    }
                    if (((GetXmlDataData)this.data).readrow != null) continue;
                    return null;
                }
            }
            r = this.processPutRow(((GetXmlDataData)this.data).an.get(((GetXmlDataData)this.data).nodenr));
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"GetXMLData.Error.UnableReadFile", (String[])new String[0]), (Throwable)e);
        }
        return r;
    }

    private Object[] processPutRow(Node node) throws HopException {
        Object[] outputRowData = this.buildEmptyRow();
        if (((GetXmlDataMeta)this.meta).isInFields()) {
            System.arraycopy(((GetXmlDataData)this.data).readrow, 0, outputRowData, 0, ((GetXmlDataData)this.data).nrReadRow);
        }
        try {
            IRowMeta irow;
            ++((GetXmlDataData)this.data).nodenr;
            for (int i = 0; i < ((GetXmlDataData)this.data).nrInputFields; ++i) {
                String nodevalue;
                GetXmlDataField xmlDataField = ((GetXmlDataMeta)this.meta).getInputFields()[i];
                String xPathValue = xmlDataField.getResolvedXPath();
                if (((GetXmlDataMeta)this.meta).isuseToken()) {
                    xPathValue = this.substituteToken(xPathValue, outputRowData);
                    if (this.isDetailed()) {
                        this.logDetailed(xPathValue);
                    }
                }
                if (((GetXmlDataMeta)this.meta).isNamespaceAware()) {
                    Node n;
                    XPath xpathField = node.createXPath(this.addNSPrefix(xPathValue, ((GetXmlDataData)this.data).PathValue));
                    xpathField.setNamespaceURIs(((GetXmlDataData)this.data).NAMESPACE);
                    nodevalue = xmlDataField.getResultType() == 0 ? xpathField.valueOf((Object)node) : ((n = xpathField.selectSingleNode((Object)node)) != null ? n.asXML() : "");
                } else {
                    Node n;
                    nodevalue = xmlDataField.getResultType() == 0 ? node.valueOf(xPathValue) : ((n = node.selectSingleNode(xPathValue)) != null ? n.asXML() : "");
                }
                switch (xmlDataField.getTrimType()) {
                    case 1: {
                        nodevalue = Const.ltrim((String)nodevalue);
                        break;
                    }
                    case 2: {
                        nodevalue = Const.rtrim((String)nodevalue);
                        break;
                    }
                    case 3: {
                        nodevalue = Const.trim((String)nodevalue);
                        break;
                    }
                }
                IValueMeta targetValueMeta = ((GetXmlDataData)this.data).outputRowMeta.getValueMeta(((GetXmlDataData)this.data).totalpreviousfields + i);
                IValueMeta sourceValueMeta = ((GetXmlDataData)this.data).convertRowMeta.getValueMeta(((GetXmlDataData)this.data).totalpreviousfields + i);
                outputRowData[((GetXmlDataData)this.data).totalpreviousfields + i] = targetValueMeta.convertData(sourceValueMeta, (Object)nodevalue);
                if (!((GetXmlDataMeta)this.meta).getInputFields()[i].isRepeated() || ((GetXmlDataData)this.data).previousRow == null || !Utils.isEmpty((CharSequence)nodevalue)) continue;
                outputRowData[((GetXmlDataData)this.data).totalpreviousfields + i] = ((GetXmlDataData)this.data).previousRow[((GetXmlDataData)this.data).totalpreviousfields + i];
            }
            int rowIndex = ((GetXmlDataData)this.data).totalpreviousfields + ((GetXmlDataData)this.data).nrInputFields;
            if (((GetXmlDataMeta)this.meta).includeFilename() && !Utils.isEmpty((CharSequence)((GetXmlDataMeta)this.meta).getFilenameField())) {
                outputRowData[rowIndex++] = ((GetXmlDataData)this.data).filename;
            }
            if (((GetXmlDataMeta)this.meta).includeRowNumber() && !Utils.isEmpty((CharSequence)((GetXmlDataMeta)this.meta).getRowNumberField())) {
                outputRowData[rowIndex++] = ((GetXmlDataData)this.data).rownr;
            }
            if (((GetXmlDataMeta)this.meta).getShortFileNameField() != null && ((GetXmlDataMeta)this.meta).getShortFileNameField().length() > 0) {
                outputRowData[rowIndex++] = ((GetXmlDataData)this.data).shortFilename;
            }
            if (((GetXmlDataMeta)this.meta).getExtensionField() != null && ((GetXmlDataMeta)this.meta).getExtensionField().length() > 0) {
                outputRowData[rowIndex++] = ((GetXmlDataData)this.data).extension;
            }
            if (((GetXmlDataMeta)this.meta).getPathField() != null && ((GetXmlDataMeta)this.meta).getPathField().length() > 0) {
                outputRowData[rowIndex++] = ((GetXmlDataData)this.data).path;
            }
            if (((GetXmlDataMeta)this.meta).getSizeField() != null && ((GetXmlDataMeta)this.meta).getSizeField().length() > 0) {
                outputRowData[rowIndex++] = ((GetXmlDataData)this.data).size;
            }
            if (((GetXmlDataMeta)this.meta).isHiddenField() != null && ((GetXmlDataMeta)this.meta).isHiddenField().length() > 0) {
                outputRowData[rowIndex++] = Boolean.valueOf(((GetXmlDataData)this.data).path);
            }
            if (((GetXmlDataMeta)this.meta).getLastModificationDateField() != null && ((GetXmlDataMeta)this.meta).getLastModificationDateField().length() > 0) {
                outputRowData[rowIndex++] = ((GetXmlDataData)this.data).lastModificationDateTime;
            }
            if (((GetXmlDataMeta)this.meta).getUriField() != null && ((GetXmlDataMeta)this.meta).getUriField().length() > 0) {
                outputRowData[rowIndex++] = ((GetXmlDataData)this.data).uriName;
            }
            if (((GetXmlDataMeta)this.meta).getRootUriField() != null && ((GetXmlDataMeta)this.meta).getRootUriField().length() > 0) {
                outputRowData[rowIndex] = ((GetXmlDataData)this.data).rootUriName;
            }
            if ((irow = this.getInputRowMeta()) == null) {
                ((GetXmlDataData)this.data).previousRow = outputRowData;
            } else {
                System.arraycopy(outputRowData, 0, this.prevRow, 0, outputRowData.length);
                ((GetXmlDataData)this.data).previousRow = irow.cloneRow(outputRowData, this.prevRow);
            }
        }
        catch (Exception e) {
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(((GetXmlDataData)this.data).outputRowMeta, outputRowData, 1L, e.toString(), null, "GetXMLData001");
                ((GetXmlDataData)this.data).errorInRowButContinue = true;
                return null;
            }
            this.logError(e.toString());
            throw new HopException(e.toString());
        }
        return outputRowData;
    }

    public String substituteToken(String aString, Object[] outputRowData) {
        if (aString == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        String rest = aString;
        int i = rest.indexOf(((GetXmlDataData)this.data).tokenStart);
        while (i > -1) {
            int j = rest.indexOf(((GetXmlDataData)this.data).tokenEnd, i + ((GetXmlDataData)this.data).tokenStart.length());
            if (j > -1) {
                String varName = rest.substring(i + ((GetXmlDataData)this.data).tokenStart.length(), j);
                Object value = varName;
                for (int k = 0; k < ((GetXmlDataData)this.data).nrInputFields; ++k) {
                    GetXmlDataField tmpXmlInputField = ((GetXmlDataMeta)this.meta).getInputFields()[k];
                    if (!tmpXmlInputField.getName().equalsIgnoreCase(varName)) continue;
                    value = "'" + String.valueOf(outputRowData[((GetXmlDataData)this.data).totalpreviousfields + k]) + "'";
                }
                buffer.append(rest.substring(0, i));
                buffer.append(value);
                rest = rest.substring(j + ((GetXmlDataData)this.data).tokenEnd.length());
            } else {
                buffer.append(rest);
                rest = "";
            }
            i = rest.indexOf(((GetXmlDataData)this.data).tokenEnd);
        }
        buffer.append(rest);
        return buffer.toString();
    }

    public boolean init() {
        if (super.init()) {
            ((GetXmlDataData)this.data).rownr = 1L;
            ((GetXmlDataData)this.data).nrInputFields = ((GetXmlDataMeta)this.meta).getInputFields().length;
            for (int i = 0; i < ((GetXmlDataData)this.data).nrInputFields; ++i) {
                GetXmlDataField xmlDataField = ((GetXmlDataMeta)this.meta).getInputFields()[i];
                Object xPathValue = this.resolve(xmlDataField.getXPath());
                if (xmlDataField.getElementType() == 1) {
                    int last = ((String)xPathValue).lastIndexOf("/");
                    if (last > -1) {
                        String attribut;
                        if (!(attribut = ((String)xPathValue).substring(++last, ((String)xPathValue).length())).startsWith("@")) {
                            xPathValue = ((String)xPathValue).substring(0, last) + "@" + attribut;
                        }
                    } else if (!((String)xPathValue).startsWith("@")) {
                        xPathValue = "@" + (String)xPathValue;
                    }
                }
                xmlDataField.setResolvedXPath((String)xPathValue);
            }
            ((GetXmlDataData)this.data).PathValue = this.resolve(((GetXmlDataMeta)this.meta).getLoopXPath());
            if (Utils.isEmpty((CharSequence)((GetXmlDataData)this.data).PathValue)) {
                this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Error.EmptyPath", (String[])new String[0]));
                return false;
            }
            if (!((GetXmlDataData)this.data).PathValue.substring(0, 1).equals("/")) {
                ((GetXmlDataData)this.data).PathValue = "/" + ((GetXmlDataData)this.data).PathValue;
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.LoopXPath", (String[])new String[]{((GetXmlDataData)this.data).PathValue}));
            }
            ((GetXmlDataData)this.data).prunePath = this.resolve(((GetXmlDataMeta)this.meta).getPrunePath());
            if (((GetXmlDataData)this.data).prunePath != null) {
                if (Utils.isEmpty((CharSequence)((GetXmlDataData)this.data).prunePath.trim())) {
                    ((GetXmlDataData)this.data).prunePath = null;
                } else {
                    if (!((GetXmlDataData)this.data).prunePath.startsWith("/")) {
                        ((GetXmlDataData)this.data).prunePath = "/" + ((GetXmlDataData)this.data).prunePath;
                    }
                    if (((GetXmlDataMeta)this.meta).isInFields()) {
                        ((GetXmlDataData)this.data).prunePath = null;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((GetXmlDataData)this.data).file != null) {
            try {
                ((GetXmlDataData)this.data).file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (((GetXmlDataData)this.data).an != null) {
            ((GetXmlDataData)this.data).an.clear();
            ((GetXmlDataData)this.data).an = null;
        }
        if (((GetXmlDataData)this.data).NAMESPACE != null) {
            ((GetXmlDataData)this.data).NAMESPACE.clear();
            ((GetXmlDataData)this.data).NAMESPACE = null;
        }
        if (((GetXmlDataData)this.data).NSPath != null) {
            ((GetXmlDataData)this.data).NSPath.clear();
            ((GetXmlDataData)this.data).NSPath = null;
        }
        if (((GetXmlDataData)this.data).readrow != null) {
            ((GetXmlDataData)this.data).readrow = null;
        }
        if (((GetXmlDataData)this.data).document != null) {
            ((GetXmlDataData)this.data).document = null;
        }
        if (((GetXmlDataData)this.data).fr != null) {
            BaseTransform.closeQuietly((Closeable)((GetXmlDataData)this.data).fr);
        }
        if (((GetXmlDataData)this.data).is != null) {
            BaseTransform.closeQuietly((Closeable)((GetXmlDataData)this.data).is);
        }
        if (((GetXmlDataData)this.data).files != null) {
            ((GetXmlDataData)this.data).files = null;
        }
        super.dispose();
    }
}

