/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.CreateBackupRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.util.Timestamps;
import javax.annotation.Nonnull;
import org.threeten.bp.Instant;

public final class CreateBackupRequest {
    private final CreateBackupRequest.Builder requestBuilder = com.google.bigtable.admin.v2.CreateBackupRequest.newBuilder();
    private final String clusterId;
    private String sourceTableId;

    public static CreateBackupRequest of(String clusterId, String backupId) {
        CreateBackupRequest request = new CreateBackupRequest(clusterId, backupId);
        return request;
    }

    private CreateBackupRequest(String clusterId, String backupId) {
        Preconditions.checkNotNull((Object)clusterId);
        Preconditions.checkNotNull((Object)backupId);
        this.requestBuilder.setBackupId(backupId);
        this.clusterId = clusterId;
        this.sourceTableId = null;
    }

    public CreateBackupRequest setSourceTableId(String sourceTableId) {
        Preconditions.checkNotNull((Object)sourceTableId);
        this.sourceTableId = sourceTableId;
        return this;
    }

    public CreateBackupRequest setExpireTime(Instant expireTime) {
        Preconditions.checkNotNull((Object)expireTime);
        this.requestBuilder.getBackupBuilder().setExpireTime(Timestamps.fromMillis((long)expireTime.toEpochMilli()));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateBackupRequest that = (CreateBackupRequest)o;
        return Objects.equal((Object)this.requestBuilder.getBackupId(), (Object)that.requestBuilder.getBackupId()) && Objects.equal((Object)this.clusterId, (Object)that.clusterId) && Objects.equal((Object)this.sourceTableId, (Object)that.sourceTableId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestBuilder.getBackupId(), this.clusterId, this.sourceTableId});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.CreateBackupRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)instanceId);
        this.requestBuilder.getBackupBuilder().setSourceTable(NameUtil.formatTableName(projectId, instanceId, this.sourceTableId));
        return this.requestBuilder.setParent(NameUtil.formatClusterName(projectId, instanceId, this.clusterId)).build();
    }
}

