/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client.testing;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.testing.util.TestableByteArrayInputStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.datastore.v1.client.DatastoreFactory;
import com.google.datastore.v1.client.DatastoreOptions;
import com.google.protobuf.Message;
import com.google.rpc.Code;
import com.google.rpc.Status;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class MockDatastoreFactory
extends DatastoreFactory {
    private int nextStatus;
    private Message nextResponse;
    private Status nextError;
    private IOException nextException;
    private String lastPath;
    private String lastMimeType;
    private byte[] lastBody;
    private List<String> lastCookies;
    private String lastApiFormatHeaderValue;

    public void setNextResponse(Message response) {
        this.nextStatus = 200;
        this.nextResponse = response;
        this.nextError = null;
        this.nextException = null;
    }

    public void setNextError(int status, Code code, String message) {
        this.nextStatus = status;
        this.nextResponse = null;
        this.nextError = MockDatastoreFactory.makeErrorContent(message, code);
        this.nextException = null;
    }

    public void setNextException(IOException exception) {
        this.nextStatus = 0;
        this.nextResponse = null;
        this.nextError = null;
        this.nextException = exception;
    }

    @Override
    public HttpRequestFactory makeClient(DatastoreOptions options) {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) {
                return new MockLowLevelHttpRequest(url){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockDatastoreFactory.this.lastPath = new GenericUrl(this.getUrl()).getRawPath();
                        MockDatastoreFactory.this.lastMimeType = this.getContentType();
                        MockDatastoreFactory.this.lastCookies = this.getHeaderValues("Cookie");
                        MockDatastoreFactory.this.lastApiFormatHeaderValue = (String)Iterables.getOnlyElement((Iterable)this.getHeaderValues("X-Goog-Api-Format-Version"));
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        this.getStreamingContent().writeTo((OutputStream)out);
                        MockDatastoreFactory.access$402(MockDatastoreFactory.this, out.toByteArray());
                        if (MockDatastoreFactory.this.nextException != null) {
                            throw MockDatastoreFactory.this.nextException;
                        }
                        MockLowLevelHttpResponse response = new MockLowLevelHttpResponse().setStatusCode(MockDatastoreFactory.this.nextStatus).setContentType("application/x-protobuf");
                        if (MockDatastoreFactory.this.nextError != null) {
                            Preconditions.checkState((MockDatastoreFactory.this.nextResponse == null ? 1 : 0) != 0);
                            response.setContent((InputStream)new TestableByteArrayInputStream(MockDatastoreFactory.this.nextError.toByteArray()));
                        } else {
                            response.setContent((InputStream)new TestableByteArrayInputStream(MockDatastoreFactory.this.nextResponse.toByteArray()));
                        }
                        return response;
                    }
                };
            }
        };
        Credential credential = options.getCredential();
        return transport.createRequestFactory((HttpRequestInitializer)credential);
    }

    public String getLastPath() {
        return this.lastPath;
    }

    public String getLastMimeType() {
        return this.lastMimeType;
    }

    public String getLastApiFormatHeaderValue() {
        return this.lastApiFormatHeaderValue;
    }

    public byte[] getLastBody() {
        return this.lastBody;
    }

    public List<String> getLastCookies() {
        return this.lastCookies;
    }

    private static Status makeErrorContent(String message, Code code) {
        return Status.newBuilder().setCode(code.getNumber()).setMessage(message).build();
    }

    static /* synthetic */ byte[] access$402(MockDatastoreFactory x0, byte[] x1) {
        x0.lastBody = x1;
        return x1;
    }
}

