/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.wrapper.field;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.metadata.MongoDbConnection;
import org.apache.hop.mongo.wrapper.MongoClientWrapper;
import org.apache.hop.mongo.wrapper.field.MongoField;
import org.apache.hop.pipeline.transforms.mongodbinput.DiscoverFieldsCallback;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputDiscoverFields;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputMeta;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;

public class MongodbInputDiscoverFieldsImpl
implements MongoDbInputDiscoverFields {
    private static final Class<?> PKG = MongodbInputDiscoverFieldsImpl.class;

    @Override
    public List<MongoField> discoverFields(IVariables variables, MongoDbConnection connection, String collection, String query, String fields, boolean isPipeline, int docsToSample, MongoDbInputMeta transform) throws HopException {
        MongoClientWrapper clientWrapper;
        try {
            clientWrapper = connection.createWrapper(variables, LogChannel.GENERAL);
        }
        catch (MongoDbException e) {
            throw new HopException((Throwable)e);
        }
        String databaseName = variables.resolve(connection.getDbName());
        try {
            List list = clientWrapper.perform(databaseName, db -> this.getMongoFields(collection, query, fields, isPipeline, docsToSample, db));
            return list;
        }
        catch (Exception ex) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToDiscoverFields", (String[])new String[0]), (Throwable)ex);
        }
        finally {
            try {
                clientWrapper.dispose();
            }
            catch (MongoDbException mongoDbException) {}
        }
    }

    private List<MongoField> getMongoFields(String collection, String query, String fields, boolean isPipeline, int docsToSample, DB db) throws MongoDbException {
        DBCursor cursor = null;
        int numDocsToSample = docsToSample;
        if (numDocsToSample < 1) {
            numDocsToSample = 100;
        }
        ArrayList<MongoField> discoveredFields = new ArrayList<MongoField>();
        HashMap<String, MongoField> fieldLookup = new HashMap<String, MongoField>();
        try {
            if (StringUtils.isEmpty((String)collection)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.NoCollectionSpecified", (String[])new String[0]));
            }
            DBCollection dbcollection = db.getCollection(collection);
            Iterator<DBObject> pipeSample = null;
            if (isPipeline) {
                pipeSample = MongodbInputDiscoverFieldsImpl.setUpPipelineSample(query, numDocsToSample, dbcollection);
            } else if (StringUtils.isEmpty((String)query) && StringUtils.isEmpty((String)fields)) {
                cursor = dbcollection.find().limit(numDocsToSample);
            } else {
                DBObject dbObject = (DBObject)JSON.parse((String)(StringUtils.isEmpty((String)query) ? "{}" : query));
                DBObject dbObject2 = (DBObject)JSON.parse((String)fields);
                cursor = dbcollection.find(dbObject, dbObject2).limit(numDocsToSample);
            }
            int actualCount = 0;
            while (cursor != null ? cursor.hasNext() : pipeSample.hasNext()) {
                ++actualCount;
                DBObject nextDoc = cursor != null ? cursor.next() : pipeSample.next();
                MongodbInputDiscoverFieldsImpl.docToFields(nextDoc, fieldLookup);
            }
            MongodbInputDiscoverFieldsImpl.postProcessPaths(fieldLookup, discoveredFields, actualCount);
            ArrayList<MongoField> arrayList = discoveredFields;
            return arrayList;
        }
        catch (Exception e) {
            throw new MongoDbException(e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @Override
    public void discoverFields(IVariables variables, MongoDbConnection connection, String collection, String query, String fields, boolean isPipeline, int docsToSample, MongoDbInputMeta transform, DiscoverFieldsCallback discoverFieldsCallback) throws HopException {
        new Thread(() -> {
            try {
                discoverFieldsCallback.notifyFields(this.discoverFields(variables, connection, collection, query, fields, isPipeline, docsToSample, transform));
            }
            catch (HopException e) {
                discoverFieldsCallback.notifyException((Exception)((Object)e));
            }
        }).start();
    }

    protected static void postProcessPaths(Map<String, MongoField> fieldLookup, List<MongoField> discoveredFields, int numDocsProcessed) {
        ArrayList<String> fieldKeys = new ArrayList<String>(fieldLookup.keySet());
        Collections.sort(fieldKeys);
        for (String key : fieldKeys) {
            MongoField m = fieldLookup.get(key);
            m.occurrenceFraction = m.percentageOfSample + "/" + numDocsProcessed;
            MongodbInputDiscoverFieldsImpl.setMinArrayIndexes(m);
            if (m.fieldName.contains("[") && m.fieldName.contains(":")) {
                m.arrayIndexInfo = m.fieldName;
            }
            if (m.fieldName.indexOf(46) >= 0) {
                m.fieldName = m.fieldName.substring(m.fieldName.lastIndexOf(46) + 1, m.fieldName.length());
            }
            if (m.disparateTypes) {
                m.hopType = IValueMeta.getTypeDescription((int)2);
            }
            discoveredFields.add(m);
        }
        HashMap<String, Integer> tempM = new HashMap<String, Integer>();
        for (MongoField m : discoveredFields) {
            if (tempM.get(m.fieldName) != null) {
                Integer toUse = (Integer)tempM.get(m.fieldName);
                String key = m.fieldName;
                m.fieldName = key + "_" + toUse;
                Integer n = toUse;
                toUse = toUse + 1;
                tempM.put(key, toUse);
                continue;
            }
            tempM.put(m.fieldName, 1);
        }
    }

    protected static void setMinArrayIndexes(MongoField m) {
        if (m.fieldName.indexOf(91) < 0) {
            return;
        }
        String temp = m.fieldPath;
        String tempComp = m.fieldName;
        StringBuilder updated = new StringBuilder();
        while (temp.indexOf(91) >= 0) {
            String firstPart = temp.substring(0, temp.indexOf(91));
            String innerPart = temp.substring(temp.indexOf(91) + 1, temp.indexOf(93));
            if (!innerPart.equals("-")) {
                updated.append(temp);
                temp = "";
                break;
            }
            updated.append(firstPart);
            String innerComp = tempComp.substring(tempComp.indexOf(91) + 1, tempComp.indexOf(93));
            if (temp.indexOf(93) < temp.length() - 1) {
                temp = temp.substring(temp.indexOf(93) + 1, temp.length());
                tempComp = tempComp.substring(tempComp.indexOf(93) + 1, tempComp.length());
            } else {
                temp = "";
            }
            String[] compParts = innerComp.split(":");
            String replace = "[" + compParts[0] + "]";
            updated.append(replace);
        }
        if (temp.length() > 0) {
            updated.append(temp);
        }
        m.fieldPath = updated.toString();
    }

    protected static void docToFields(DBObject doc, Map<String, MongoField> lookup) {
        String root = "$";
        String name = "$";
        if (doc instanceof BasicDBObject) {
            MongodbInputDiscoverFieldsImpl.processRecord((BasicDBObject)doc, root, name, lookup);
        } else if (doc instanceof BasicDBList) {
            MongodbInputDiscoverFieldsImpl.processList((BasicDBList)doc, root, name, lookup);
        }
    }

    private static void processRecord(BasicDBObject rec, String path, String name, Map<String, MongoField> lookup) {
        for (String key : rec.keySet()) {
            Object fieldValue = rec.get(key);
            if (fieldValue instanceof BasicDBObject) {
                MongodbInputDiscoverFieldsImpl.processRecord((BasicDBObject)fieldValue, path + "." + key, name + "." + key, lookup);
                continue;
            }
            if (fieldValue instanceof BasicDBList) {
                MongodbInputDiscoverFieldsImpl.processList((BasicDBList)fieldValue, path + "." + key, name + "." + key, lookup);
                continue;
            }
            String finalPath = path + "." + key;
            String finalName = name + "." + key;
            if (!lookup.containsKey(finalPath)) {
                MongoField newField = new MongoField();
                int hopType = MongodbInputDiscoverFieldsImpl.mongoToHopType(fieldValue);
                newField.mongoType = String.class;
                if (fieldValue != null) {
                    newField.mongoType = fieldValue.getClass();
                }
                newField.fieldName = finalName;
                newField.fieldPath = finalPath;
                newField.hopType = IValueMeta.getTypeDescription((int)hopType);
                newField.percentageOfSample = 1;
                lookup.put(finalPath, newField);
                continue;
            }
            MongoField m = lookup.get(finalPath);
            Class fieldClass = String.class;
            if (fieldValue != null) {
                fieldClass = fieldValue.getClass();
            }
            if (!m.mongoType.isAssignableFrom(fieldClass)) {
                m.disparateTypes = true;
            }
            ++m.percentageOfSample;
            MongodbInputDiscoverFieldsImpl.updateMinMaxArrayIndexes(m, finalName);
        }
    }

    private static void processList(BasicDBList list, String path, String name, Map<String, MongoField> lookup) {
        if (list.size() == 0) {
            return;
        }
        String nonPrimitivePath = path + "[-]";
        String primitivePath = path;
        for (int i = 0; i < list.size(); ++i) {
            Object element = list.get(i);
            if (element instanceof BasicDBObject) {
                MongodbInputDiscoverFieldsImpl.processRecord((BasicDBObject)element, nonPrimitivePath, name + "[" + i + ":" + i + "]", lookup);
                continue;
            }
            if (element instanceof BasicDBList) {
                MongodbInputDiscoverFieldsImpl.processList((BasicDBList)element, nonPrimitivePath, name + "[" + i + ":" + i + "]", lookup);
                continue;
            }
            String finalPath = primitivePath + "[" + i + "]";
            String finalName = name + "[" + i + "]";
            if (!lookup.containsKey(finalPath)) {
                MongoField newField = new MongoField();
                int hopType = MongodbInputDiscoverFieldsImpl.mongoToHopType(element);
                newField.mongoType = String.class;
                if (element != null) {
                    newField.mongoType = element.getClass();
                }
                newField.fieldName = finalPath;
                newField.fieldPath = finalName;
                newField.hopType = IValueMeta.getTypeDescription((int)hopType);
                newField.percentageOfSample = 1;
                lookup.put(finalPath, newField);
                continue;
            }
            MongoField m = lookup.get(finalPath);
            Class elementClass = String.class;
            if (element != null) {
                elementClass = element.getClass();
            }
            if (!m.mongoType.isAssignableFrom(elementClass)) {
                m.disparateTypes = true;
            }
            ++m.percentageOfSample;
            MongodbInputDiscoverFieldsImpl.updateMinMaxArrayIndexes(m, finalName);
        }
    }

    protected static void updateMinMaxArrayIndexes(MongoField m, String update) {
        if (m.fieldName.indexOf(91) < 0) {
            return;
        }
        if (m.fieldName.split("\\[").length != update.split("\\[").length) {
            throw new IllegalArgumentException("Field path and update path do not seem to contain the same number of array parts!");
        }
        String temp = m.fieldName;
        String tempComp = update;
        StringBuffer updated = new StringBuffer();
        while (temp.indexOf(91) >= 0) {
            String firstPart = temp.substring(0, temp.indexOf(91));
            String innerPart = temp.substring(temp.indexOf(91) + 1, temp.indexOf(93));
            if (innerPart.indexOf(58) < 0) {
                updated.append(temp);
                temp = "";
                break;
            }
            updated.append(firstPart);
            String innerComp = tempComp.substring(tempComp.indexOf(91) + 1, tempComp.indexOf(93));
            if (temp.indexOf(93) < temp.length() - 1) {
                temp = temp.substring(temp.indexOf(93) + 1, temp.length());
                tempComp = tempComp.substring(tempComp.indexOf(93) + 1, tempComp.length());
            } else {
                temp = "";
            }
            String[] origParts = innerPart.split(":");
            String[] compParts = innerComp.split(":");
            int origMin = Integer.parseInt(origParts[0]);
            int compMin = Integer.parseInt(compParts[0]);
            int origMax = Integer.parseInt(origParts[1]);
            int compMax = Integer.parseInt(compParts[1]);
            String newRange = "[" + String.valueOf(compMin < origMin ? Integer.valueOf(compMin) : origParts[0]) + ":" + String.valueOf(compMax > origMax ? Integer.valueOf(compMax) : origParts[1]) + "]";
            updated.append(newRange);
        }
        if (temp.length() > 0) {
            updated.append(temp);
        }
        m.fieldName = updated.toString();
    }

    protected static int mongoToHopType(Object fieldValue) {
        if (fieldValue == null) {
            return 2;
        }
        if (fieldValue instanceof Symbol || fieldValue instanceof String || fieldValue instanceof Code || fieldValue instanceof ObjectId || fieldValue instanceof MinKey || fieldValue instanceof MaxKey) {
            return 2;
        }
        if (fieldValue instanceof Date) {
            return 3;
        }
        if (fieldValue instanceof Number) {
            try {
                Integer.parseInt(fieldValue.toString());
                return 5;
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }
        if (fieldValue instanceof Binary) {
            return 8;
        }
        if (fieldValue instanceof BSONTimestamp) {
            return 5;
        }
        return 2;
    }

    private static Iterator<DBObject> setUpPipelineSample(String query, int numDocsToSample, DBCollection collection) throws HopException {
        query = (String)query + ", {$limit : " + numDocsToSample + "}";
        List<DBObject> samplePipe = MongodbInputDiscoverFieldsImpl.jsonPipelineToDBObjectList((String)query);
        Cursor cursor = collection.aggregate(samplePipe, AggregationOptions.builder().build());
        return cursor;
    }

    public static List<DBObject> jsonPipelineToDBObjectList(String jsonPipeline) throws HopException {
        ArrayList<DBObject> pipeline = new ArrayList<DBObject>();
        StringBuilder b = new StringBuilder(jsonPipeline.trim());
        int bracketCount = -1;
        ArrayList<String> parts = new ArrayList<String>();
        for (int i = 0; i < b.length(); ++i) {
            if (b.charAt(i) == '{') {
                if (bracketCount == -1) {
                    b.delete(0, i);
                    bracketCount = 0;
                    i = 0;
                }
                ++bracketCount;
            }
            if (b.charAt(i) == '}') {
                --bracketCount;
            }
            if (bracketCount != 0) continue;
            String part = b.substring(0, i + 1);
            parts.add(part);
            bracketCount = -1;
            if (i == b.length() - 1) break;
            b.delete(0, i + 1);
            i = 0;
        }
        for (String p : parts) {
            if (StringUtils.isEmpty((String)p)) continue;
            DBObject o = (DBObject)JSON.parse((String)p);
            pipeline.add(o);
        }
        if (pipeline.size() == 0) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToParsePipelineOperators", (String[])new String[0]));
        }
        return pipeline;
    }
}

