/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodbdelete;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteResult;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.metadata.MongoDbConnection;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mongodbdelete.MongoDbDeleteData;
import org.apache.hop.pipeline.transforms.mongodbdelete.MongoDbDeleteField;
import org.apache.hop.pipeline.transforms.mongodbdelete.MongoDbDeleteMeta;

public class MongoDbDelete
extends BaseTransform<MongoDbDeleteMeta, MongoDbDeleteData> {
    private static final Class<?> PKG = MongoDbDelete.class;
    private int writeRetries;
    protected long writeRetryDelay;

    public MongoDbDelete(TransformMeta transformMeta, MongoDbDeleteMeta meta, MongoDbDeleteData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (((MongoDbDeleteMeta)this.meta).isUseJsonQuery()) {
            if (this.first) {
                this.first = false;
                if (this.getInputRowMeta() == null) {
                    ((MongoDbDeleteData)this.data).outputRowMeta = new RowMeta();
                } else {
                    ((MongoDbDeleteData)this.data).setOutputRowMeta(this.getInputRowMeta());
                }
                ((MongoDbDeleteData)this.data).init((IVariables)this);
                DBObject query = this.getQueryFromJSON(((MongoDbDeleteMeta)this.meta).getJsonQuery(), row);
                this.commitDelete(query, row);
            } else if (((MongoDbDeleteMeta)this.meta).isExecuteForEachIncomingRow()) {
                if (row == null) {
                    this.disconnect();
                    this.setOutputDone();
                    return false;
                }
                DBObject query = this.getQueryFromJSON(((MongoDbDeleteMeta)this.meta).getJsonQuery(), row);
                this.commitDelete(query, row);
            }
            if (row == null) {
                this.disconnect();
                this.setOutputDone();
                return false;
            }
            if (!this.isStopped()) {
                this.putRow(((MongoDbDeleteData)this.data).getOutputRowMeta(), row);
            }
            return true;
        }
        if (row == null) {
            this.disconnect();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((MongoDbDeleteData)this.data).setOutputRowMeta(this.getInputRowMeta());
            IRowMeta rmi = this.getInputRowMeta();
            List<MongoDbDeleteField> mongoFields = ((MongoDbDeleteMeta)this.meta).getMongoFields();
            this.checkInputFieldsMatch(rmi, mongoFields);
            ((MongoDbDeleteData)this.data).setMongoFields(((MongoDbDeleteMeta)this.meta).getMongoFields());
            ((MongoDbDeleteData)this.data).init((IVariables)this);
        }
        if (!this.isStopped()) {
            this.putRow(((MongoDbDeleteData)this.data).getOutputRowMeta(), row);
            DBObject query = MongoDbDeleteData.getQueryObject(((MongoDbDeleteData)this.data).mUserFields, this.getInputRowMeta(), row, (IVariables)this);
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"MongoDbDelete.Message.Debug.QueryForDelete", (Object[])new Object[]{query}));
            }
            if (query != null) {
                this.commitDelete(query, row);
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            String connectionName = this.resolve(((MongoDbDeleteMeta)this.meta).getConnectionName());
            try {
                try {
                    ((MongoDbDeleteData)this.data).connection = (MongoDbConnection)this.metadataProvider.getSerializer(MongoDbConnection.class).load(connectionName);
                }
                catch (Exception e) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.ErrorLoadingMongoDbConnection", (String[])new String[]{connectionName}));
                }
                if (((MongoDbDeleteData)this.data).connection == null) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.MongoDbConnection.NotFound", (String[])new String[]{connectionName}));
                }
                String databaseName = this.resolve(((MongoDbDeleteData)this.data).connection.getDbName());
                if (StringUtils.isEmpty((String)databaseName)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.NoDBSpecified", (String[])new String[0]));
                }
                String collection = this.resolve(((MongoDbDeleteMeta)this.meta).getCollection());
                if (StringUtils.isEmpty((String)collection)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.NoCollectionSpecified", (String[])new String[0]));
                }
                if (!StringUtils.isEmpty((String)((MongoDbDeleteData)this.data).connection.getAuthenticationUser())) {
                    String authInfo = ((MongoDbDeleteData)this.data).connection.isUsingKerberos() ? BaseMessages.getString(PKG, (String)"MongoDbInput.Message.KerberosAuthentication", (String[])new String[]{this.resolve(((MongoDbDeleteData)this.data).connection.getAuthenticationUser())}) : BaseMessages.getString(PKG, (String)"MongoDbInput.Message.NormalAuthentication", (String[])new String[]{this.resolve(((MongoDbDeleteData)this.data).connection.getAuthenticationUser())});
                    this.logBasic(authInfo);
                }
                ((MongoDbDeleteData)this.data).clientWrapper = ((MongoDbDeleteData)this.data).connection.createWrapper((IVariables)this, this.log);
                ((MongoDbDeleteData)this.data).collection = ((MongoDbDeleteData)this.data).clientWrapper.getCollection(databaseName, collection);
                if (!StringUtil.isEmpty((String)((MongoDbDeleteMeta)this.meta).getWriteRetries())) {
                    try {
                        this.setWriteRetries(Integer.parseInt(((MongoDbDeleteMeta)this.meta).getWriteRetries()));
                    }
                    catch (NumberFormatException ex) {
                        this.setWriteRetries(((MongoDbDeleteMeta)this.meta).nbRetries);
                    }
                }
                if (!StringUtil.isEmpty((String)((MongoDbDeleteMeta)this.meta).getWriteRetryDelay())) {
                    try {
                        this.writeRetryDelay = Long.parseLong(((MongoDbDeleteMeta)this.meta).getWriteRetryDelay());
                    }
                    catch (NumberFormatException ex) {
                        this.writeRetryDelay = ((MongoDbDeleteMeta)this.meta).retryDelay;
                    }
                }
                return true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorConnectingToMongoDb.Exception", (String[])new String[]{((MongoDbDeleteData)this.data).connection.getHostname(), ((MongoDbDeleteData)this.data).connection.getPort(), ((MongoDbDeleteData)this.data).connection.getDbName(), ((MongoDbDeleteMeta)this.meta).getCollection()}), e);
                return false;
            }
        }
        return false;
    }

    public void dispose() {
        if (((MongoDbDeleteData)this.data).cursor != null) {
            try {
                ((MongoDbDeleteData)this.data).cursor.close();
            }
            catch (MongoDbException e) {
                this.log.logError(e.getMessage());
            }
        }
        if (((MongoDbDeleteData)this.data).clientWrapper != null) {
            try {
                ((MongoDbDeleteData)this.data).clientWrapper.dispose();
            }
            catch (MongoDbException e) {
                this.log.logError(e.getMessage());
            }
        }
        super.dispose();
    }

    protected void disconnect() {
        if (this.data != null) {
            try {
                ((MongoDbDeleteData)this.data).getConnection().dispose();
            }
            catch (MongoDbException e) {
                this.log.logError(e.getMessage());
            }
        }
    }

    protected void commitDelete(DBObject deleteQuery, Object[] row) throws HopException {
        int retrys = 0;
        MongoException lastEx = null;
        while (retrys <= this.writeRetries && !this.isStopped()) {
            WriteResult result;
            block10: {
                result = null;
                try {
                    try {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbDelete.Message.ExecutingQuery", (Object[])new Object[]{deleteQuery}));
                        result = ((MongoDbDeleteData)this.data).getCollection().remove(deleteQuery);
                    }
                    catch (MongoDbException e) {
                        throw new MongoException(e.getMessage(), (Throwable)e);
                    }
                }
                catch (MongoException me) {
                    lastEx = me;
                    if (++retrys > this.writeRetries) break block10;
                    this.logError(BaseMessages.getString(PKG, (String)"MongoDbDelete.ErrorMessage.ErrorWritingToMongo", (String[])new String[]{me.toString()}));
                    this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbDelete.Message.Retry", (Object[])new Object[]{this.writeRetryDelay}));
                    try {
                        Thread.sleep(this.writeRetryDelay * 1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (result == null) continue;
            break;
        }
        if ((retrys > this.writeRetries || this.isStopped()) && lastEx != null) {
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), row, 1L, lastEx.getMessage(), "", "MongoDbDelete");
            } else {
                throw new HopException((Throwable)lastEx);
            }
        }
    }

    public DBObject getQueryFromJSON(String json, Object[] row) throws HopException {
        BasicDBObject query;
        String jsonQuery = this.resolve(json);
        if (StringUtil.isEmpty((String)jsonQuery)) {
            query = new BasicDBObject();
        } else {
            if (((MongoDbDeleteMeta)this.meta).isExecuteForEachIncomingRow() && row != null) {
                jsonQuery = this.resolve(jsonQuery, this.getInputRowMeta(), row);
            }
            query = BasicDBObject.parse((String)jsonQuery);
        }
        return query;
    }

    final void checkInputFieldsMatch(IRowMeta rmi, List<MongoDbDeleteField> mongoFields) throws HopException {
        if (mongoFields == null || mongoFields.isEmpty()) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbDeleteDialog.ErrorMessage.NoFieldPathsDefined", (String[])new String[0]));
        }
        HashSet<String> expected = new HashSet<String>(mongoFields.size(), 1.0f);
        HashSet<String> actual = new HashSet<String>(rmi.getFieldNames().length, 1.0f);
        for (MongoDbDeleteField field : mongoFields) {
            String field1 = this.resolve(field.incomingField1);
            String field2 = this.resolve(field.incomingField2);
            expected.add(field1);
            if (StringUtil.isEmpty((String)field2)) continue;
            expected.add(field2);
        }
        for (int i = 0; i < rmi.size(); ++i) {
            String metaFieldName = rmi.getValueMeta(i).getName();
            actual.add(metaFieldName);
        }
        if (!actual.containsAll(expected)) {
            expected.removeAll(actual);
            StringBuilder builder = new StringBuilder();
            for (String name : expected) {
                builder.append("'").append(name).append("', ");
            }
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbDelete.MongoField.Error.FieldsNotFoundInMetadata", (String[])new String[]{builder.toString()}));
        }
        boolean found = actual.removeAll(expected);
        if (!found) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbDelete.ErrorMessage.NotDeleteAnyFields", (String[])new String[0]));
        }
    }

    public void setWriteRetries(int writeRetries) {
        this.writeRetries = writeRetries;
    }
}

