/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.engines;

import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.engines.JarFileTypeFilename;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.pipeline.engines.EmptyPipelineRunConfiguration;

public abstract class BeamPipelineRunConfiguration
extends EmptyPipelineRunConfiguration
implements IBeamPipelineEngineRunConfiguration {
    @GuiWidgetElement(order="90000-general-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="User agent")
    @HopMetadataProperty
    protected String userAgent;
    @GuiWidgetElement(order="90010-general-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.FOLDER, label="Temp location")
    @HopMetadataProperty
    protected String tempLocation;
    @GuiWidgetElement(order="90050-general-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Streaming Hop transforms flush interval (ms)")
    @HopMetadataProperty
    protected String streamingHopTransformsFlushInterval;
    @GuiWidgetElement(order="90060-general-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="Hop streaming transforms buffer size")
    @HopMetadataProperty
    protected String streamingHopTransformsBufferSize;
    @GuiWidgetElement(order="90070-general-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.FILENAME, label="Fat jar file location", typeFilename=JarFileTypeFilename.class)
    @HopMetadataProperty
    protected String fatJar;

    public BeamPipelineRunConfiguration() {
        this.userAgent = "Hop";
        this.streamingHopTransformsFlushInterval = "-1";
        this.streamingHopTransformsBufferSize = "500";
    }

    public BeamPipelineRunConfiguration(String pluginId, String pluginName) {
        super(pluginId, pluginName);
    }

    public BeamPipelineRunConfiguration(BeamPipelineRunConfiguration config) {
        super((EmptyPipelineRunConfiguration)config);
        this.userAgent = config.userAgent;
        this.tempLocation = config.tempLocation;
        this.streamingHopTransformsFlushInterval = config.streamingHopTransformsFlushInterval;
        this.streamingHopTransformsBufferSize = config.streamingHopTransformsBufferSize;
        this.fatJar = config.fatJar;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getTempLocation() {
        return this.tempLocation;
    }

    public void setTempLocation(String tempLocation) {
        this.tempLocation = tempLocation;
    }

    public String getStreamingHopTransformsFlushInterval() {
        return this.streamingHopTransformsFlushInterval;
    }

    public void setStreamingHopTransformsFlushInterval(String streamingHopTransformsFlushInterval) {
        this.streamingHopTransformsFlushInterval = streamingHopTransformsFlushInterval;
    }

    public String getStreamingHopTransformsBufferSize() {
        return this.streamingHopTransformsBufferSize;
    }

    public void setStreamingHopTransformsBufferSize(String streamingHopTransformsBufferSize) {
        this.streamingHopTransformsBufferSize = streamingHopTransformsBufferSize;
    }

    public String getFatJar() {
        return this.fatJar;
    }

    public void setFatJar(String fatJar) {
        this.fatJar = fatJar;
    }
}

