/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.CoderHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.SideInputBroadcast;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SparkSideInputReader
implements SideInputReader {
    private static final Set<String> SUPPORTED_MATERIALIZATIONS = ImmutableSet.of((Object)"beam:side_input:iterable:v1", (Object)"beam:side_input:multimap:v1");
    private final Map<TupleTag<?>, WindowingStrategy<?, ?>> sideInputs;
    private final SideInputBroadcast broadcastStateData;

    public SparkSideInputReader(Map<PCollectionView<?>, WindowingStrategy<?, ?>> indexByView, SideInputBroadcast broadcastStateData) {
        for (PCollectionView<?> pCollectionView : indexByView.keySet()) {
            Preconditions.checkArgument((boolean)SUPPORTED_MATERIALIZATIONS.contains(pCollectionView.getViewFn().getMaterialization().getUrn()), (String)"This handler is only capable of dealing with %s materializations but was asked to handle %s for PCollectionView with tag %s.", SUPPORTED_MATERIALIZATIONS, (Object)pCollectionView.getViewFn().getMaterialization().getUrn(), (Object)pCollectionView.getTagInternal().getId());
        }
        this.sideInputs = new HashMap();
        for (Map.Entry entry : indexByView.entrySet()) {
            this.sideInputs.put(((PCollectionView)entry.getKey()).getTagInternal(), (WindowingStrategy)entry.getValue());
        }
        this.broadcastStateData = broadcastStateData;
    }

    public <T> @Nullable T get(PCollectionView<T> view, BoundedWindow window) {
        Preconditions.checkNotNull(view, (Object)"View passed to sideInput cannot be null");
        TupleTag tag = view.getTagInternal();
        Preconditions.checkNotNull(this.sideInputs.get(tag), (Object)("Side input for " + view + " not available."));
        List sideInputsValues = (List)this.broadcastStateData.getBroadcastValue(tag.getId()).getValue();
        Coder<?> coder = this.broadcastStateData.getCoder(tag.getId());
        ArrayList decodedValues = new ArrayList();
        for (byte[] value : sideInputsValues) {
            decodedValues.add((WindowedValue)CoderHelpers.fromByteArray(value, coder));
        }
        Map<BoundedWindow, T> sideInputs = this.initializeBroadcastVariable(decodedValues, view);
        T result = sideInputs.get(window);
        if (result == null) {
            switch (view.getViewFn().getMaterialization().getUrn()) {
                case "beam:side_input:iterable:v1": {
                    ViewFn viewFn = view.getViewFn();
                    return (T)viewFn.apply(() -> Collections.emptyList());
                }
                case "beam:side_input:multimap:v1": {
                    ViewFn viewFn = view.getViewFn();
                    return (T)viewFn.apply((Object)InMemoryMultimapSideInputView.empty());
                }
            }
            throw new IllegalStateException(String.format("Unknown side input materialization format requested '%s'", view.getViewFn().getMaterialization().getUrn()));
        }
        return result;
    }

    public <T> boolean contains(PCollectionView<T> view) {
        return this.sideInputs.containsKey(view.getTagInternal());
    }

    public boolean isEmpty() {
        return this.sideInputs.isEmpty();
    }

    private <T> Map<BoundedWindow, T> initializeBroadcastVariable(Iterable<WindowedValue<?>> inputValues, PCollectionView<T> view) {
        HashMap<BoundedWindow, List> partitionedElements = new HashMap<BoundedWindow, List>();
        for (WindowedValue<?> value : inputValues) {
            for (BoundedWindow window : value.getWindows()) {
                List windowedValues = partitionedElements.computeIfAbsent(window, k -> new ArrayList());
                windowedValues.add(value);
            }
        }
        HashMap<BoundedWindow, Object> resultMap = new HashMap<BoundedWindow, Object>();
        block10: for (Map.Entry elements : partitionedElements.entrySet()) {
            switch (view.getViewFn().getMaterialization().getUrn()) {
                case "beam:side_input:iterable:v1": {
                    ViewFn viewFn = view.getViewFn();
                    resultMap.put((BoundedWindow)elements.getKey(), viewFn.apply(() -> ((List)elements.getValue()).stream().map(WindowedValue::getValue).collect(Collectors.toList())));
                    continue block10;
                }
                case "beam:side_input:multimap:v1": {
                    ViewFn viewFn = view.getViewFn();
                    Coder keyCoder = ((KvCoder)view.getCoderInternal()).getKeyCoder();
                    resultMap.put((BoundedWindow)elements.getKey(), viewFn.apply((Object)InMemoryMultimapSideInputView.fromIterable((Coder)keyCoder, (Iterable)((List)elements.getValue()).stream().map(WindowedValue::getValue).collect(Collectors.toList()))));
                    continue block10;
                }
            }
            throw new IllegalStateException(String.format("Unknown side input materialization format requested '%s'", view.getViewFn().getMaterialization().getUrn()));
        }
        return resultMap;
    }
}

