/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import javax.annotation.Nullable;
import org.apache.beam.runners.spark.SparkContextOptions;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.coders.SparkRunnerKryoRegistrator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SparkContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SparkContextFactory.class);
    @Deprecated
    public static final String TEST_REUSE_SPARK_CONTEXT = "beam.spark.test.reuseSparkContext";
    @Nullable
    private static JavaSparkContext sparkContext;
    @Nullable
    private static String reusableSparkMaster;
    private static boolean hasProvidedSparkContext;

    private SparkContextFactory() {
    }

    public static synchronized void setProvidedSparkContext(JavaSparkContext providedSparkContext) {
        sparkContext = (JavaSparkContext)Preconditions.checkNotNull((Object)providedSparkContext);
        hasProvidedSparkContext = true;
        reusableSparkMaster = null;
    }

    public static synchronized void clearProvidedSparkContext() {
        hasProvidedSparkContext = false;
        sparkContext = null;
    }

    public static synchronized JavaSparkContext getSparkContext(SparkPipelineOptions options) {
        SparkContextOptions contextOptions = (SparkContextOptions)options.as(SparkContextOptions.class);
        if (contextOptions.getUsesProvidedSparkContext()) {
            JavaSparkContext jsc = contextOptions.getProvidedSparkContext();
            if (jsc != null) {
                SparkContextFactory.setProvidedSparkContext(jsc);
            } else if (hasProvidedSparkContext) {
                jsc = sparkContext;
            }
            if (jsc == null) {
                throw new IllegalStateException("No Spark context was provided. Use SparkContextFactor.setProvidedSparkContext to do so.");
            }
            if (jsc.sc().isStopped()) {
                LOG.error("The provided Spark context " + jsc + " was already stopped.");
                throw new IllegalStateException("The provided Spark context was already stopped");
            }
            LOG.info("Using a provided Spark Context");
            return jsc;
        }
        if (Boolean.getBoolean(TEST_REUSE_SPARK_CONTEXT)) {
            JavaSparkContext jsc = sparkContext;
            if (jsc == null || jsc.sc().isStopped()) {
                sparkContext = jsc = SparkContextFactory.createSparkContext(contextOptions);
                reusableSparkMaster = options.getSparkMaster();
                hasProvidedSparkContext = false;
            } else {
                if (hasProvidedSparkContext) {
                    throw new IllegalStateException("Usage of provided Spark context is disabled in SparkPipelineOptions.");
                }
                if (!options.getSparkMaster().equals(reusableSparkMaster)) {
                    throw new IllegalStateException(String.format("Cannot reuse spark context with different spark master URL. Existing: %s, requested: %s.", reusableSparkMaster, options.getSparkMaster()));
                }
            }
            return jsc;
        }
        JavaSparkContext jsc = SparkContextFactory.createSparkContext(contextOptions);
        SparkContextFactory.clearProvidedSparkContext();
        return jsc;
    }

    public static synchronized void stopSparkContext(JavaSparkContext context) {
        if (!Boolean.getBoolean(TEST_REUSE_SPARK_CONTEXT) && !hasProvidedSparkContext) {
            context.stop();
        }
    }

    private static JavaSparkContext createSparkContext(SparkPipelineOptions options) {
        LOG.info("Creating a brand new Spark Context.");
        SparkConf conf = new SparkConf();
        if (!conf.contains("spark.master")) {
            conf.setMaster(options.getSparkMaster());
        }
        if (options.getFilesToStage() != null && !options.getFilesToStage().isEmpty()) {
            conf.setJars(options.getFilesToStage().toArray(new String[0]));
        }
        conf.setAppName(options.getAppName());
        conf.set("spark.kryo.registrator", SparkRunnerKryoRegistrator.class.getName());
        JavaSparkContext jsc = new JavaSparkContext(conf);
        if (jsc.sc().version().startsWith("2")) {
            LOG.warn("Support for Spark 2 is deprecated, this runner will be removed in a few releases.\nSpark 2 is reaching its EOL, consider migrating to Spark 3.");
        }
        return jsc;
    }
}

